/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp;

import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLog;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLogEntry;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.BmpAdapterCommon;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp.BmpMessageHandler;
import org.opennms.netmgt.telemetry.protocols.collection.AbstractCollectionAdapter;
import org.opennms.netmgt.telemetry.protocols.collection.CollectionSetWithAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmpIntegrationAdapter
extends AbstractCollectionAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(BmpIntegrationAdapter.class);
    private final AtomicLong sequence = new AtomicLong();
    private final BmpMessageHandler messageHandler;

    public BmpIntegrationAdapter(AdapterDefinition adapterConfig, MetricRegistry metricRegistry, BmpMessageHandler messageHandler) {
        super(adapterConfig, metricRegistry);
        this.messageHandler = Objects.requireNonNull(messageHandler);
    }

    public Stream<CollectionSetWithAgent> handleCollectionMessage(TelemetryMessageLogEntry messageLogEntry, TelemetryMessageLog messageLog) {
        BmpAdapterCommon.handleBmpMessage(messageLogEntry, messageLog, this.messageHandler, this.sequence);
        return Stream.empty();
    }

    public void destroy() {
        this.messageHandler.close();
        super.destroy();
    }
}

