/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.upgrade.api.AbstractOnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequisitionsMigratorOffline
extends AbstractOnmsUpgrade {
    private static final Logger LOG = LoggerFactory.getLogger(RequisitionsMigratorOffline.class);
    private File requisitionDir;

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public String getDescription() {
        return "Remove non-ip-snmp-primary and non-ip-interfaces from requisitions: NMS-5630, NMS-5571";
    }

    @Override
    public boolean requiresOnmsRunning() {
        return false;
    }

    @Override
    public void preExecute() throws OnmsUpgradeException {
        this.log("Backing up: %s\n", this.getRequisitionDir());
        this.zipDir(this.getBackupFile(), this.getRequisitionDir());
    }

    @Override
    public void postExecute() throws OnmsUpgradeException {
        File zip = this.getBackupFile();
        if (zip.exists()) {
            this.log("Removing backup %s\n", zip);
            if (!zip.delete()) {
                LOG.warn("Could not delete file: {}", (Object)zip.getPath());
            }
        }
    }

    @Override
    public void rollback() throws OnmsUpgradeException {
        File zip = this.getBackupFile();
        this.unzipFile(zip, this.getRequisitionDir());
        if (!zip.delete()) {
            LOG.warn("Could not delete file: {}", (Object)zip.getPath());
        }
    }

    @Override
    public void execute() throws OnmsUpgradeException {
        try {
            for (File req : FileUtils.listFiles((File)this.getRequisitionDir(), (String[])new String[]{"xml"}, (boolean)true)) {
                this.log("Processing %s\n", req);
                String content = IOUtils.toString((InputStream)new FileInputStream(req), (Charset)StandardCharsets.UTF_8);
                String output = content.replaceAll(" non-ip-(snmp-primary|interfaces)=\"[^\"]+\"", "");
                if (content.length() == output.length()) continue;
                this.log("  Updating and parsing the requisition\n", req);
                IOUtils.write((String)output, (OutputStream)new FileOutputStream(req), (Charset)StandardCharsets.UTF_8);
                Requisition requisition = (Requisition)JaxbUtils.unmarshal(Requisition.class, (File)req, (boolean)true);
                if (requisition != null) continue;
                throw new OnmsUpgradeException("Can't parse requisition " + req);
            }
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't upgrade requisitions because " + e.getMessage(), e);
        }
    }

    private File getRequisitionDir() {
        if (this.requisitionDir == null) {
            this.requisitionDir = new File(ConfigFileConstants.getFilePathString() + "imports");
        }
        return this.requisitionDir;
    }

    private File getBackupFile() {
        return new File(this.getRequisitionDir().getAbsoluteFile() + ".zip");
    }
}

