/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.blueprint.cm;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.aries.blueprint.compendium.cm.CmPropertyPlaceholder;
import org.apache.xbean.blueprint.cm.JexlExpressionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JexlPropertyPlaceholder
extends CmPropertyPlaceholder {
    private static final Logger LOGGER = LoggerFactory.getLogger(JexlPropertyPlaceholder.class);
    private transient JexlExpressionParser parser;

    protected String processString(String str) {
        LOGGER.debug("Processing {} from configuration with pid {}", (Object)str, (Object)this.getPersistentId());
        JexlExpressionParser parser = this.getParser();
        try {
            return parser.evaluate(str).toString();
        }
        catch (Exception e) {
            LOGGER.info("Could not evaluate expressions {}  for {}", (Object)str, (Object)this.getPersistentId());
            LOGGER.info("Exception:", (Throwable)e);
            return str;
        }
    }

    protected synchronized JexlExpressionParser getParser() {
        if (this.parser == null) {
            this.parser = new JexlExpressionParser(this.toMap());
        }
        return this.parser;
    }

    private Map<String, Object> toMap() {
        return new ConfigMap();
    }

    private class ConfigMap
    implements Map<String, Object> {
        private ConfigMap() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object o) {
            return JexlPropertyPlaceholder.this.getProperty((String)o) != null;
        }

        @Override
        public boolean containsValue(Object o) {
            return false;
        }

        @Override
        public Object get(Object o) {
            return JexlPropertyPlaceholder.this.getProperty((String)o);
        }

        @Override
        public Object put(String s, Object o) {
            return null;
        }

        @Override
        public Object remove(Object o) {
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> map) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<String> keySet() {
            return null;
        }

        @Override
        public Collection<Object> values() {
            return null;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return null;
        }
    }
}

