/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.amqp.common;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicallyTrackedProcessor
implements Processor {
    public static final Logger LOG = LoggerFactory.getLogger(DynamicallyTrackedProcessor.class);
    private BundleContext m_context;
    private ServiceTracker<?, Processor> m_tracker = null;
    private String m_processorName;

    public void process(Exchange exchange) throws Exception {
        Processor processor;
        if (this.m_tracker == null) {
            String filterString = String.format("(&(%s=%s)(name=%s))", "objectClass", Processor.class.getName(), this.m_processorName);
            Filter filter = this.m_context.createFilter(filterString);
            LOG.info("Starting tracker with filter: {}", (Object)filterString);
            this.m_tracker = new ServiceTracker(this.m_context, filter, null);
            this.m_tracker.open();
        }
        if ((processor = (Processor)this.m_tracker.getService()) == null) {
            throw new Exception("No suitable processer service was found with name: " + this.m_processorName);
        }
        processor.process(exchange);
    }

    public void setContext(BundleContext context) {
        this.m_context = context;
    }

    public void setProcessorName(String processorName) {
        this.m_processorName = processorName;
    }

    public void destroy() {
        if (this.m_tracker != null) {
            this.m_tracker.close();
        }
    }
}

