/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.system;

import java.util.Map;
import java.util.TreeMap;
import org.opennms.systemreport.AbstractSystemReportPlugin;
import org.springframework.core.io.Resource;

public class LsofReportPlugin
extends AbstractSystemReportPlugin {
    @Override
    public String getName() {
        return "lsof";
    }

    @Override
    public String getDescription() {
        return "Output of the 'lsof' command (full output only)";
    }

    @Override
    public int getPriority() {
        return 12;
    }

    @Override
    public boolean getFullOutputOnly() {
        return true;
    }

    @Override
    public boolean getOutputsFiles() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public Map<String, Resource> getEntries() {
        TreeMap<String, Resource> map = new TreeMap<String, Resource>();
        String lsofOutput = null;
        String lsof = this.getResourceLocator().findBinary("lsof");
        if (lsof != null) {
            lsofOutput = this.getResourceLocator().slurpOutput(lsof, false);
        }
        if (lsofOutput != null) {
            map.put("Output", this.getResource(lsofOutput));
        }
        return map;
    }
}

