/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.sanitizer;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.systemreport.sanitizer.ConfigFileSanitizer;
import org.opennms.systemreport.sanitizer.FileSanitizationException;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class PropertiesFileSanitizer
implements ConfigFileSanitizer {
    private static final Set<String> PROPERTIES_TO_SANITIZE = new LinkedHashSet<String>(Arrays.asList("password", "pass", "authenticatePassword", "truststorePassword"));
    protected final String SANITIZED_VALUE = "***";

    @Override
    public String getFileName() {
        return "*.properties";
    }

    @Override
    public Resource getSanitizedResource(File file) throws FileSanitizationException {
        ByteArrayResource byteArrayResource;
        FileInputStream fis = new FileInputStream(file);
        try {
            Properties properties = new Properties();
            properties.load(fis);
            this.sanitizeProperties(properties);
            byteArrayResource = new ByteArrayResource(this.getOutput(properties).getBytes());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fis).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new FileSanitizationException("Could not sanitize file", e);
            }
        }
        ((InputStream)fis).close();
        return byteArrayResource;
    }

    protected void sanitizeProperties(Properties properties) {
        properties.stringPropertyNames().forEach(propertyName -> {
            String lastPart = propertyName.substring(propertyName.lastIndexOf(".") + 1);
            if (PROPERTIES_TO_SANITIZE.contains(lastPart)) {
                properties.setProperty((String)propertyName, "***");
            }
        });
    }

    protected String getOutput(Properties properties) {
        return properties.entrySet().stream().map(entry -> entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining("\n"));
    }
}

