/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.jdbc.JdbcDataCollectionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class JdbcDataCollectionConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcDataCollectionConfigFactory.class);
    private JdbcDataCollectionConfig m_jdbcDataCollectionConfig = null;

    public JdbcDataCollectionConfigFactory() {
        try {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.JDBC_COLLECTION_CONFIG_FILE_NAME);
            LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
            FileInputStream reader = new FileInputStream(cfgFile);
            this.unmarshall(reader);
            ((InputStream)reader).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public JdbcDataCollectionConfig unmarshall(InputStream configFile) {
        try {
            this.m_jdbcDataCollectionConfig = (JdbcDataCollectionConfig)JaxbUtils.unmarshal(JdbcDataCollectionConfig.class, (InputSource)new InputSource(configFile));
            return this.m_jdbcDataCollectionConfig;
        }
        catch (Throwable throwable) {
            return this.m_jdbcDataCollectionConfig;
        }
    }
}

