/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.karaf.profile.LockHandle;
import org.apache.karaf.profile.PlaceholderResolver;
import org.apache.karaf.profile.Profile;
import org.apache.karaf.profile.ProfileService;
import org.apache.karaf.profile.impl.Profiles;
import org.apache.karaf.profile.impl.Utils;

public class ProfileServiceImpl
implements ProfileService {
    private static final long ACQUIRE_LOCK_TIMEOUT = 25000L;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final List<PlaceholderResolver> resolvers = new CopyOnWriteArrayList<PlaceholderResolver>();
    private final Path profilesDirectory;
    private Map<String, Profile> cache;

    public ProfileServiceImpl(Path profilesDirectory) throws IOException {
        this.profilesDirectory = profilesDirectory;
        Files.createDirectories(profilesDirectory, new FileAttribute[0]);
    }

    @Override
    public LockHandle acquireWriteLock() {
        return this.acquireLock(this.getLock().writeLock(), "Cannot obtain profile write lock in time");
    }

    @Override
    public LockHandle acquireReadLock() {
        return this.acquireLock(this.getLock().readLock(), "Cannot obtain profile read lock in time");
    }

    protected LockHandle acquireLock(Lock lock, String message) {
        try {
            if (!lock.tryLock(25000L, TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException(message);
            }
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(message, ex);
        }
        return lock::unlock;
    }

    protected ReadWriteLock getLock() {
        return this.readWriteLock;
    }

    @Override
    public void registerResolver(PlaceholderResolver resolver) {
        this.resolvers.add(resolver);
    }

    @Override
    public void unregisterResolver(PlaceholderResolver resolver) {
        this.resolvers.remove(resolver);
    }

    @Override
    public void createProfile(Profile profile) {
        Utils.assertNotNull(profile, "profile is null");
        try (LockHandle lock = this.acquireWriteLock();){
            String profileId = profile.getId();
            Utils.assertFalse(this.hasProfile(profileId), "Profile already exists: " + profileId);
            this.createOrUpdateProfile(null, profile);
        }
    }

    @Override
    public void updateProfile(Profile profile) {
        Utils.assertNotNull(profile, "profile is null");
        try (LockHandle lock = this.acquireWriteLock();){
            String profileId = profile.getId();
            Profile lastProfile = this.getRequiredProfile(profileId);
            this.createOrUpdateProfile(lastProfile, profile);
        }
    }

    @Override
    public boolean hasProfile(String profileId) {
        Utils.assertNotNull(profileId, "profileId is null");
        try (LockHandle lock = this.acquireReadLock();){
            Profile profile = this.getProfileFromCache(profileId);
            boolean bl = profile != null;
            return bl;
        }
    }

    @Override
    public Profile getProfile(String profileId) {
        Utils.assertNotNull(profileId, "profileId is null");
        try (LockHandle lock = this.acquireReadLock();){
            Profile profile = this.getProfileFromCache(profileId);
            return profile;
        }
    }

    @Override
    public Profile getRequiredProfile(String profileId) {
        Utils.assertNotNull(profileId, "profileId is null");
        try (LockHandle lock = this.acquireReadLock();){
            Profile profile = this.getProfileFromCache(profileId);
            Utils.assertNotNull(profile, "Profile does not exist: " + profileId);
            Profile profile2 = profile;
            return profile2;
        }
    }

    @Override
    public Collection<String> getProfiles() {
        try (LockHandle lock = this.acquireReadLock();){
            Collection<String> profiles = this.getProfilesFromCache();
            Collection<String> collection = Collections.unmodifiableCollection(profiles);
            return collection;
        }
    }

    @Override
    public void deleteProfile(String profileId) {
        Utils.assertNotNull(profileId, "profileId is null");
        try (LockHandle lock = this.acquireWriteLock();){
            Profile lastProfile = this.getRequiredProfile(profileId);
            this.deleteProfileFromCache(lastProfile);
        }
    }

    @Override
    public Profile getOverlayProfile(Profile profile) {
        return Profiles.getOverlay(profile, this.loadCache());
    }

    @Override
    public Profile getOverlayProfile(Profile profile, String environment) {
        return Profiles.getOverlay(profile, this.loadCache(), environment);
    }

    @Override
    public Profile getEffectiveProfile(Profile profile) {
        return Profiles.getEffective(profile, this.resolvers);
    }

    @Override
    public Profile getEffectiveProfile(Profile profile, boolean defaultsToEmptyString) {
        return Profiles.getEffective(profile, this.resolvers, defaultsToEmptyString);
    }

    protected void createOrUpdateProfile(Profile lastProfile, Profile profile) {
        if (lastProfile != null) {
            this.deleteProfileFromCache(lastProfile);
        }
        try {
            this.loadCache();
            for (String parentId : profile.getParentIds()) {
                if (this.cache.containsKey(parentId)) continue;
                throw new IllegalStateException("Parent profile " + parentId + " does not exist");
            }
            Profiles.writeProfile(this.profilesDirectory, profile);
            if (this.cache != null) {
                this.cache.put(profile.getId(), profile);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error writing profiles", e);
        }
    }

    protected Profile getProfileFromCache(String profileId) {
        return this.loadCache().get(profileId);
    }

    protected Collection<String> getProfilesFromCache() {
        return this.loadCache().keySet();
    }

    protected void deleteProfileFromCache(Profile lastProfile) {
        this.loadCache();
        ArrayList<String> children = new ArrayList<String>();
        for (Profile p : this.cache.values()) {
            if (!p.getParentIds().contains(lastProfile.getId())) continue;
            children.add(p.getId());
        }
        if (!children.isEmpty()) {
            throw new IllegalStateException("Profile " + lastProfile.getId() + " is a parent of " + Utils.join(", ", children));
        }
        try {
            Profiles.deleteProfile(this.profilesDirectory, lastProfile.getId());
            this.cache.remove(lastProfile.getId());
        }
        catch (IOException e) {
            this.cache = null;
            throw new IllegalStateException("Error deleting profiles", e);
        }
    }

    protected Map<String, Profile> loadCache() {
        if (this.cache == null) {
            try {
                this.cache = Profiles.loadProfiles(this.profilesDirectory);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error reading profiles", e);
            }
        }
        return this.cache;
    }
}

