/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.common;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.enlinkd.common.NodeCollector;
import org.opennms.netmgt.enlinkd.service.api.Node;
import org.opennms.netmgt.enlinkd.service.api.NodeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.scheduler.LegacyPriorityExecutor;
import org.opennms.netmgt.scheduler.SchedulableExecutableGroup;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;

public abstract class SchedulableNodeCollectorGroup
extends SchedulableExecutableGroup {
    private final ProtocolSupported m_protocolSupported;
    private final NodeTopologyService m_nodeTopologyService;
    private final LocationAwareSnmpClient m_locationAwareSnmpClient;
    private final int m_priority;
    private final Set<Integer> m_suspended = new HashSet<Integer>();

    public SchedulableNodeCollectorGroup(long interval, long initial, LegacyPriorityExecutor executor, int priority, ProtocolSupported protocolSupported, NodeTopologyService nodeTopologyService, LocationAwareSnmpClient locationAwareSnmpClient) {
        super(interval, initial, executor, protocolSupported.name());
        this.m_protocolSupported = protocolSupported;
        this.m_nodeTopologyService = nodeTopologyService;
        this.m_locationAwareSnmpClient = locationAwareSnmpClient;
        this.m_priority = priority;
    }

    public void suspend(Integer nodeid) {
        this.m_suspended.add(nodeid);
    }

    public void wakeUp(Integer nodeid) {
        this.m_suspended.remove(nodeid);
    }

    public Map<Integer, Integer> getPriorityMap() {
        return this.m_nodeTopologyService.getNodeidPriorityMap(this.m_protocolSupported);
    }

    public ProtocolSupported getProtocolSupported() {
        return this.m_protocolSupported;
    }

    public NodeTopologyService getNodeTopologyService() {
        return this.m_nodeTopologyService;
    }

    public abstract NodeCollector getNodeCollector(Node var1, int var2);

    private int getMaxPriority(Collection<Integer> priorities) {
        if (priorities.size() == 0) {
            return 0;
        }
        return Collections.max(priorities);
    }

    public void runSchedulable() {
        Map<Integer, Integer> priorityMap = this.getPriorityMap();
        Integer maxPriority = this.getMaxPriority(priorityMap.values());
        this.m_nodeTopologyService.findAllSnmpNode().stream().filter(node -> !this.m_suspended.contains(node.getNodeId())).forEach(node -> this.add(this.getNodeCollector((Node)node, priorityMap.getOrDefault(node.getNodeId(), maxPriority) + this.m_priority)));
        super.runSchedulable();
    }

    public LocationAwareSnmpClient getLocationAwareSnmpClient() {
        return this.m_locationAwareSnmpClient;
    }
}

