/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.restrictions.AllRestriction;
import org.opennms.core.criteria.restrictions.AnyRestriction;
import org.opennms.core.criteria.restrictions.AttributeRestriction;
import org.opennms.core.criteria.restrictions.BaseRestrictionVisitor;
import org.opennms.core.criteria.restrictions.BetweenRestriction;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.GeRestriction;
import org.opennms.core.criteria.restrictions.GtRestriction;
import org.opennms.core.criteria.restrictions.IlikeRestriction;
import org.opennms.core.criteria.restrictions.InRestriction;
import org.opennms.core.criteria.restrictions.IplikeRestriction;
import org.opennms.core.criteria.restrictions.LeRestriction;
import org.opennms.core.criteria.restrictions.LikeRestriction;
import org.opennms.core.criteria.restrictions.LtRestriction;
import org.opennms.core.criteria.restrictions.NeRestriction;
import org.opennms.core.criteria.restrictions.NotNullRestriction;
import org.opennms.core.criteria.restrictions.NotRestriction;
import org.opennms.core.criteria.restrictions.NullRestriction;
import org.opennms.core.criteria.restrictions.RegExpRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.RestrictionVisitor;
import org.opennms.core.criteria.restrictions.SqlRestriction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

final class BeanWrapperRestrictionVisitor
extends BaseRestrictionVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(BeanWrapperRestrictionVisitor.class);
    private final Object m_entity;
    private final List<Alias> m_aliases;
    private final BeanWrapper m_beanWrapper;
    private boolean m_matched = true;
    private boolean m_stillMatched;

    public BeanWrapperRestrictionVisitor(Object obj) {
        this(obj, null);
    }

    public BeanWrapperRestrictionVisitor(Object obj, List<Alias> aliases) {
        this.m_entity = obj;
        this.m_aliases = aliases;
        this.m_beanWrapper = new BeanWrapperImpl(this.m_entity);
    }

    protected void fail(Restriction restriction) {
        this.m_matched = false;
        LOG.debug("{} failed restriction: {}", this.m_entity, (Object)restriction);
    }

    public Object getProperty(String attribute) {
        LOG.debug("getProperty({})", (Object)attribute);
        String[] attributes = attribute.split("\\.", 2);
        LOG.debug("attributes = {}", Arrays.asList(attributes));
        if (attributes.length == 1) {
            for (PropertyDescriptor pd : this.m_beanWrapper.getPropertyDescriptors()) {
                if (pd.getName().equalsIgnoreCase(attribute)) {
                    return this.m_beanWrapper.getPropertyValue(pd.getName());
                }
                for (Alias alias : this.m_aliases) {
                    if (!alias.getAlias().equalsIgnoreCase(attribute) || !pd.getName().equalsIgnoreCase(alias.getAssociationPath())) continue;
                    return this.m_beanWrapper.getPropertyValue(pd.getName());
                }
            }
        } else if (attributes.length > 1) {
            LOG.debug("more than one attribute, try walking the tree");
            for (PropertyDescriptor pd : this.m_beanWrapper.getPropertyDescriptors()) {
                String attributeName = attributes[0];
                String subAttributes = attributes[1];
                if (pd.getName().equalsIgnoreCase(attributeName)) {
                    Object propertyValue = this.m_beanWrapper.getPropertyValue(pd.getName());
                    BeanWrapperRestrictionVisitor subVisitor = new BeanWrapperRestrictionVisitor(propertyValue, this.m_aliases);
                    Object property = subVisitor.getProperty(subAttributes);
                    LOG.debug("Found a sub-attribute: {} = {}", (Object)attribute, property);
                    return property;
                }
                for (Alias alias : this.m_aliases) {
                    String aliasName = alias.getAlias();
                    String aliasPath = alias.getAssociationPath();
                    if (!aliasName.equalsIgnoreCase(attributeName) || !pd.getName().equalsIgnoreCase(aliasPath)) continue;
                    Object propertyValue = this.m_beanWrapper.getPropertyValue(pd.getName());
                    BeanWrapperRestrictionVisitor subVisitor = new BeanWrapperRestrictionVisitor(propertyValue, this.m_aliases);
                    Object property = subVisitor.getProperty(subAttributes);
                    LOG.debug("Found a sub-attribute: {} = {}", (Object)attribute, property);
                    return property;
                }
            }
        } else {
            LOG.warn("Uhh... 0 attributes?  How did we get here?");
        }
        return null;
    }

    protected Object getProperty(AttributeRestriction restriction) {
        return this.getProperty(restriction.getAttribute());
    }

    public void visitNull(NullRestriction restriction) {
        if (this.getProperty((AttributeRestriction)restriction) != null) {
            this.fail((Restriction)restriction);
        }
    }

    public void visitNullComplete(NullRestriction restriction) {
    }

    public void visitNotNull(NotNullRestriction restriction) {
        if (this.getProperty((AttributeRestriction)restriction) == null) {
            this.fail((Restriction)restriction);
        }
    }

    public void visitNotNullComplete(NotNullRestriction restriction) {
    }

    public void visitEq(EqRestriction restriction) {
        Object o = this.getProperty((AttributeRestriction)restriction);
        if (o instanceof Comparable) {
            try {
                Comparable oC = (Comparable)o;
                Comparable oV = (Comparable)restriction.getValue();
                int comparison = oC.compareTo(oV);
                LOG.debug("comparison = {}", (Object)comparison);
                if (comparison == 0) {
                    return;
                }
            }
            catch (ClassCastException classCastException) {}
        } else if (restriction.getValue().equals(o)) {
            return;
        }
        this.fail((Restriction)restriction);
    }

    public void visitEqComplete(EqRestriction restriction) {
    }

    public void visitNe(NeRestriction restriction) {
        Object o = this.getProperty((AttributeRestriction)restriction);
        if (o instanceof Comparable) {
            try {
                Comparable oC = (Comparable)o;
                Comparable oV = (Comparable)restriction.getValue();
                int comparison = oC.compareTo(oV);
                if (comparison != 0) {
                    return;
                }
            }
            catch (ClassCastException classCastException) {}
        } else if (!restriction.getValue().equals(o)) {
            return;
        }
        this.fail((Restriction)restriction);
    }

    public void visitNeComplete(NeRestriction restriction) {
    }

    public void visitGt(GtRestriction restriction) {
        Object o = this.getProperty((AttributeRestriction)restriction);
        if (o instanceof Number && restriction.getValue() instanceof Number) {
            BigDecimal right;
            BigDecimal left = new BigDecimal(((Number)o).doubleValue());
            if (left.compareTo(right = new BigDecimal(((Number)restriction.getValue()).doubleValue())) == 1) {
                return;
            }
        } else if (o instanceof Comparable) {
            try {
                Comparable oC = (Comparable)o;
                Comparable oV = (Comparable)restriction.getValue();
                if (oC.compareTo(oV) > 0) {
                    return;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.fail((Restriction)restriction);
    }

    public void visitGtComplete(GtRestriction restriction) {
    }

    public void visitGe(GeRestriction restriction) {
        Object o = this.getProperty((AttributeRestriction)restriction);
        if (o instanceof Number && restriction.getValue() instanceof Number) {
            BigDecimal right;
            BigDecimal left = new BigDecimal(((Number)o).doubleValue());
            if (left.compareTo(right = new BigDecimal(((Number)restriction.getValue()).doubleValue())) >= 0) {
                return;
            }
        } else if (o instanceof Comparable) {
            try {
                Comparable oC = (Comparable)o;
                Comparable oV = (Comparable)restriction.getValue();
                if (oC.compareTo(oV) >= 0) {
                    return;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.fail((Restriction)restriction);
    }

    public void visitGeComplete(GeRestriction restriction) {
    }

    public void visitLt(LtRestriction restriction) {
        Object o = this.getProperty((AttributeRestriction)restriction);
        if (o instanceof Number && restriction.getValue() instanceof Number) {
            BigDecimal right;
            BigDecimal left = new BigDecimal(((Number)o).doubleValue());
            if (left.compareTo(right = new BigDecimal(((Number)restriction.getValue()).doubleValue())) == -1) {
                return;
            }
        } else if (o instanceof Comparable) {
            try {
                Comparable oC = (Comparable)o;
                Comparable oV = (Comparable)restriction.getValue();
                if (oC.compareTo(oV) < 0) {
                    return;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.fail((Restriction)restriction);
    }

    public void visitLtComplete(LtRestriction restriction) {
    }

    public void visitLe(LeRestriction restriction) {
        Object o = this.getProperty((AttributeRestriction)restriction);
        if (o instanceof Number && restriction.getValue() instanceof Number) {
            BigDecimal right;
            BigDecimal left = new BigDecimal(((Number)o).doubleValue());
            if (left.compareTo(right = new BigDecimal(((Number)restriction.getValue()).doubleValue())) <= 0) {
                return;
            }
        } else if (o instanceof Comparable) {
            try {
                Comparable oC = (Comparable)o;
                Comparable oV = (Comparable)restriction.getValue();
                if (oC.compareTo(oV) <= 0) {
                    return;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.fail((Restriction)restriction);
    }

    public void visitLeComplete(LeRestriction restriction) {
    }

    public void visitAll(AllRestriction restriction) {
        for (Restriction r : restriction.getRestrictions()) {
            r.visit((RestrictionVisitor)this);
        }
    }

    public void visitAllComplete(AllRestriction restriction) {
    }

    public void visitAny(AnyRestriction restriction) {
        boolean matched = false;
        for (Restriction r : restriction.getRestrictions()) {
            try {
                r.visit((RestrictionVisitor)this);
                matched = true;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (!matched) {
            this.fail((Restriction)restriction);
        }
    }

    public void visitAnyComplete(AnyRestriction restriction) {
    }

    public void visitLike(LikeRestriction restriction) {
        throw new UnsupportedOperationException("Not Yet Implemented!");
    }

    public void visitLikeComplete(LikeRestriction restriction) {
    }

    public void visitIlike(IlikeRestriction restriction) {
        throw new UnsupportedOperationException("Not Yet Implemented!");
    }

    public void visitIlikeComplete(IlikeRestriction restriction) {
    }

    public void visitIn(InRestriction restriction) {
        throw new UnsupportedOperationException("Not Yet Implemented!");
    }

    public void visitInComplete(InRestriction restriction) {
    }

    public void visitNot(NotRestriction restriction) {
        this.m_stillMatched = this.m_matched;
    }

    public void visitNotComplete(NotRestriction restriction) {
        if (this.m_stillMatched) {
            this.m_matched = !this.m_matched;
        }
    }

    public void visitBetween(BetweenRestriction restriction) {
        throw new UnsupportedOperationException("Not Yet Implemented!");
    }

    public void visitBetweenComplete(BetweenRestriction restriction) {
    }

    public void visitSql(SqlRestriction restriction) {
        throw new UnsupportedOperationException("Not Yet Implemented!");
    }

    public void visitSqlComplete(SqlRestriction restriction) {
    }

    public void visitIplike(IplikeRestriction restriction) {
        throw new UnsupportedOperationException("Not Yet Implemented!");
    }

    public void visitIplikeComplete(IplikeRestriction restriction) {
    }

    public void visitRegExp(RegExpRestriction restriction) {
        throw new UnsupportedOperationException("Not Yet Implemented!");
    }

    public boolean matches() {
        return this.m_matched;
    }
}

