/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.dao.api;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opennms.features.config.exception.SchemaConversionException;

public class ConfigItem {
    private String name;
    private String schemaRef;
    private Type type;
    private List<ConfigItem> children = new LinkedList<ConfigItem>();
    private Long min = null;
    private Long max = null;
    private boolean maxExclusive = false;
    private boolean minExclusive = false;
    private Long multipleOf = null;
    private String pattern;
    private Object defaultValue;
    private String documentation;
    private List<String> enumValues;
    private boolean required = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSchemaRef() {
        return this.schemaRef;
    }

    public void setSchemaRef(String schemaRef) {
        this.schemaRef = schemaRef;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isPrimitiveType() {
        switch (this.getType()) {
            case STRING: 
            case NUMBER: 
            case INTEGER: 
            case LONG: 
            case BOOLEAN: 
            case DATE: 
            case DATE_TIME: 
            case POSITIVE_INTEGER: 
            case NON_NEGATIVE_INTEGER: 
            case NEGATIVE_INTEGER: {
                return true;
            }
        }
        return false;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public List<ConfigItem> getChildren() {
        return this.children;
    }

    public Optional<ConfigItem> getChild(String name) {
        Objects.requireNonNull(name);
        if (this.children == null) {
            return Optional.empty();
        }
        return this.children.stream().filter(item -> name.equals(item.getName())).findAny();
    }

    public void setChildren(List<ConfigItem> children) {
        this.children = children;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public Long getMin() {
        return this.min;
    }

    public void setMin(Long min) {
        this.min = min;
    }

    public Long getMax() {
        return this.max;
    }

    public void setMax(Long max) {
        this.max = max;
    }

    public boolean isMaxExclusive() {
        return this.maxExclusive;
    }

    public void setMaxExclusive(boolean maxExclusive) {
        this.maxExclusive = maxExclusive;
    }

    public boolean isMinExclusive() {
        return this.minExclusive;
    }

    public void setMinExclusive(boolean minExclusive) {
        this.minExclusive = minExclusive;
    }

    public Long getMultipleOf() {
        return this.multipleOf;
    }

    public void setMultipleOf(Long multipleOf) {
        if (multipleOf < 0L) {
            throw new SchemaConversionException("multipleOf must > 0");
        }
        this.multipleOf = multipleOf;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public List<String> getEnumValues() {
        return this.enumValues;
    }

    public void setEnumValues(List<String> enumValues) {
        this.enumValues = enumValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigItem that = (ConfigItem)o;
        return this.required == that.required && Objects.equals(this.name, that.name) && Objects.equals(this.schemaRef, that.schemaRef) && this.type == that.type && Objects.equals(this.children, that.children) && Objects.equals(this.max, that.max) && Objects.equals(this.min, that.min) && Objects.equals(this.pattern, that.pattern) && Objects.equals(this.multipleOf, that.multipleOf) && Objects.equals(this.enumValues, that.enumValues);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.schemaRef, this.type, this.children, this.required});
    }

    public String toString() {
        return "ConfigItem{name='" + this.name + "', schemaRef='" + this.schemaRef + "', type=" + this.type + ", children=" + this.children + ", required=" + this.required + ", min=" + this.min + ", max=" + this.max + ", pattern=" + this.pattern + ", multipleOf=" + this.multipleOf + ", enumValues=" + this.enumValues + "}";
    }

    public static enum Type {
        OBJECT,
        ARRAY,
        STRING,
        NUMBER,
        INTEGER,
        LONG,
        BOOLEAN,
        DATE,
        DATE_TIME,
        POSITIVE_INTEGER,
        NON_NEGATIVE_INTEGER,
        NEGATIVE_INTEGER,
        ANY_TYPE,
        SIMPLE_TYPE;


        public boolean isSimple() {
            return !this.equals((Object)OBJECT) && !this.equals((Object)ARRAY);
        }
    }
}

