/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.impl;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jrobin.core.RrdException;
import org.jrobin.data.DataProcessor;
import org.opennms.netmgt.measurements.api.FetchResults;
import org.opennms.netmgt.measurements.impl.AbstractRrdBasedFetchStrategy;
import org.opennms.netmgt.measurements.model.QueryMetadata;
import org.opennms.netmgt.measurements.model.Source;

public class JrobinFetchStrategy
extends AbstractRrdBasedFetchStrategy {
    @Override
    protected FetchResults fetchMeasurements(long start, long end, long step, int maxrows, Map<Source, String> rrdsBySource, Map<String, Object> constants, QueryMetadata metadata) throws RrdException {
        long startInSeconds = (long)Math.floor((double)start / 1000.0);
        long endInSeconds = (long)Math.floor((double)end / 1000.0);
        long stepInSeconds = (long)Math.floor((double)step / 1000.0);
        if (stepInSeconds <= 0L) {
            stepInSeconds = 1L;
        }
        DataProcessor dproc = new DataProcessor(startInSeconds, endInSeconds);
        if (maxrows > 0) {
            dproc.setPixelCount(maxrows);
        }
        dproc.setFetchRequestResolution(stepInSeconds);
        for (Map.Entry<Source, String> entry : rrdsBySource.entrySet()) {
            Source source = entry.getKey();
            String rrdFile = entry.getValue();
            if (source.getEffectiveDataSource().length() > 19) {
                source.setDataSource(source.getEffectiveDataSource().substring(0, 19));
            }
            dproc.addDatasource(source.getLabel(), rrdFile, source.getEffectiveDataSource(), source.getAggregation());
        }
        try {
            dproc.processData();
        }
        catch (IOException e) {
            throw new RrdException("JRB processing failed.", (Throwable)e);
        }
        long[] timestamps = dproc.getTimestamps();
        int i = 0;
        while (i < timestamps.length) {
            int n = i++;
            timestamps[n] = timestamps[n] * 1000L;
        }
        HashMap columns = Maps.newHashMapWithExpectedSize((int)rrdsBySource.keySet().size());
        for (Source source : rrdsBySource.keySet()) {
            columns.put(source.getLabel(), dproc.getValues(source.getLabel()));
        }
        return new FetchResults(timestamps, (Map)columns, dproc.getStep() * 1000L, constants, metadata);
    }
}

