/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl.holtwinters;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersSeasonalityType;
import org.springframework.util.Assert;

public class HoltWintersSeasonalEstimatesValidator {
    public void validate(double[] initSeasonalEstimates, int frequency, HoltWintersSeasonalityType seasonalityType) {
        this.checkNotNull(initSeasonalEstimates);
        if (initSeasonalEstimates.length <= 0) {
            return;
        }
        this.checkLength(initSeasonalEstimates, frequency);
        this.checkSumOfEstimates(initSeasonalEstimates, frequency, seasonalityType);
    }

    private void checkNotNull(double[] initSeasonalEstimates) {
        Assert.notNull((Object)initSeasonalEstimates, (String)"Required: initSeasonalEstimates must be either an empty array or an array of n=frequency initial estimates for seasonal components.");
    }

    private void checkLength(double[] initSeasonalEstimates, int frequency) {
        Assert.isTrue((initSeasonalEstimates.length == frequency ? 1 : 0) != 0, (String)String.format("Invalid: initSeasonalEstimates size (%d) must equal frequency (%d)", initSeasonalEstimates.length, frequency));
    }

    private void checkSumOfEstimates(double[] initSeasonalEstimates, int frequency, HoltWintersSeasonalityType seasonalityType) {
        BigDecimal seasonalSum = HoltWintersSeasonalEstimatesValidator.sum(initSeasonalEstimates, frequency);
        BigDecimal maxAbs = HoltWintersSeasonalEstimatesValidator.maxOfAbsolutes(HoltWintersSeasonalEstimatesValidator.distancesFromIdentity(initSeasonalEstimates, seasonalityType, frequency), frequency);
        BigDecimal tolerance = HoltWintersSeasonalEstimatesValidator.onePercent(maxAbs);
        if (seasonalityType.equals((Object)HoltWintersSeasonalityType.MULTIPLICATIVE)) {
            HoltWintersSeasonalEstimatesValidator.isBetween(seasonalSum.doubleValue(), (double)frequency - tolerance.doubleValue(), (double)frequency + tolerance.doubleValue(), this.additiveErrorMessage(frequency, seasonalSum, tolerance));
        } else {
            HoltWintersSeasonalEstimatesValidator.isBetween(seasonalSum.doubleValue(), -tolerance.doubleValue(), 1.0 + tolerance.doubleValue(), this.multiplicativeErrorMessage(seasonalSum, tolerance));
        }
    }

    private static BigDecimal sum(double[] values, int frequency) {
        return Arrays.stream(values, 0, frequency).mapToObj(BigDecimal::valueOf).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private static double[] distancesFromIdentity(double[] values, HoltWintersSeasonalityType seasonalityType, int frequency) {
        return seasonalityType.equals((Object)HoltWintersSeasonalityType.MULTIPLICATIVE) ? HoltWintersSeasonalEstimatesValidator.eachMinusOne(values, frequency) : values;
    }

    private static double[] eachMinusOne(double[] values, int frequency) {
        Stream<BigDecimal> stream = Arrays.stream(values, 0, frequency).mapToObj(BigDecimal::valueOf);
        return stream.map(y -> y.subtract(BigDecimal.ONE)).mapToDouble(BigDecimal::doubleValue).toArray();
    }

    private static BigDecimal maxOfAbsolutes(double[] values, int frequency) {
        Stream<BigDecimal> stream = Arrays.stream(values, 0, frequency).mapToObj(BigDecimal::valueOf);
        return stream.max(Comparator.comparing(BigDecimal::abs)).get().abs();
    }

    private static BigDecimal onePercent(BigDecimal val) {
        return val.divide(new BigDecimal(100));
    }

    private static String fmt(BigDecimal val) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(val.scale());
        return df.format(val);
    }

    private String multiplicativeErrorMessage(BigDecimal seasonalSum, BigDecimal tolerance) {
        return String.format("Invalid: Sum of initSeasonalEstimates (%s) was outside accepted tolerance. Sum should be 0 with a tolerance within 1%% of largest seasonal estimate distance from 0 (\u00b1%s), for ADDITIVE seasonality type.", HoltWintersSeasonalEstimatesValidator.fmt(seasonalSum), HoltWintersSeasonalEstimatesValidator.fmt(tolerance));
    }

    private String additiveErrorMessage(int frequency, BigDecimal seasonalSum, BigDecimal tolerance) {
        return String.format("Invalid: Sum of initSeasonalEstimates (%s) was outside accepted tolerance. Sum should equal 'frequency' with a tolerance within 1%% of largest seasonal estimate distance from 1 (%d \u00b1 %s), for MULTIPLICATIVE seasonality type.", HoltWintersSeasonalEstimatesValidator.fmt(seasonalSum), frequency, HoltWintersSeasonalEstimatesValidator.fmt(tolerance));
    }

    public static void isBetween(double value, double lowerBd, double upperBd, String message) {
        Assert.isTrue((lowerBd <= value && value <= upperBd ? 1 : 0) != 0, (String)message);
    }
}

