/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import org.opennms.netmgt.measurements.api.Filter;
import org.opennms.netmgt.measurements.api.FilterFactory;
import org.opennms.netmgt.measurements.api.FilterInfo;
import org.opennms.netmgt.measurements.api.FilterParam;
import org.opennms.netmgt.measurements.model.FilterDef;
import org.opennms.netmgt.measurements.model.FilterParamDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFilterFactory<T extends Filter>
implements FilterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFilterFactory.class);
    private final Class<T> type;
    private final FilterInfo info;

    public AbstractFilterFactory(Class<T> type) {
        this.type = type;
        this.info = type.getAnnotation(FilterInfo.class);
        Preconditions.checkState((this.info != null ? 1 : 0) != 0, (Object)"Filter is missing a FilterInfo annotation");
    }

    public Class<T> getFilterType() {
        return this.type;
    }

    public Filter getFilter(FilterDef filterDef) {
        Filter filter;
        if (!this.info.name().equalsIgnoreCase(filterDef.getName()) && !this.type.getCanonicalName().equals(filterDef.getName())) {
            return null;
        }
        HashMap parameterMap = Maps.newHashMap();
        for (FilterParamDef param : filterDef.getParameters()) {
            parameterMap.put(param.getKey(), param.getValue());
        }
        HashSet unusedParams = Sets.newHashSet();
        unusedParams.addAll(parameterMap.keySet());
        try {
            filter = (Filter)this.type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw Throwables.propagate((Throwable)e);
        }
        for (Field field : this.type.getDeclaredFields()) {
            FilterParam filterParam = field.getAnnotation(FilterParam.class);
            if (filterParam == null) continue;
            String effectiveValueAsStr = null;
            if (parameterMap.containsKey(filterParam.key())) {
                effectiveValueAsStr = (String)parameterMap.get(filterParam.key());
            } else if (!filterParam.required()) {
                effectiveValueAsStr = filterParam.value();
            } else {
                throw new IllegalArgumentException("Parameter with key '" + filterParam.key() + "' is required, but no value was given.");
            }
            Object effectiveValue = effectiveValueAsStr;
            if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                effectiveValue = Boolean.valueOf(effectiveValueAsStr);
            } else if (field.getType() == Double.class || field.getType() == Double.TYPE) {
                effectiveValue = Double.valueOf(effectiveValueAsStr);
            } else if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                effectiveValue = Integer.valueOf(effectiveValueAsStr);
            } else if (field.getType() == Long.class || field.getType() == Long.TYPE) {
                effectiveValue = Long.valueOf(effectiveValueAsStr);
            }
            try {
                field.setAccessible(true);
                field.set(filter, effectiveValue);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw Throwables.propagate((Throwable)e);
            }
            unusedParams.remove(filterParam.key());
        }
        if (unusedParams.size() > 0) {
            LOG.warn("The parameters with the following names were set, but not used by the filter: {}", (Object)unusedParams);
        }
        return filter;
    }
}

