/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui.components.colorpicker;

import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Layout;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.shared.ui.colorpicker.Color;
import com.vaadin.v7.ui.AbstractColorPicker;
import com.vaadin.v7.ui.Slider;
import com.vaadin.v7.ui.components.colorpicker.ColorChangeEvent;
import com.vaadin.v7.ui.components.colorpicker.ColorChangeListener;
import com.vaadin.v7.ui.components.colorpicker.ColorPickerGradient;
import com.vaadin.v7.ui.components.colorpicker.ColorPickerHistory;
import com.vaadin.v7.ui.components.colorpicker.ColorPickerPreview;
import com.vaadin.v7.ui.components.colorpicker.ColorPickerSelect;
import com.vaadin.v7.ui.components.colorpicker.ColorSelector;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public class ColorPickerPopup
extends Window
implements Button.ClickListener,
ColorChangeListener,
ColorSelector {
    private static final String STYLENAME = "v-colorpicker-popup";
    private static final Method COLOR_CHANGE_METHOD;
    private final TabSheet tabs = new TabSheet();
    private Component rgbTab;
    private Component hsvTab;
    private Component swatchesTab;
    private final VerticalLayout layout;
    private final Button ok = new Button("OK");
    private final Button cancel = new Button("Cancel");
    private final Button resize = new Button("show/hide history");
    private Color selectedColor = Color.WHITE;
    private ColorPickerHistory history;
    private Layout historyContainer;
    private ColorPickerGradient rgbGradient;
    private ColorPickerGradient hsvGradient;
    private Slider redSlider;
    private Slider greenSlider;
    private Slider blueSlider;
    private Slider hueSlider;
    private Slider saturationSlider;
    private Slider valueSlider;
    private ColorPickerPreview rgbPreview;
    private ColorPickerPreview hsvPreview;
    private ColorPickerPreview selPreview;
    private ColorPickerSelect colorSelect;
    private final Set<ColorSelector> selectors = new HashSet<ColorSelector>();
    private boolean updatingColors = false;
    private AbstractColorPicker.Coordinates2Color rgbConverter = new AbstractColorPicker.Coordinates2Color(){

        @Override
        public Color calculate(int x, int y) {
            float h = (float)x / 220.0f;
            float s = 1.0f;
            float v = 1.0f;
            if (y < 110) {
                s = (float)y / 110.0f;
            } else if (y > 110) {
                v = 1.0f - ((float)y - 110.0f) / 110.0f;
            }
            return new Color(Color.HSVtoRGB((float)h, (float)s, (float)v));
        }

        @Override
        public int[] calculate(Color color) {
            float[] hsv = color.getHSV();
            int x = Math.round(hsv[0] * 220.0f);
            int y = 0;
            y = hsv[1] == 1.0f ? Math.round(110.0f - (hsv[1] + hsv[2]) * 110.0f) : Math.round(hsv[1] * 110.0f);
            return new int[]{x, y};
        }
    };
    AbstractColorPicker.Coordinates2Color hsvConverter = new AbstractColorPicker.Coordinates2Color(){

        @Override
        public int[] calculate(Color color) {
            float[] hsv = color.getHSV();
            int x = Math.round(hsv[2] * 220.0f);
            int y = Math.round(220.0f - hsv[1] * 220.0f);
            Color bgColor = new Color(Color.HSVtoRGB((float)hsv[0], (float)1.0f, (float)1.0f));
            ColorPickerPopup.this.hsvGradient.setBackgroundColor(bgColor);
            return new int[]{x, y};
        }

        @Override
        public Color calculate(int x, int y) {
            float saturation = 1.0f - (float)y / 220.0f;
            float value = (float)x / 220.0f;
            float hue = Float.parseFloat(((Double)ColorPickerPopup.this.hueSlider.getValue()).toString()) / 360.0f;
            Color color = new Color(Color.HSVtoRGB((float)hue, (float)saturation, (float)value));
            return color;
        }
    };

    private ColorPickerPopup() {
        this.layout = new VerticalLayout();
        this.layout.setSpacing(false);
        this.layout.setMargin(false);
        this.layout.setWidth("100%");
        this.layout.setHeight(null);
        this.setContent((Component)this.layout);
        this.setStyleName(STYLENAME);
        this.setResizable(false);
        this.history = new ColorPickerHistory();
        this.history.addColorChangeListener(this);
    }

    public ColorPickerPopup(Color initialColor) {
        this();
        this.selectedColor = initialColor;
        this.initContents();
    }

    private void initContents() {
        this.rgbPreview = new ColorPickerPreview(this.selectedColor);
        this.rgbPreview.setWidth("240px");
        this.rgbPreview.setHeight("20px");
        this.rgbPreview.addColorChangeListener(this);
        this.selectors.add(this.rgbPreview);
        this.hsvPreview = new ColorPickerPreview(this.selectedColor);
        this.hsvPreview.setWidth("240px");
        this.hsvPreview.setHeight("20px");
        this.hsvPreview.addColorChangeListener(this);
        this.selectors.add(this.hsvPreview);
        this.selPreview = new ColorPickerPreview(this.selectedColor);
        this.selPreview.setWidth("100%");
        this.selPreview.setHeight("20px");
        this.selPreview.addColorChangeListener(this);
        this.selectors.add(this.selPreview);
        this.rgbTab = this.createRGBTab(this.selectedColor);
        this.tabs.addTab(this.rgbTab, "RGB", null);
        this.hsvTab = this.createHSVTab(this.selectedColor);
        this.tabs.addTab(this.hsvTab, "HSV", null);
        this.swatchesTab = this.createSelectTab();
        this.tabs.addTab(this.swatchesTab, "Swatches", null);
        this.tabs.setWidth("100%");
        this.layout.addComponent((Component)this.tabs);
        this.history.setWidth("97%");
        this.history.setHeight("22px");
        VerticalLayout innerContainer = new VerticalLayout();
        innerContainer.setWidth("100%");
        innerContainer.setHeight(null);
        innerContainer.addComponent((Component)this.history);
        VerticalLayout outerContainer = new VerticalLayout();
        outerContainer.setWidth("99%");
        outerContainer.setHeight("27px");
        outerContainer.addComponent((Component)innerContainer);
        this.historyContainer = outerContainer;
        this.layout.addComponent((Component)this.historyContainer);
        this.resize.addClickListener((Button.ClickListener)this);
        this.resize.setData((Object)new Boolean(false));
        this.resize.setWidth("100%");
        this.resize.setHeight("10px");
        this.resize.setPrimaryStyleName("resize-button");
        this.layout.addComponent((Component)this.resize);
        this.ok.setWidth("70px");
        this.ok.addClickListener((Button.ClickListener)this);
        this.cancel.setWidth("70px");
        this.cancel.addClickListener((Button.ClickListener)this);
        HorizontalLayout buttons = new HorizontalLayout();
        buttons.addComponent((Component)this.ok);
        buttons.addComponent((Component)this.cancel);
        buttons.setWidth("100%");
        buttons.setHeight("30px");
        buttons.setComponentAlignment((Component)this.ok, Alignment.MIDDLE_CENTER);
        buttons.setComponentAlignment((Component)this.cancel, Alignment.MIDDLE_CENTER);
        this.layout.addComponent((Component)buttons);
    }

    private Component createRGBTab(Color color) {
        VerticalLayout rgbLayout = new VerticalLayout();
        rgbLayout.setMargin(new MarginInfo(false, false, true, false));
        rgbLayout.addComponent((Component)this.rgbPreview);
        rgbLayout.setStyleName("rgbtab");
        this.rgbGradient = new ColorPickerGradient("rgb-gradient", this.rgbConverter);
        this.rgbGradient.setColor(color);
        this.rgbGradient.addColorChangeListener(this);
        rgbLayout.addComponent((Component)this.rgbGradient);
        this.selectors.add(this.rgbGradient);
        VerticalLayout sliders = new VerticalLayout();
        sliders.setStyleName("rgb-sliders");
        this.redSlider = this.createRGBSlider("Red", "red");
        this.greenSlider = this.createRGBSlider("Green", "green");
        this.blueSlider = this.createRGBSlider("Blue", "blue");
        this.setRgbSliderValues(color);
        this.redSlider.addValueChangeListener(new Property.ValueChangeListener(){

            @Override
            public void valueChange(Property.ValueChangeEvent event) {
                double red = (Double)event.getProperty().getValue();
                if (!ColorPickerPopup.this.updatingColors) {
                    Color newColor = new Color((int)red, ColorPickerPopup.this.selectedColor.getGreen(), ColorPickerPopup.this.selectedColor.getBlue());
                    ColorPickerPopup.this.setColor(newColor);
                }
            }
        });
        sliders.addComponent((Component)this.redSlider);
        this.greenSlider.addValueChangeListener(new Property.ValueChangeListener(){

            @Override
            public void valueChange(Property.ValueChangeEvent event) {
                double green = (Double)event.getProperty().getValue();
                if (!ColorPickerPopup.this.updatingColors) {
                    Color newColor = new Color(ColorPickerPopup.this.selectedColor.getRed(), (int)green, ColorPickerPopup.this.selectedColor.getBlue());
                    ColorPickerPopup.this.setColor(newColor);
                }
            }
        });
        sliders.addComponent((Component)this.greenSlider);
        this.blueSlider.addValueChangeListener(new Property.ValueChangeListener(){

            @Override
            public void valueChange(Property.ValueChangeEvent event) {
                double blue = (Double)event.getProperty().getValue();
                if (!ColorPickerPopup.this.updatingColors) {
                    Color newColor = new Color(ColorPickerPopup.this.selectedColor.getRed(), ColorPickerPopup.this.selectedColor.getGreen(), (int)blue);
                    ColorPickerPopup.this.setColor(newColor);
                }
            }
        });
        sliders.addComponent((Component)this.blueSlider);
        rgbLayout.addComponent((Component)sliders);
        return rgbLayout;
    }

    private Slider createRGBSlider(String caption, String styleName) {
        Slider redSlider = new Slider(caption, 0, 255);
        redSlider.setImmediate(true);
        redSlider.setStyleName("rgb-slider");
        redSlider.setWidth("220px");
        redSlider.addStyleName(styleName);
        return redSlider;
    }

    private Component createHSVTab(Color color) {
        VerticalLayout hsvLayout = new VerticalLayout();
        hsvLayout.setMargin(new MarginInfo(false, false, true, false));
        hsvLayout.addComponent((Component)this.hsvPreview);
        hsvLayout.setStyleName("hsvtab");
        this.hsvGradient = new ColorPickerGradient("hsv-gradient", this.hsvConverter);
        this.hsvGradient.setColor(color);
        this.hsvGradient.addColorChangeListener(this);
        hsvLayout.addComponent((Component)this.hsvGradient);
        this.selectors.add(this.hsvGradient);
        VerticalLayout sliders = new VerticalLayout();
        sliders.setStyleName("hsv-sliders");
        this.hueSlider = new Slider("Hue", 0, 360);
        this.saturationSlider = new Slider("Saturation", 0, 100);
        this.valueSlider = new Slider("Value", 0, 100);
        float[] hsv = color.getHSV();
        this.setHsvSliderValues(hsv);
        this.hueSlider.setStyleName("hsv-slider");
        this.hueSlider.addStyleName("hue-slider");
        this.hueSlider.setWidth("220px");
        this.hueSlider.setImmediate(true);
        this.hueSlider.addValueChangeListener(new Property.ValueChangeListener(){

            @Override
            public void valueChange(Property.ValueChangeEvent event) {
                if (!ColorPickerPopup.this.updatingColors) {
                    float hue = Float.parseFloat(event.getProperty().getValue().toString()) / 360.0f;
                    float saturation = Float.parseFloat(((Double)ColorPickerPopup.this.saturationSlider.getValue()).toString()) / 100.0f;
                    float value = Float.parseFloat(((Double)ColorPickerPopup.this.valueSlider.getValue()).toString()) / 100.0f;
                    Color color = new Color(Color.HSVtoRGB((float)hue, (float)saturation, (float)value));
                    ColorPickerPopup.this.setColor(color);
                    Color bgColor = new Color(Color.HSVtoRGB((float)hue, (float)1.0f, (float)1.0f));
                    ColorPickerPopup.this.hsvGradient.setBackgroundColor(bgColor);
                }
            }
        });
        sliders.addComponent((Component)this.hueSlider);
        this.saturationSlider.setStyleName("hsv-slider");
        this.saturationSlider.setWidth("220px");
        this.saturationSlider.setImmediate(true);
        this.saturationSlider.addValueChangeListener(new Property.ValueChangeListener(){

            @Override
            public void valueChange(Property.ValueChangeEvent event) {
                if (!ColorPickerPopup.this.updatingColors) {
                    float hue = Float.parseFloat(((Double)ColorPickerPopup.this.hueSlider.getValue()).toString()) / 360.0f;
                    float saturation = Float.parseFloat(event.getProperty().getValue().toString()) / 100.0f;
                    float value = Float.parseFloat(((Double)ColorPickerPopup.this.valueSlider.getValue()).toString()) / 100.0f;
                    Color color = new Color(Color.HSVtoRGB((float)hue, (float)saturation, (float)value));
                    ColorPickerPopup.this.setColor(color);
                }
            }
        });
        sliders.addComponent((Component)this.saturationSlider);
        this.valueSlider.setStyleName("hsv-slider");
        this.valueSlider.setWidth("220px");
        this.valueSlider.setImmediate(true);
        this.valueSlider.addValueChangeListener(new Property.ValueChangeListener(){

            @Override
            public void valueChange(Property.ValueChangeEvent event) {
                if (!ColorPickerPopup.this.updatingColors) {
                    float hue = Float.parseFloat(((Double)ColorPickerPopup.this.hueSlider.getValue()).toString()) / 360.0f;
                    float saturation = Float.parseFloat(((Double)ColorPickerPopup.this.saturationSlider.getValue()).toString()) / 100.0f;
                    float value = Float.parseFloat(event.getProperty().getValue().toString()) / 100.0f;
                    Color color = new Color(Color.HSVtoRGB((float)hue, (float)saturation, (float)value));
                    ColorPickerPopup.this.setColor(color);
                }
            }
        });
        sliders.addComponent((Component)this.valueSlider);
        hsvLayout.addComponent((Component)sliders);
        return hsvLayout;
    }

    private Component createSelectTab() {
        VerticalLayout selLayout = new VerticalLayout();
        selLayout.setMargin(new MarginInfo(false, false, true, false));
        selLayout.addComponent((Component)this.selPreview);
        selLayout.addStyleName("seltab");
        this.colorSelect = new ColorPickerSelect();
        this.colorSelect.addColorChangeListener(this);
        selLayout.addComponent((Component)this.colorSelect);
        return selLayout;
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getButton() == this.resize) {
            boolean state = (Boolean)this.resize.getData();
            if (state) {
                this.historyContainer.setHeight("27px");
                this.history.setHeight("22px");
            } else {
                this.historyContainer.setHeight("90px");
                this.history.setHeight("85px");
            }
            this.resize.setData((Object)new Boolean(!state));
        } else if (event.getButton() == this.ok) {
            this.history.setColor(this.getColor());
            this.fireColorChanged();
            this.close();
        } else if (event.getButton() == this.cancel) {
            this.close();
        }
    }

    public void fireColorChanged() {
        this.fireEvent((EventObject)((Object)new ColorChangeEvent((Component)this, this.getColor())));
    }

    public ColorPickerHistory getHistory() {
        return this.history;
    }

    @Override
    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.selectedColor = color;
        this.hsvGradient.setColor(this.selectedColor);
        this.hsvPreview.setColor(this.selectedColor);
        this.rgbGradient.setColor(this.selectedColor);
        this.rgbPreview.setColor(this.selectedColor);
        this.selPreview.setColor(this.selectedColor);
    }

    @Override
    public Color getColor() {
        return this.selectedColor;
    }

    public List<Color> getColorHistory() {
        return Collections.unmodifiableList(this.history.getHistory());
    }

    @Override
    public void colorChanged(ColorChangeEvent event) {
        this.setColor(event.getColor());
        this.updatingColors = true;
        this.setRgbSliderValues(this.selectedColor);
        float[] hsv = this.selectedColor.getHSV();
        this.setHsvSliderValues(hsv);
        this.updatingColors = false;
        for (ColorSelector s : this.selectors) {
            if (event.getSource() == s || s == this || s.getColor() == this.selectedColor) continue;
            s.setColor(this.selectedColor);
        }
    }

    private void setRgbSliderValues(Color color) {
        try {
            this.redSlider.setValue(Integer.valueOf(color.getRed()).doubleValue());
            this.blueSlider.setValue(Integer.valueOf(color.getBlue()).doubleValue());
            this.greenSlider.setValue(Integer.valueOf(color.getGreen()).doubleValue());
        }
        catch (Slider.ValueOutOfBoundsException e) {
            ColorPickerPopup.getLogger().log(Level.WARNING, "Unable to set RGB color value to " + color.getRed() + "," + color.getGreen() + "," + color.getBlue(), e);
        }
    }

    private void setHsvSliderValues(float[] hsv) {
        try {
            this.hueSlider.setValue(Float.valueOf(hsv[0] * 360.0f).doubleValue());
            this.saturationSlider.setValue(Float.valueOf(hsv[1] * 100.0f).doubleValue());
            this.valueSlider.setValue(Float.valueOf(hsv[2] * 100.0f).doubleValue());
        }
        catch (Slider.ValueOutOfBoundsException e) {
            ColorPickerPopup.getLogger().log(Level.WARNING, "Unable to set HSV color value to " + hsv[0] + "," + hsv[1] + "," + hsv[2], e);
        }
    }

    @Override
    public void addColorChangeListener(ColorChangeListener listener) {
        this.addListener(ColorChangeEvent.class, listener, COLOR_CHANGE_METHOD);
    }

    @Override
    public void removeColorChangeListener(ColorChangeListener listener) {
        this.removeListener(ColorChangeEvent.class, listener);
    }

    private boolean tabIsVisible(Component tab) {
        for (Component comp : this.tabs) {
            if (comp != tab) continue;
            return true;
        }
        return false;
    }

    private int tabsNumVisible() {
        int tabCounter = 0;
        for (Component comp : this.tabs) {
            ++tabCounter;
        }
        return tabCounter;
    }

    private void checkIfTabsNeeded() {
        this.tabs.hideTabs(this.tabsNumVisible() == 1);
    }

    public void setRGBTabVisible(boolean visible) {
        if (visible && !this.tabIsVisible(this.rgbTab)) {
            this.tabs.addTab(this.rgbTab, "RGB", null);
            this.checkIfTabsNeeded();
        } else if (!visible && this.tabIsVisible(this.rgbTab)) {
            this.tabs.removeComponent(this.rgbTab);
            this.checkIfTabsNeeded();
        }
    }

    public void setHSVTabVisible(boolean visible) {
        if (visible && !this.tabIsVisible(this.hsvTab)) {
            this.tabs.addTab(this.hsvTab, "HSV", null);
            this.checkIfTabsNeeded();
        } else if (!visible && this.tabIsVisible(this.hsvTab)) {
            this.tabs.removeComponent(this.hsvTab);
            this.checkIfTabsNeeded();
        }
    }

    public void setSwatchesTabVisible(boolean visible) {
        if (visible && !this.tabIsVisible(this.swatchesTab)) {
            this.tabs.addTab(this.swatchesTab, "Swatches", null);
            this.checkIfTabsNeeded();
        } else if (!visible && this.tabIsVisible(this.swatchesTab)) {
            this.tabs.removeComponent(this.swatchesTab);
            this.checkIfTabsNeeded();
        }
    }

    public void setHistoryVisible(boolean visible) {
        this.historyContainer.setVisible(visible);
        this.resize.setVisible(visible);
    }

    public void setPreviewVisible(boolean visible) {
        this.hsvPreview.setVisible(visible);
        this.rgbPreview.setVisible(visible);
        this.selPreview.setVisible(visible);
    }

    private static Logger getLogger() {
        return Logger.getLogger(ColorPickerPopup.class.getName());
    }

    static {
        try {
            COLOR_CHANGE_METHOD = ColorChangeListener.class.getDeclaredMethod("colorChanged", ColorChangeEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error finding methods in ColorPicker");
        }
    }
}

