/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.validator;

import com.vaadin.v7.data.Validator;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

@Deprecated
public class CompositeValidator
implements Validator {
    @Deprecated
    public static final CombinationMode MODE_AND = CombinationMode.AND;
    @Deprecated
    public static final CombinationMode MODE_OR = CombinationMode.OR;
    private String errorMessage;
    private CombinationMode mode = CombinationMode.AND;
    private final List<Validator> validators = new LinkedList<Validator>();

    public CompositeValidator() {
        this(CombinationMode.AND, "");
    }

    public CompositeValidator(CombinationMode mode, String errorMessage) {
        this.setErrorMessage(errorMessage);
        this.setMode(mode);
    }

    @Override
    public void validate(Object value) throws Validator.InvalidValueException {
        switch (this.mode) {
            case AND: {
                for (Validator validator : this.validators) {
                    validator.validate(value);
                }
                return;
            }
            case OR: {
                Validator.InvalidValueException first = null;
                for (Validator v : this.validators) {
                    try {
                        v.validate(value);
                        return;
                    }
                    catch (Validator.InvalidValueException e) {
                        if (first != null) continue;
                        first = e;
                    }
                }
                if (first == null) {
                    return;
                }
                String em = this.getErrorMessage();
                if (em != null) {
                    throw new Validator.InvalidValueException(em);
                }
                throw first;
            }
        }
    }

    public final CombinationMode getMode() {
        return this.mode;
    }

    public void setMode(CombinationMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("The validator can't be set to null");
        }
        this.mode = mode;
    }

    public String getErrorMessage() {
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        return null;
    }

    public void addValidator(Validator validator) {
        if (validator == null) {
            return;
        }
        this.validators.add(validator);
    }

    public void removeValidator(Validator validator) {
        this.validators.remove(validator);
    }

    public Collection<Validator> getSubValidators(Class validatorType) {
        if (this.mode != CombinationMode.AND) {
            return null;
        }
        HashSet<Validator> found = new HashSet<Validator>();
        for (Validator v : this.validators) {
            Collection<Validator> c;
            if (validatorType.isAssignableFrom(v.getClass())) {
                found.add(v);
            }
            if (!(v instanceof CompositeValidator) || ((CompositeValidator)v).getMode() != MODE_AND || (c = ((CompositeValidator)v).getSubValidators(validatorType)) == null) continue;
            found.addAll(c);
        }
        return found.isEmpty() ? null : found;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Deprecated
    public static enum CombinationMode {
        AND,
        OR;

    }
}

