/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.jasperreports.svclayer;

import java.util.Arrays;
import java.util.Optional;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.ExpressionChunkVisitor;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubreportExpressionVisitor
implements ExpressionChunkVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(SubreportExpressionVisitor.class);
    private final JasperReport report;
    private final StringBuffer stringBuffer = new StringBuffer();

    SubreportExpressionVisitor(JasperReport report) {
        this.report = report;
    }

    public void visitTextChunk(JRExpressionChunk chunk) {
        this.stringBuffer.append(chunk.getText());
    }

    public void visitParameterChunk(JRExpressionChunk chunk) {
        Optional<JRParameter> parameterOptional = Arrays.stream(this.report.getParameters()).filter(p -> p.getName().equals(chunk.getText())).findAny();
        if (parameterOptional.isPresent()) {
            String string = new SubreportExpressionVisitor(this.report).visit(parameterOptional.get().getDefaultValueExpression());
            this.append(string);
        }
    }

    public void visitVariableChunk(JRExpressionChunk chunk) {
        LOG.warn("Variable chunks are not supported. Skipping.");
    }

    public void visitResourceChunk(JRExpressionChunk chunk) {
        LOG.warn("Resource chunks are not supported. Skipping.");
    }

    public void visitFieldChunk(JRExpressionChunk chunk) {
        LOG.warn("Field chunks are not supported. Skipping.");
    }

    protected String visit(JRExpression expression) {
        JRExpressionUtil.visitChunks((JRExpression)expression, (ExpressionChunkVisitor)this);
        String string = this.stringBuffer.toString();
        return string;
    }

    private void append(String string) {
        if (string != null) {
            this.stringBuffer.append(string);
        }
    }
}

