/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.config.ui;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.Tree;
import java.util.List;
import org.opennms.features.vaadin.dashboard.config.DashletSelector;
import org.opennms.features.vaadin.dashboard.model.DashletFactory;

public class HelpClickListener
implements Button.ClickListener {
    private Component m_component;
    private DashletSelector m_dashletSelector;

    public HelpClickListener(Component component, DashletSelector dashletSelector) {
        this.m_component = component;
        this.m_dashletSelector = dashletSelector;
    }

    public void buttonClick(Button.ClickEvent clickEvent) {
        final Window window = new Window("Help");
        window.setModal(true);
        window.setClosable(false);
        window.setResizable(false);
        window.setWidth("55%");
        window.setHeight("80%");
        this.m_component.getUI().addWindow(window);
        window.setContent((Component)new VerticalLayout(){
            {
                this.setMargin(true);
                this.setSpacing(true);
                this.setSizeFull();
                HorizontalLayout horizontalLayout = new HorizontalLayout();
                horizontalLayout.setSizeFull();
                horizontalLayout.setSpacing(true);
                Tree tree = new Tree();
                tree.setNullSelectionAllowed(false);
                tree.setMultiSelect(false);
                tree.setImmediate(true);
                tree.addItem((Object)"Overview");
                tree.setChildrenAllowed((Object)"Overview", false);
                tree.addItem((Object)"Installed Dashlets");
                tree.setChildrenAllowed((Object)"Installed Dashlets", true);
                List<DashletFactory> factories = HelpClickListener.this.m_dashletSelector.getDashletFactoryList();
                for (DashletFactory dashletFactory : factories) {
                    tree.addItem((Object)dashletFactory.getName());
                    tree.setParent((Object)dashletFactory.getName(), (Object)"Installed Dashlets");
                    tree.setChildrenAllowed((Object)dashletFactory.getName(), false);
                }
                horizontalLayout.addComponent((Component)tree);
                for (DashletFactory id : tree.rootItemIds()) {
                    tree.expandItemsRecursively((Object)id);
                }
                final Panel panel = new Panel();
                panel.setSizeFull();
                horizontalLayout.addComponent((Component)panel);
                horizontalLayout.setExpandRatio((Component)panel, 1.0f);
                this.addComponent((Component)horizontalLayout);
                this.setExpandRatio((Component)horizontalLayout, 1.0f);
                tree.addValueChangeListener(new Property.ValueChangeListener(){

                    public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                        String itemId = String.valueOf(valueChangeEvent.getProperty().getValue());
                        if ("Installed Dashlets".equals(itemId)) {
                            return;
                        }
                        if ("Overview".equals(itemId)) {
                            VerticalLayout verticalLayout = new VerticalLayout();
                            verticalLayout.setSpacing(true);
                            verticalLayout.setMargin(true);
                            verticalLayout.addComponent((Component)new Label(HelpClickListener.this.getOverviewHelpHTML(), ContentMode.HTML));
                            panel.setContent((Component)verticalLayout);
                        } else {
                            DashletFactory dashletFactory = HelpClickListener.this.m_dashletSelector.getDashletFactoryForName(itemId);
                            if (dashletFactory != null && dashletFactory.providesHelpComponent()) {
                                VerticalLayout verticalLayout = new VerticalLayout();
                                verticalLayout.setSpacing(true);
                                verticalLayout.setMargin(true);
                                Label helpTitle = new Label("Help for Dashlet '" + dashletFactory.getName() + "'");
                                helpTitle.addStyleName("help-title");
                                verticalLayout.addComponent((Component)helpTitle);
                                verticalLayout.addComponent(dashletFactory.getHelpComponent());
                                panel.setContent((Component)verticalLayout);
                            }
                        }
                    }
                });
                tree.select((Object)"Overview");
                this.addComponent((Component)new HorizontalLayout(){
                    {
                        this.setMargin(true);
                        this.setSpacing(true);
                        this.setWidth("100%");
                        Button closeButton = new Button("Close");
                        this.addComponent((Component)closeButton);
                        this.setComponentAlignment((Component)closeButton, Alignment.MIDDLE_RIGHT);
                        closeButton.addClickListener(new Button.ClickListener(){

                            public void buttonClick(Button.ClickEvent clickEvent) {
                                window.close();
                            }
                        });
                    }
                });
            }
        });
    }

    private String getOverviewHelpHTML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class='help-title'>Overview</div>");
        sb.append("");
        sb.append("<div class='help-content'>");
        sb.append("On this configuration page you can create, edit, preview or delete ");
        sb.append("Ops Board configurations. Each Ops Board configuration consists of ");
        sb.append("multiple Dashlet entries. Each Dashlet entry requires to set at least ");
        sb.append("four parameters:<br/><br/>");
        sb.append("");
        sb.append("<table class='help-table'>");
        sb.append("  <tr>");
        sb.append("    <th>Name</th>");
        sb.append("    <th>Description</th>");
        sb.append("  </tr>");
        sb.append("  <tr><td class='help-table-cell'>title</td><td class='help-table-cell'>The title for this Dashlet instance</td></tr>");
        sb.append("  <tr><td class='help-table-cell'>duration</td><td class='help-table-cell'>Time in seconds the Dashlet will be displayed</td></tr>");
        sb.append("  <tr><td class='help-table-cell'>priority</td><td class='help-table-cell'>Lower priority means that the Dashlet will be displayed more often</td></tr>");
        sb.append("  <tr><td class='help-table-cell'>boostedDuration</td><td class='help-table-cell'>This value is added to the duration value if the Dashlet is \"boosted\"</td></tr>");
        sb.append("  <tr><td class='help-table-cell'>boostedPriority</td><td class='help-table-cell'>This value is subtracted from the Dashlet's priority then the Dashlet is \"boosted\"</td></tr>");
        sb.append("</table>");
        sb.append("<br/>");
        sb.append("The Dashlet itself computes whether it is \"boosted\" or not. So, a Dashlet ");
        sb.append("displaying critical data will be displayed more often and for a longer duration. ");
        sb.append("Please select a Dashlet entry on the left for a brief description of the Dashlet ");
        sb.append("and its required parameters.");
        sb.append("</div>");
        sb.append("");
        return sb.toString();
    }
}

