/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.net.URI;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterfaceList;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="onmsSnmpInterfaceResource")
@Transactional
public class OnmsSnmpInterfaceResource
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(OnmsSnmpInterfaceResource.class);
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    @Qualifier(value="eventProxy")
    private EventProxy m_eventProxy;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsSnmpInterfaceList getSnmpInterfaces(@Context UriInfo uriInfo, @PathParam(value="nodeCriteria") String nodeCriteria) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        MultivaluedMap params = uriInfo.getQueryParameters();
        CriteriaBuilder builder = new CriteriaBuilder(OnmsSnmpInterface.class);
        builder.ne("collect", (Object)"D");
        builder.limit(Integer.valueOf(20));
        OnmsSnmpInterfaceResource.applyQueryFilters((MultivaluedMap<String, String>)params, builder);
        builder.eq("node.id", (Object)node.getId());
        OnmsSnmpInterfaceList snmpList = new OnmsSnmpInterfaceList((Collection)this.m_snmpInterfaceDao.findMatching(builder.toCriteria()));
        snmpList.setTotalCount(Integer.valueOf(this.m_snmpInterfaceDao.countMatching(builder.count().toCriteria())));
        return snmpList;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{ifIndex}")
    public OnmsSnmpInterface getSnmpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ifIndex") int ifIndex) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            throw OnmsSnmpInterfaceResource.getException(Response.Status.BAD_REQUEST, "Node {} was not found.", nodeCriteria);
        }
        OnmsSnmpInterface iface = node.getSnmpInterfaceWithIfIndex(ifIndex);
        if (iface == null) {
            throw OnmsSnmpInterfaceResource.getException(Response.Status.NOT_FOUND, "SNMP Interface {} was not found on node {}.", Integer.toString(ifIndex), nodeCriteria);
        }
        return iface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    public Response addSnmpInterface(@Context UriInfo uriInfo, @PathParam(value="nodeCriteria") String nodeCriteria, OnmsSnmpInterface snmpInterface) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw OnmsSnmpInterfaceResource.getException(Response.Status.BAD_REQUEST, "Node {} was not found.", nodeCriteria);
            }
            if (snmpInterface == null) {
                throw OnmsSnmpInterfaceResource.getException(Response.Status.BAD_REQUEST, "SNMP interface object cannot be null", new String[0]);
            }
            LOG.debug("addSnmpInterface: adding interface {}", (Object)snmpInterface);
            node.addSnmpInterface(snmpInterface);
            if (snmpInterface.getPrimaryIpInterface() != null) {
                OnmsIpInterface iface = snmpInterface.getPrimaryIpInterface();
                iface.setSnmpInterface(snmpInterface);
            }
            this.m_snmpInterfaceDao.save((Object)snmpInterface);
            Integer ifIndex = snmpInterface.getIfIndex();
            Response response = Response.created((URI)OnmsSnmpInterfaceResource.getRedirectUri(uriInfo, ifIndex)).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{ifIndex}")
    public Response deleteSnmpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ifIndex") int ifIndex) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw OnmsSnmpInterfaceResource.getException(Response.Status.BAD_REQUEST, "Node {} was not found.", nodeCriteria);
            }
            OnmsSnmpInterface snmpInterface = node.getSnmpInterfaceWithIfIndex(ifIndex);
            if (snmpInterface == null) {
                throw OnmsSnmpInterfaceResource.getException(Response.Status.BAD_REQUEST, "Can't find SNMP interface with ifIndex {} for node {}", Integer.toString(ifIndex), nodeCriteria);
            }
            LOG.debug("deletSnmpInterface: deleting interface with ifIndex {} from node {}", (Object)ifIndex, (Object)nodeCriteria);
            node.getSnmpInterfaces().remove(snmpInterface);
            this.m_nodeDao.saveOrUpdate((Object)node);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{ifIndex}")
    public Response updateSnmpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ifIndex") int ifIndex, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw OnmsSnmpInterfaceResource.getException(Response.Status.BAD_REQUEST, "Node {} was not found.", nodeCriteria);
            }
            if (ifIndex < 0) {
                throw OnmsSnmpInterfaceResource.getException(Response.Status.BAD_REQUEST, "Invalid ifIndex specified for SNMP interface on node {}: {}", nodeCriteria, Integer.toString(ifIndex));
            }
            OnmsSnmpInterface snmpInterface = node.getSnmpInterfaceWithIfIndex(ifIndex);
            if (snmpInterface == null) {
                throw OnmsSnmpInterfaceResource.getException(Response.Status.BAD_REQUEST, "Can't find SNMP interface with ifIndex {} for node {}", Integer.toString(ifIndex), nodeCriteria);
            }
            LOG.debug("updateSnmpInterface: updating SNMP interface {}", (Object)snmpInterface);
            boolean modified = false;
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)snmpInterface);
            for (String key : params.keySet()) {
                if ("nodeId".equals(key) || "ipInterface".equals(key) || "ipInterfaces".equals(key) || !wrapper.isWritableProperty(key)) continue;
                String stringValue = (String)params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
                modified = true;
            }
            if (modified) {
                LOG.debug("updateSnmpInterface: SNMP interface {} updated", (Object)snmpInterface);
                this.m_snmpInterfaceDao.saveOrUpdate((Object)snmpInterface);
            }
            Event e = null;
            if (params.containsKey("collect")) {
                EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/reinitializePrimarySnmpInterface", "ReST");
                bldr.setNode(node);
                OnmsIpInterface iface = node.getPrimaryInterface();
                if (iface == null) {
                    LOG.warn("updateSnmpInterface: Cannot send {} event because node {} has no primary SNMP interface", (Object)"uei.opennms.org/nodes/reinitializePrimarySnmpInterface", (Object)node.getId());
                } else {
                    bldr.setInterface(iface.getIpAddress());
                    e = bldr.getEvent();
                }
            }
            if (e != null) {
                try {
                    this.m_eventProxy.send(e);
                }
                catch (EventProxyException ex) {
                    throw OnmsSnmpInterfaceResource.getException(Response.Status.INTERNAL_SERVER_ERROR, "Exception occurred sending event {} : {}", e.getUei(), ex.getMessage());
                }
            }
            Response response = modified ? Response.noContent().build() : Response.notModified().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }
}

