/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vacuumd;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transaction {
    public static final Logger LOG = LoggerFactory.getLogger(Transaction.class);
    private static ThreadLocal<Transaction> s_threadTX = new ThreadLocal();
    private Map<String, Connection> m_connections = new HashMap<String, Connection>();
    private List<Statement> m_statements = new LinkedList<Statement>();
    private List<ResultSet> m_resultSets = new LinkedList<ResultSet>();
    private boolean m_rollbackOnly = false;
    private DBUtils m_dbUtils = new DBUtils(Transaction.class);

    private static Transaction getTX() {
        Transaction tx = s_threadTX.get();
        if (tx == null) {
            throw new IllegalStateException("No transaction has been started for this thread!");
        }
        return tx;
    }

    private static void clearTX() {
        s_threadTX.set(null);
    }

    public static void begin() {
        LOG.debug("About to begin Transaction for {}", (Object)Thread.currentThread());
        Transaction tx = s_threadTX.get();
        if (tx != null) {
            throw new IllegalStateException("Cannot begin a transaction.. one has already been begun");
        }
        LOG.debug("Began Transaction for {}", (Object)Thread.currentThread());
        s_threadTX.set(new Transaction());
    }

    public static Connection getConnection(String dsName) throws SQLException {
        return Transaction.getTX().doGetConnection(dsName);
    }

    public static void register(Statement stmt) {
        Transaction.getTX().doRegister(stmt);
    }

    public static void register(ResultSet rs) {
        Transaction.getTX().doRegister(rs);
    }

    public static void rollbackOnly() throws SQLException {
        Transaction.getTX().doRollbackOnly();
    }

    public static void end() throws SQLException {
        LOG.debug("Ending transaction for {}", (Object)Thread.currentThread());
        try {
            Transaction tx = Transaction.getTX();
            tx.doEnd();
            LOG.debug("{} transaction for {}", (Object)(tx.m_rollbackOnly ? "Rolled Back" : "Committed"), (Object)Thread.currentThread());
        }
        finally {
            Transaction.clearTX();
        }
    }

    private void doRegister(Statement stmt) {
        this.m_dbUtils.watch((Object)stmt);
        this.m_statements.add(stmt);
    }

    private void doRegister(ResultSet rs) {
        this.m_dbUtils.watch((Object)rs);
        this.m_resultSets.add(rs);
    }

    private void doClose() throws SQLException {
        this.m_dbUtils.cleanUp();
    }

    private void doEnd() throws SQLException {
        try {
            for (Connection conn : this.m_connections.values()) {
                if (this.m_rollbackOnly) {
                    conn.rollback();
                    continue;
                }
                conn.commit();
            }
        }
        finally {
            this.doClose();
        }
    }

    private void doRollbackOnly() throws SQLException {
        this.m_rollbackOnly = true;
    }

    private Connection doGetConnection(String dsName) throws SQLException {
        if (!this.m_connections.containsKey(dsName)) {
            DataSource ds = DataSourceFactory.getInstance((String)dsName);
            if (ds == null) {
                throw new IllegalArgumentException("Could not find this datasource by using the DataSourceFactory: " + dsName);
            }
            Connection conn = ds.getConnection();
            this.m_dbUtils.watch((Object)conn);
            this.m_connections.put(dsName, conn);
            conn.setAutoCommit(false);
        }
        return this.m_connections.get(dsName);
    }

    protected void finalize() throws Throwable {
        this.m_dbUtils.cleanUp();
        super.finalize();
    }
}

