/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.dto.CollectionAgentDTO;
import org.opennms.netmgt.collection.dto.CollectionSetDTO;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.LatencyTypeResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitorAdaptor;
import org.opennms.netmgt.rrd.RrdRepository;

public class StatusStoringServiceMonitorAdaptor
implements ServiceMonitorAdaptor {
    public static final int HEARTBEAT_STEP_MULTIPLIER = 2;
    private final PollerConfig pollerConfig;
    private final Package pkg;
    private final PersisterFactory persisterFactory;

    public StatusStoringServiceMonitorAdaptor(PollerConfig config, Package pkg, PersisterFactory persisterFactory) {
        this.pollerConfig = Objects.requireNonNull(config);
        this.pkg = Objects.requireNonNull(pkg);
        this.persisterFactory = Objects.requireNonNull(persisterFactory);
    }

    @Override
    public PollStatus handlePollResult(MonitoredService svc, Map<String, Object> parameters, PollStatus status) {
        if (ParameterMap.getKeyedBoolean(parameters, (String)"rrd-status", (boolean)true)) {
            this.storeStatus(svc, status, parameters);
        }
        return status;
    }

    private void storeStatus(MonitoredService svc, PollStatus status, Map<String, Object> parameters) {
        RrdRepository rrdRepository = new RrdRepository();
        rrdRepository.setStep(this.pollerConfig.getStep(this.pkg));
        rrdRepository.setRraList(this.pollerConfig.getRRAList(this.pkg));
        rrdRepository.setHeartBeat(rrdRepository.getStep() * 2);
        rrdRepository.setRrdBaseDir(new File(System.getProperty("rrd.base.dir"), "status"));
        String dsName = ParameterMap.getKeyedString(parameters, (String)"ds-name", (String)svc.getSvcName().toLowerCase());
        String rrdBaseName = ParameterMap.getKeyedString(parameters, (String)"rrd-base-name", (String)dsName);
        boolean snmpInfoInTags = ParameterMap.getKeyedBoolean(parameters, (String)"interface-info-in-tags", (boolean)false);
        CollectionAgentDTO agent = new CollectionAgentDTO();
        agent.setAddress(svc.getAddress());
        agent.setNodeId(svc.getNodeId());
        agent.setNodeLabel(svc.getNodeLabel());
        agent.setLocationName(svc.getNodeLocation());
        agent.setStorageResourcePath(ResourcePath.get((String[])new String[0]));
        agent.setStoreByForeignSource(Boolean.valueOf(false));
        CollectionSetBuilder collectionSetBuilder = new CollectionSetBuilder((CollectionAgent)agent);
        LatencyTypeResource resource = new LatencyTypeResource(svc.getSvcName(), svc.getIpAddr(), svc.getNodeLocation());
        resource.addTag("node_id", Integer.toString(svc.getNodeId()));
        resource.addTag("node_label", svc.getNodeLabel());
        resource.addTag("location", svc.getNodeLocation());
        if (snmpInfoInTags) {
            resource.addServiceParam("interface-info-in-tags", "true");
        }
        collectionSetBuilder.withGauge((Resource)resource, rrdBaseName, dsName, (Number)StatusStoringServiceMonitorAdaptor.buildPollStatusValue(status));
        CollectionSetDTO collectionSetDTO = collectionSetBuilder.build();
        collectionSetDTO.visit((CollectionSetVisitor)this.persisterFactory.createPersister(new ServiceParameters(Collections.emptyMap()), rrdRepository, false, true, true));
    }

    private static double buildPollStatusValue(PollStatus status) {
        switch (status.getStatusCode()) {
            case 1: {
                return 1.0;
            }
            case 2: {
                return 0.0;
            }
            case 3: {
                return -1.0;
            }
            case 0: {
                return Double.NaN;
            }
        }
        throw new IllegalStateException("Unhandled status code");
    }
}

