/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.util.Date;
import org.opennms.netmgt.poller.pollables.Scope;

public abstract class PollEvent {
    private final Scope m_scope;

    protected PollEvent(Scope scope) {
        this.m_scope = scope;
    }

    public final Scope getScope() {
        return this.m_scope;
    }

    public abstract long getEventId();

    public abstract Date getDate();

    public boolean isNodeDown() {
        return this.getScope().equals((Object)Scope.NODE);
    }

    public boolean isInterfaceDown() {
        return this.getScope().equals((Object)Scope.INTERFACE);
    }

    public boolean isNodeLostService() {
        return this.getScope().equals((Object)Scope.SERVICE);
    }

    public boolean hasLargerScopeThan(PollEvent e) {
        return Scope.isLargerThan(this.getScope(), e.getScope());
    }

    public boolean hasSmallerScopeThan(PollEvent e) {
        return Scope.isSmallerThan(this.getScope(), e.getScope());
    }

    public boolean hasScopeLargerThan(Scope scope) {
        return Scope.isLargerThan(this.getScope(), scope);
    }

    public boolean hasScopeSmallerThan(Scope scope) {
        return Scope.isSmallerThan(this.getScope(), scope);
    }

    public boolean hasSameScope(PollEvent e) {
        return this.getScope() == e.getScope();
    }

    public static PollEvent withLargestScope(PollEvent a, PollEvent b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (b.hasLargerScopeThan(a)) {
            return b;
        }
        return a;
    }
}

