/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.URL;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DominoIIOPMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(DominoIIOPMonitor.class);
    private static final int DEFAULT_PORT = 63148;
    private static final int DEFAULT_IORPORT = 80;
    private static final int DEFAULT_RETRY = 3;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        TimeoutTracker tracker = new TimeoutTracker(parameters, 3, 3000);
        int IORport = ParameterMap.getKeyedInteger(parameters, (String)"ior-port", (int)80);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)63148);
        InetAddress ipAddr = svc.getAddress();
        String hostAddress = InetAddressUtils.str((InetAddress)ipAddr);
        LOG.debug("poll: address = {}, port = {}, {}", new Object[]{hostAddress, port, tracker});
        try {
            this.retrieveIORText(hostAddress, IORport);
        }
        catch (Throwable e) {
            String reason = "failed to get the corba IOR from " + ipAddr;
            LOG.debug(reason, e);
            return PollStatus.unavailable(reason);
        }
        PollStatus status = null;
        tracker.reset();
        while (tracker.shouldRetry() && (status == null || !status.isAvailable())) {
            String reason;
            Socket socket = null;
            try {
                tracker.startAttempt();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipAddr, port), tracker.getConnectionTimeout());
                socket.setSoTimeout(tracker.getSoTimeout());
                LOG.debug("DominoIIOPMonitor: connected to host: {} on port: {}", (Object)ipAddr, (Object)port);
                PollStatus pollStatus = PollStatus.up(tracker.elapsedTimeInMillis());
                return pollStatus;
            }
            catch (NoRouteToHostException e) {
                reason = " No route to host exception for address " + hostAddress;
                LOG.debug(reason, (Throwable)e);
                status = PollStatus.unavailable(reason);
            }
            catch (InterruptedIOException e) {
                reason = "did not connect to host with " + tracker;
                LOG.debug(reason);
                status = PollStatus.unavailable(reason);
            }
            catch (ConnectException e) {
                reason = "Connection exception for address: " + ipAddr + " : " + e.getMessage();
                LOG.debug(reason);
                status = PollStatus.unavailable(reason);
            }
            catch (IOException e) {
                reason = "IOException while polling address: " + ipAddr + " : " + e.getMessage();
                LOG.debug(reason);
                status = PollStatus.unavailable(reason);
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {
                    e.fillInStackTrace();
                    LOG.debug("DominoIIOPMonitor: Error closing socket.", (Throwable)e);
                }
            }
            tracker.nextAttempt();
        }
        return status;
    }

    private String retrieveIORText(String host, int port) throws IOException {
        Object IOR = "";
        URL u = new URL("http://" + host + ":" + port + "/diiop_ior.txt");
        InputStream is = u.openStream();
        BufferedReader dis = new BufferedReader(new InputStreamReader(is));
        boolean done = false;
        while (!done) {
            String line = dis.readLine();
            if (line == null) {
                done = true;
                continue;
            }
            if (!((String)(IOR = (String)IOR + line)).startsWith("IOR:")) continue;
            done = true;
        }
        dis.close();
        if (!((String)IOR).startsWith("IOR:")) {
            throw new IOException("Invalid IOR: " + (String)IOR);
        }
        return IOR;
    }
}

