/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.dns;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.service.dns.DnsRequisitionProvider;
import org.opennms.netmgt.provision.service.dns.DnsRequisitionRequest;
import org.opennms.netmgt.provision.service.dns.ForeignIdHashSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsRequisitionUrlConnection
extends URLConnection {
    private static final Logger LOG = LoggerFactory.getLogger(DnsRequisitionUrlConnection.class);
    private static final String EXPRESSION_ARG = "expression";
    private static final String SERVICES_ARG = "services";
    private static final String LOCATION_ARG = "location";
    private static final String FID_HASH_SRC_ARG = "foreignidhashsource";
    private static final String[] HASH_IP_KEYWORDS = new String[]{"ip", "addr"};
    private static final String[] HASH_LABEL_KEYWORDS = new String[]{"name", "label"};
    private static final String QUERY_ARG_SEPARATOR = "&";
    public static final String URL_SCHEME = "dns://";
    public static final String PROTOCOL = "dns";
    private static final DnsRequisitionProvider s_provider = new DnsRequisitionProvider();
    private final DnsRequisitionRequest m_request;
    private final Map<String, String> m_args;

    public DnsRequisitionUrlConnection(URL url) throws MalformedURLException {
        super(url);
        this.m_args = DnsRequisitionUrlConnection.getUrlArgs(url);
        this.validateDnsUrl(url);
        this.m_request = new DnsRequisitionRequest();
        this.m_request.setHost(url.getHost());
        this.m_request.setPort(url.getPort() == -1 ? 53 : url.getPort());
        this.m_request.setZone(DnsRequisitionUrlConnection.parseZone(url));
        this.m_request.setForeignSource(DnsRequisitionUrlConnection.parseForeignSource(url));
        this.m_request.setExpression(DnsRequisitionUrlConnection.determineExpressionFromUrl(url));
        this.m_request.setLocation(DnsRequisitionUrlConnection.determineLocationFromUrl(url));
        this.m_request.setForeignIdHashSource(this.getForeignIdHashSource());
        this.m_request.setServices(Arrays.asList(this.getServices()));
        if (this.m_request.getZone() == null) {
            throw new IllegalArgumentException("Specified Zone is null");
        }
    }

    private Map<String, String> getArgs() {
        return this.m_args;
    }

    public DnsRequisitionRequest getRequest() {
        return this.m_request;
    }

    private String[] getServices() {
        if (this.getArgs() != null && this.getArgs().get(SERVICES_ARG) != null) {
            return this.getArgs().get(SERVICES_ARG).split(",");
        }
        return new String[]{"ICMP", "SNMP"};
    }

    private ForeignIdHashSource getForeignIdHashSource() {
        boolean hasIpKeywords = false;
        boolean hasLabelKeywords = false;
        if (this.getArgs() != null && this.getArgs().get(FID_HASH_SRC_ARG) != null) {
            String hashSourceArg = this.getArgs().get(FID_HASH_SRC_ARG).toLowerCase();
            for (String keyword : HASH_IP_KEYWORDS) {
                if (!hashSourceArg.contains(keyword)) continue;
                hasIpKeywords = true;
                break;
            }
            for (String keyword : HASH_LABEL_KEYWORDS) {
                if (!hashSourceArg.contains(keyword)) continue;
                hasLabelKeywords = true;
                break;
            }
        }
        if (hasIpKeywords && !hasLabelKeywords) {
            return ForeignIdHashSource.IP_ADDRESS;
        }
        if (hasIpKeywords && hasLabelKeywords) {
            return ForeignIdHashSource.NODE_LABEL_AND_IP_ADDRESS;
        }
        return ForeignIdHashSource.NODE_LABEL;
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            Requisition r = s_provider.getRequisition(this.m_request);
            return new ByteArrayInputStream(this.jaxBMarshal(r).getBytes());
        }
        catch (Exception e) {
            String message = "Problem getting input stream: " + e;
            LOG.warn(message, (Throwable)e);
            throw new IOExceptionWithCause(message, (Throwable)e);
        }
    }

    private String jaxBMarshal(Requisition r) throws JAXBException {
        return JaxbUtils.marshal((Object)r);
    }

    protected static String determineExpressionFromUrl(URL url) {
        LOG.info("determineExpressionFromUrl: finding regex as parameter in query string of URL: {}", (Object)url);
        Map<String, String> urlArgs = DnsRequisitionUrlConnection.getUrlArgs(url);
        if (urlArgs == null) {
            return null;
        }
        return urlArgs.get(EXPRESSION_ARG);
    }

    protected static String determineLocationFromUrl(URL url) {
        LOG.info("determineLocationFromUrl: finding regex as parameter in query string of URL: {}", (Object)url);
        Map<String, String> urlArgs = DnsRequisitionUrlConnection.getUrlArgs(url);
        if (urlArgs == null) {
            return null;
        }
        return urlArgs.get(LOCATION_ARG);
    }

    private static List<String> tokenizeQueryArgs(String query) throws IllegalArgumentException {
        if (query == null) {
            throw new IllegalArgumentException("The URL query is null");
        }
        List<String> queryArgs = Arrays.asList(StringUtils.split((String)query, (String)QUERY_ARG_SEPARATOR));
        return queryArgs;
    }

    protected static String decodeQueryString(URL url) {
        if (url == null || url.getQuery() == null) {
            throw new IllegalArgumentException("The URL or the URL query is null: " + url);
        }
        String query = null;
        try {
            query = URLDecoder.decode(url.getQuery(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("decodeQueryString", (Throwable)e);
        }
        return query;
    }

    protected void validateDnsUrl(URL url) throws MalformedURLException {
        String path = url.getPath();
        path = StringUtils.removeStart((String)path, (String)"/");
        if ((path = StringUtils.removeEnd((String)path, (String)"/")) == null || StringUtils.countMatches((String)path, (String)"/") > 1) {
            throw new MalformedURLException("The specified DNS URL contains invalid path: " + url);
        }
        String query = url.getQuery();
        if (query != null && DnsRequisitionUrlConnection.determineExpressionFromUrl(url) == null && DnsRequisitionUrlConnection.determineLocationFromUrl(url) == null && this.getArgs().get(SERVICES_ARG) == null && this.getArgs().get(FID_HASH_SRC_ARG) == null) {
            throw new MalformedURLException("The specified DNS URL contains an invalid query string: " + url);
        }
    }

    protected static String parseZone(URL url) {
        String path = url.getPath();
        path = StringUtils.removeStart((String)path, (String)"/");
        String zone = path = StringUtils.removeEnd((String)path, (String)"/");
        if (path != null && StringUtils.countMatches((String)path, (String)"/") == 1) {
            String[] paths = path.split("/");
            zone = paths[0];
        }
        return zone;
    }

    protected static String parseForeignSource(URL url) {
        String path = url.getPath();
        path = StringUtils.removeStart((String)path, (String)"/");
        String foreignSource = path = StringUtils.removeEnd((String)path, (String)"/");
        if (path != null && StringUtils.countMatches((String)path, (String)"/") == 1) {
            String[] paths = path.split("/");
            foreignSource = paths[1];
        }
        return foreignSource;
    }

    protected static Map<String, String> getUrlArgs(URL url) {
        if (url.getQuery() == null) {
            return null;
        }
        String query = DnsRequisitionUrlConnection.decodeQueryString(url);
        List<String> queryArgs = DnsRequisitionUrlConnection.tokenizeQueryArgs(query);
        HashMap<String, String> args = new HashMap<String, String>();
        for (String queryArg : queryArgs) {
            String[] argTokens = StringUtils.split((String)queryArg, (char)'=');
            if (argTokens.length < 2) {
                LOG.warn("getUrlArgs: syntax error in URL query string, missing '=' in query argument: {}", (Object)queryArg);
                continue;
            }
            LOG.debug("adding arg tokens {}, {}", (Object)argTokens[1], (Object)argTokens[0].toLowerCase());
            args.put(argTokens[0].toLowerCase(), argTokens[1]);
        }
        return args;
    }
}

