/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.groups;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.xml.StringTrimAdapter;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="group")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="groups.xsd")
@XmlType(propOrder={"m_name", "m_defaultMap", "m_comments", "users", "dutySchedules"})
public class Group
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="name", required=true)
    @XmlJavaTypeAdapter(value=StringTrimAdapter.class)
    private String m_name;
    @XmlElement(name="default-map")
    @XmlJavaTypeAdapter(value=StringTrimAdapter.class)
    private String m_defaultMap;
    @XmlElement(name="comments")
    @XmlJavaTypeAdapter(value=StringTrimAdapter.class)
    private String m_comments;
    private List<String> m_users = new ArrayList<String>();
    private List<String> m_dutySchedules = new ArrayList<String>();

    public Group() {
    }

    public Group(String name, String ... users) {
        this.setName(name);
        this.setUsers(Arrays.asList(users));
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(ConfigUtils.normalizeAndTrimString(name), "name");
    }

    public Optional<String> getDefaultMap() {
        return Optional.ofNullable(this.m_defaultMap);
    }

    public void setDefaultMap(String defaultMap) {
        this.m_defaultMap = ConfigUtils.normalizeAndTrimString(defaultMap);
    }

    public Optional<String> getComments() {
        return Optional.ofNullable(this.m_comments);
    }

    public void setComments(String comments) {
        this.m_comments = ConfigUtils.normalizeAndTrimString(comments);
    }

    @XmlElement(name="user")
    public List<String> getUsers() {
        return this.m_users;
    }

    public void setUsers(List<String> users) {
        if (users == this.m_users) {
            return;
        }
        this.m_users.clear();
        if (users != null) {
            this.m_users.addAll(users.stream().map(ConfigUtils::normalizeAndTrimString).collect(Collectors.toList()));
        }
    }

    public void addUser(String user) {
        this.m_users.add(ConfigUtils.normalizeAndTrimString(user));
    }

    public boolean removeUser(String user) {
        return this.m_users.remove(user);
    }

    public void clearUsers() {
        this.m_users.clear();
    }

    @XmlElement(name="duty-schedule")
    public List<String> getDutySchedules() {
        return this.m_dutySchedules;
    }

    public void setDutySchedules(List<String> dutySchedules) {
        if (dutySchedules == this.m_dutySchedules) {
            return;
        }
        this.m_dutySchedules.clear();
        if (dutySchedules != null) {
            this.m_dutySchedules.addAll(dutySchedules.stream().map(ConfigUtils::normalizeAndTrimString).collect(Collectors.toList()));
        }
    }

    public void addDutySchedule(String dutySchedule) {
        this.m_dutySchedules.add(ConfigUtils.normalizeAndTrimString(dutySchedule));
    }

    public void clearDutySchedules() {
        this.m_dutySchedules.clear();
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_defaultMap, this.m_comments, this.m_users, this.m_dutySchedules);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Group) {
            Group that = (Group)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_defaultMap, that.m_defaultMap) && Objects.equals(this.m_comments, that.m_comments) && Objects.equals(this.m_users, that.m_users) && Objects.equals(this.m_dutySchedules, that.m_dutySchedules);
        }
        return false;
    }

    public String toString() {
        return "Group [name=" + this.m_name + ", defaultMap=" + this.m_defaultMap + ", comments=" + this.m_comments + ", users=" + this.m_users + ", dutySchedules=" + this.m_dutySchedules + "]";
    }
}

