/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.openssl;

import java.io.IOException;
import java.io.Writer;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import org.opennms.shaded.org.bouncycastle.openssl.EncryptionException;
import org.opennms.shaded.org.bouncycastle.openssl.MiscPEMGenerator;
import org.opennms.shaded.org.bouncycastle.util.io.pem.PemGenerationException;
import org.opennms.shaded.org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.opennms.shaded.org.bouncycastle.util.io.pem.PemWriter;

public class PEMWriter
extends PemWriter {
    private String provider;

    public PEMWriter(Writer writer) {
        this(writer, "BC");
    }

    public PEMWriter(Writer writer, String string) {
        super(writer);
        this.provider = string;
    }

    public void writeObject(Object object) throws IOException {
        try {
            super.writeObject(new MiscPEMGenerator(object));
        }
        catch (PemGenerationException pemGenerationException) {
            if (pemGenerationException.getCause() instanceof IOException) {
                throw (IOException)pemGenerationException.getCause();
            }
            throw pemGenerationException;
        }
    }

    public void writeObject(PemObjectGenerator pemObjectGenerator) throws IOException {
        super.writeObject(pemObjectGenerator);
    }

    public void writeObject(Object object, String string, char[] cArray, SecureRandom secureRandom) throws IOException {
        try {
            super.writeObject(new MiscPEMGenerator(object, string, cArray, secureRandom, this.provider));
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new EncryptionException(noSuchProviderException.getMessage(), noSuchProviderException);
        }
    }
}

