/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.DfsReferralData;
import jcifs.DialectVersion;
import jcifs.RuntimeCIFSException;
import jcifs.SmbTree;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.CommonServerMessageBlockResponse;
import jcifs.internal.Request;
import jcifs.internal.TreeConnectResponse;
import jcifs.internal.smb1.ServerMessageBlock;
import jcifs.internal.smb1.com.SmbComBlankResponse;
import jcifs.internal.smb1.com.SmbComTreeDisconnect;
import jcifs.internal.smb1.trans.SmbComTransaction;
import jcifs.internal.smb1.trans2.Trans2FindFirst2;
import jcifs.internal.smb1.trans2.Trans2FindFirst2Response;
import jcifs.internal.smb2.ioctl.Smb2IoctlRequest;
import jcifs.internal.smb2.ioctl.Smb2IoctlResponse;
import jcifs.internal.smb2.ioctl.ValidateNegotiateInfoRequest;
import jcifs.internal.smb2.ioctl.ValidateNegotiateInfoResponse;
import jcifs.internal.smb2.nego.Smb2NegotiateRequest;
import jcifs.internal.smb2.nego.Smb2NegotiateResponse;
import jcifs.internal.smb2.tree.Smb2TreeDisconnectRequest;
import jcifs.smb.RequestParam;
import jcifs.smb.SMBProtocolDowngradeException;
import jcifs.smb.SMBSignatureValidationException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbSessionImpl;
import jcifs.smb.SmbTransportImpl;
import jcifs.smb.SmbTreeInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmbTreeImpl
implements SmbTreeInternal {
    private static final Logger log = LoggerFactory.getLogger(SmbTreeImpl.class);
    private static AtomicLong TREE_CONN_COUNTER = new AtomicLong();
    private final AtomicInteger connectionState = new AtomicInteger();
    private final String share;
    private final String service0;
    private final SmbSessionImpl session;
    private volatile int tid = -1;
    private volatile String service = "?????";
    private volatile boolean inDfs;
    private volatile boolean inDomainDfs;
    private volatile long treeNum;
    private final AtomicLong usageCount = new AtomicLong(0L);
    private final AtomicBoolean sessionAcquired = new AtomicBoolean(true);
    private final boolean traceResource;
    private final List<StackTraceElement[]> acquires;
    private final List<StackTraceElement[]> releases;
    private DfsReferralData treeReferral;

    SmbTreeImpl(SmbSessionImpl session, String share, String service) {
        this.session = session.acquire();
        this.share = share.toUpperCase();
        if (service != null && !service.startsWith("??")) {
            this.service = service;
        }
        this.service0 = this.service;
        this.traceResource = this.session.getConfig().isTraceResourceUsage();
        if (this.traceResource) {
            this.acquires = new LinkedList<StackTraceElement[]>();
            this.releases = new LinkedList<StackTraceElement[]>();
        } else {
            this.acquires = null;
            this.releases = null;
        }
    }

    boolean matches(String shr, String servc) {
        return this.share.equalsIgnoreCase(shr) && (servc == null || servc.startsWith("??") || this.service.equalsIgnoreCase(servc));
    }

    public boolean equals(Object obj) {
        if (obj instanceof SmbTreeImpl) {
            SmbTreeImpl tree = (SmbTreeImpl)obj;
            return this.matches(tree.share, tree.service);
        }
        return false;
    }

    public SmbTreeImpl acquire() {
        return this.acquire(true);
    }

    @Override
    public <T extends SmbTree> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new ClassCastException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmbTreeImpl acquire(boolean track) {
        Object object;
        long usage = this.usageCount.incrementAndGet();
        if (log.isTraceEnabled()) {
            log.trace("Acquire tree " + usage + " " + this);
        }
        if (track && this.traceResource) {
            object = this.acquires;
            synchronized (object) {
                this.acquires.add(SmbTreeImpl.truncateTrace(Thread.currentThread().getStackTrace()));
            }
        }
        if (usage == 1L) {
            object = this;
            synchronized (object) {
                if (this.sessionAcquired.compareAndSet(false, true)) {
                    log.debug("Reacquire session");
                    this.session.acquire();
                }
            }
        }
        return this;
    }

    @Override
    public void close() {
        this.release(false);
    }

    public void release() {
        this.release(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(boolean track) {
        Object object;
        long usage = this.usageCount.decrementAndGet();
        if (log.isTraceEnabled()) {
            log.trace("Release tree " + usage + " " + this);
        }
        if (track && this.traceResource) {
            object = this.releases;
            synchronized (object) {
                this.releases.add(SmbTreeImpl.truncateTrace(Thread.currentThread().getStackTrace()));
            }
        }
        if (usage == 0L) {
            object = this;
            synchronized (object) {
                log.debug("Usage dropped to zero, release session");
                if (this.sessionAcquired.compareAndSet(true, false)) {
                    this.session.release();
                }
            }
        } else if (usage < 0L) {
            log.error("Usage count dropped below zero " + this);
            this.dumpResource();
            throw new RuntimeCIFSException("Usage count dropped below zero");
        }
    }

    private static StackTraceElement[] truncateTrace(StackTraceElement[] stackTrace) {
        int s = 2;
        int e = stackTrace.length;
        for (int i = s; i < e; ++i) {
            StackTraceElement se = stackTrace[i];
            if (i == s && SmbTreeImpl.class.getName().equals(se.getClassName()) && "close".equals(se.getMethodName())) {
                ++s;
                continue;
            }
            if (!se.getClassName().startsWith("org.junit.runners.")) continue;
            e = i - 4;
            break;
        }
        StackTraceElement[] res = new StackTraceElement[e - s];
        System.arraycopy(stackTrace, s, res, 0, e - s);
        return res;
    }

    protected void finalize() throws Throwable {
        if (this.isConnected() && this.usageCount.get() != 0L) {
            log.warn("Tree was not properly released");
        }
    }

    public boolean isConnected() {
        return this.tid != -1 && this.session.isConnected() && this.connectionState.get() == 2;
    }

    public int getTreeType() {
        String connectedService = this.getService();
        if ("LPT1:".equals(connectedService)) {
            return 32;
        }
        if ("COMM".equals(connectedService)) {
            return 64;
        }
        return 8;
    }

    public String getService() {
        return this.service;
    }

    public String getShare() {
        return this.share;
    }

    public boolean isDfs() {
        return this.inDfs;
    }

    void markDomainDfs() {
        this.inDomainDfs = true;
    }

    public boolean isInDomainDfs() {
        return this.inDomainDfs;
    }

    public void setTreeReferral(DfsReferralData referral) {
        this.treeReferral = referral;
    }

    public DfsReferralData getTreeReferral() {
        return this.treeReferral;
    }

    public boolean isPossiblyDfs() throws SmbException {
        if (this.connectionState.get() == 2) {
            return this.isDfs();
        }
        try (SmbTransportImpl transport = this.session.getTransport();){
            boolean bl = transport.getNegotiateResponse().isDFSSupported();
            return bl;
        }
    }

    public SmbSessionImpl getSession() {
        return this.session.acquire();
    }

    public int getTid() {
        return this.tid;
    }

    public long getTreeNum() {
        return this.treeNum;
    }

    public int hashCode() {
        return this.share.hashCode() + 7 * this.service.hashCode();
    }

    @Override
    public <T extends CommonServerMessageBlockResponse> T send(Request<T> request, RequestParam ... params) throws CIFSException {
        return this.send(request, null, params != null && params.length > 0 ? EnumSet.copyOf(Arrays.asList(params)) : EnumSet.noneOf(RequestParam.class));
    }

    <T extends CommonServerMessageBlockResponse> T send(CommonServerMessageBlockRequest request, T response) throws CIFSException {
        return this.send(request, response, Collections.emptySet());
    }

    /*
     * Exception decompiling
     */
    <T extends CommonServerMessageBlockResponse> T send(CommonServerMessageBlockRequest request, T response, Set<RequestParam> params) throws CIFSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 39[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void checkRequest(SmbTransportImpl transport, ServerMessageBlock request, String svc) throws SmbException {
        if (!"A:".equals(svc)) {
            block0 : switch (request.getCommand()) {
                case -94: 
                case 4: 
                case 45: 
                case 46: 
                case 47: 
                case 113: {
                    break;
                }
                case 37: 
                case 50: {
                    switch (((SmbComTransaction)request).getSubCommand() & 0xFF) {
                        case -41: 
                        case 0: 
                        case 16: 
                        case 35: 
                        case 38: 
                        case 83: 
                        case 84: 
                        case 104: {
                            break block0;
                        }
                    }
                    throw new SmbException("Invalid operation for " + svc + " service: " + request);
                }
                default: {
                    throw new SmbException("Invalid operation for " + svc + " service" + request);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    <T extends CommonServerMessageBlockResponse> T treeConnect(CommonServerMessageBlockRequest andx, T andxResponse) throws CIFSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void treeConnected(SmbTransportImpl transport, SmbSessionImpl sess, TreeConnectResponse response) throws CIFSException {
        if (!response.isValidTid()) {
            throw new SmbException("TreeID is invalid");
        }
        this.tid = response.getTid();
        String rsvc = response.getService();
        if (rsvc == null && !transport.isSMB2()) {
            throw new SmbException("Service is NULL");
        }
        if (transport.getContext().getConfig().isIpcSigningEnforced() && ("IPC$".equals(this.getShare()) || "IPC".equals(rsvc)) && !sess.getCredentials().isAnonymous() && sess.getDigest() == null) {
            throw new SmbException("IPC signing is enforced, but no signing is available");
        }
        this.service = rsvc;
        this.inDfs = response.isShareDfs();
        this.treeNum = TREE_CONN_COUNTER.incrementAndGet();
        this.connectionState.set(2);
        try {
            this.validateNegotiation(transport, sess);
        }
        catch (CIFSException se) {
            try {
                transport.disconnect(true);
            }
            catch (IOException e) {
                log.warn("Failed to disconnect transport", (Throwable)e);
                se.addSuppressed(e);
            }
            throw se;
        }
    }

    private void validateNegotiation(SmbTransportImpl trans, SmbSessionImpl sess) throws CIFSException {
        Smb2IoctlResponse resp;
        if (!trans.isSMB2() || trans.getDigest() == null || !sess.getConfig().isRequireSecureNegotiate()) {
            log.debug("Secure negotiation does not apply");
            return;
        }
        Smb2NegotiateResponse nego = (Smb2NegotiateResponse)trans.getNegotiateResponse();
        if (nego.getSelectedDialect().atLeast(DialectVersion.SMB311)) {
            log.debug("Secure negotiation does not apply, is SMB3.1");
            return;
        }
        Smb2NegotiateRequest negoReq = new Smb2NegotiateRequest(sess.getConfig(), trans.getRequestSecurityMode(nego));
        log.debug("Sending VALIDATE_NEGOTIATE_INFO");
        Smb2IoctlRequest req = new Smb2IoctlRequest(sess.getConfig(), 1311236);
        req.setFlags(1);
        req.setInputData(new ValidateNegotiateInfoRequest(negoReq.getCapabilities(), negoReq.getClientGuid(), (short)negoReq.getSecurityMode(), negoReq.getDialects()));
        try {
            resp = this.send(req, RequestParam.NO_RETRY);
        }
        catch (SMBSignatureValidationException e) {
            throw new SMBProtocolDowngradeException("Signature error during negotiate validation", e);
        }
        catch (SmbException e) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("VALIDATE_NEGOTIATE_INFO response code 0x%x", e.getNtStatus()));
            }
            log.trace("VALIDATE_NEGOTIATE_INFO returned error", (Throwable)e);
            if (((Smb2IoctlResponse)req.getResponse()).isReceived() && ((Smb2IoctlResponse)req.getResponse()).isVerifyFailed() || e.getNtStatus() == -1073741790) {
                throw new SMBProtocolDowngradeException("Signature error during negotiate validation", e);
            }
            return;
        }
        ValidateNegotiateInfoResponse out = resp.getOutputData(ValidateNegotiateInfoResponse.class);
        if (nego.getSecurityMode() != out.getSecurityMode() || nego.getCapabilities() != out.getCapabilities() || nego.getDialectRevision() != out.getDialect() || !Arrays.equals(nego.getServerGuid(), out.getServerGuid())) {
            log.debug("Secure negotiation failure");
            throw new CIFSException("Mismatched attributes validating negotiate info");
        }
        log.debug("Secure negotiation OK");
    }

    private int waitForState(SmbTransportImpl transport) throws SmbException {
        int cs;
        while ((cs = this.connectionState.get()) != 0) {
            if (cs == 2) {
                return cs;
            }
            if (cs == 3) {
                throw new SmbException("Disconnecting during tree connect");
            }
            try {
                log.debug("Waiting for transport");
                transport.wait();
            }
            catch (InterruptedException ie) {
                throw new SmbException(ie.getMessage(), (Throwable)ie);
            }
        }
        return cs;
    }

    @Override
    @Deprecated
    public void connectLogon(CIFSContext tf) throws SmbException {
        if (tf.getConfig().getLogonShare() == null) {
            try {
                this.treeConnect(null, null);
            }
            catch (SmbException e) {
                throw e;
            }
            catch (CIFSException e) {
                throw SmbException.wrap(e);
            }
        }
        Trans2FindFirst2 req = new Trans2FindFirst2(tf.getConfig(), "\\", "*", 16, tf.getConfig().getListCount(), tf.getConfig().getListSize());
        Trans2FindFirst2Response resp = new Trans2FindFirst2Response(tf.getConfig());
        try {
            this.send(req, resp);
        }
        catch (SmbException e) {
            throw e;
        }
        catch (CIFSException e) {
            throw new SmbException("Logon share connection failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean treeDisconnect(boolean inError, boolean inUse) {
        boolean wasInUse = false;
        try (SmbSessionImpl sess = this.getSession();
             SmbTransportImpl transport = sess.getTransport();){
            SmbTransportImpl smbTransportImpl = transport;
            synchronized (smbTransportImpl) {
                int st = this.connectionState.getAndSet(3);
                if (st == 2) {
                    long l = this.usageCount.get();
                    if (inUse && l != 1L || !inUse && l > 0L) {
                        log.warn("Disconnected tree while still in use " + this);
                        this.dumpResource();
                        wasInUse = true;
                        if (sess.getConfig().isTraceResourceUsage()) {
                            throw new RuntimeCIFSException("Disconnected tree while still in use");
                        }
                    }
                    if (!inError && this.tid != -1) {
                        try {
                            if (transport.isSMB2()) {
                                Smb2TreeDisconnectRequest req = new Smb2TreeDisconnectRequest(sess.getConfig());
                                this.send((Request)req.ignoreDisconnect(), new RequestParam[0]);
                            } else {
                                this.send(new SmbComTreeDisconnect(sess.getConfig()), new SmbComBlankResponse(sess.getConfig()));
                            }
                        }
                        catch (CIFSException se) {
                            log.error("Tree disconnect failed", (Throwable)se);
                        }
                    }
                }
                this.inDfs = false;
                this.inDomainDfs = false;
                this.connectionState.set(0);
                transport.notifyAll();
            }
        }
        return wasInUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpResource() {
        if (!this.traceResource) {
            return;
        }
        List<StackTraceElement[]> list = this.acquires;
        synchronized (list) {
            for (Object[] objectArray : this.acquires) {
                log.debug("Acquire " + Arrays.toString(objectArray));
            }
        }
        list = this.releases;
        synchronized (list) {
            for (Object[] objectArray : this.releases) {
                log.debug("Release " + Arrays.toString(objectArray));
            }
        }
    }

    public String toString() {
        return "SmbTree[share=" + this.share + ",service=" + this.service + ",tid=" + this.tid + ",inDfs=" + this.inDfs + ",inDomainDfs=" + this.inDomainDfs + ",connectionState=" + this.connectionState + ",usage=" + this.usageCount.get() + "]";
    }
}

