/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.model.LldpLink;
import org.opennms.netmgt.enlinkd.snmp.LldpLocalTableTracker;
import org.opennms.netmgt.enlinkd.snmp.MtxrLldpRemTableTracker;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LldpSnmpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LldpSnmpUtils.class);
    private static final String humanReadableRegex = ".*[a-zA-Z].*";
    private static final String isNumberRegex = "-?\\d+(\\.\\d+)?([eE][+-]?\\d+)?";

    public static String getInterface(SnmpValue snmpValue) {
        if (snmpValue == null) {
            return "Null";
        }
        if (LldpSnmpUtils.humanReadable(snmpValue.toDisplayString()) || snmpValue.toDisplayString().contains("-") || snmpValue.toDisplayString().contains("/")) {
            return snmpValue.toDisplayString();
        }
        return LldpSnmpUtils.getDisplayable(snmpValue);
    }

    public static String getMacAddress(SnmpValue snmpValue) {
        if (InetAddressUtils.isValidBridgeAddress((String)LldpSnmpUtils.formatMacAddress(LldpSnmpUtils.getDisplayable(snmpValue)))) {
            return LldpSnmpUtils.formatMacAddress(LldpSnmpUtils.getDisplayable(snmpValue));
        }
        if (snmpValue.isDisplayable() && InetAddressUtils.isValidBridgeAddress((String)LldpSnmpUtils.formatMacAddress(snmpValue.toDisplayString()))) {
            return LldpSnmpUtils.formatMacAddress(snmpValue.toDisplayString());
        }
        LOG.error("getMacAddress: not valid mac found: {}", (Object)LldpSnmpUtils.formatMacAddress(LldpSnmpUtils.getDisplayable(snmpValue)));
        return LldpSnmpUtils.formatMacAddress(LldpSnmpUtils.getDisplayable(snmpValue));
    }

    public static String getNetworkAddress(SnmpValue snmpValue) {
        if (snmpValue == null) {
            return "Null";
        }
        try {
            return LldpUtils.decodeNetworkAddress((String)LldpSnmpUtils.getDisplayable(snmpValue));
        }
        catch (Exception e) {
            LOG.debug("getNetworkAddress: value not valid {}", (Object)LldpSnmpUtils.getDisplayable(snmpValue));
            try {
                return LldpUtils.decodeNetworkAddress((String)snmpValue.toDisplayString());
            }
            catch (Exception e2) {
                LOG.debug("getNetworkAddress: not valid {}", (Object)snmpValue.toDisplayString());
                return "Not Valid";
            }
        }
    }

    public static boolean isNumber(String input) {
        if (input == null || input.isEmpty()) {
            return false;
        }
        return input.matches(isNumberRegex);
    }

    public static boolean humanReadable(String input) {
        if (input == null || input.isEmpty()) {
            return false;
        }
        Pattern pattern = Pattern.compile(humanReadableRegex);
        return pattern.matcher(input).matches();
    }

    public static String getDisplayable(SnmpValue snmpValue) {
        if (snmpValue == null) {
            return "Null";
        }
        try {
            LOG.debug("getDisplayable: displayable {} hex value {}", (Object)snmpValue.isDisplayable(), (Object)snmpValue.toHexString());
            return snmpValue.toHexString();
        }
        catch (Exception e) {
            LOG.error("getDisplayable: got not Hex Value {}", (Object)e.getMessage(), (Object)e);
            try {
                LOG.debug("getDisplayable: displayable value {}", (Object)snmpValue.toDisplayString());
                return snmpValue.toDisplayString();
            }
            catch (Exception e2) {
                LOG.error("getDisplayable: got not displayable Value {}", (Object)e2.getMessage(), (Object)e2);
                return "Not Displayable";
            }
        }
    }

    private static String formatMacAddress(String mac) {
        return mac.replaceAll("\\s+", "").replaceAll(":", "").replaceAll("-", "").toLowerCase(Locale.ROOT);
    }

    public static LldpUtils.LldpChassisIdSubType decodeLldpChassisSubType(Integer subTypeInt) {
        if (subTypeInt == null || subTypeInt == 0 || subTypeInt > 7) {
            return LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_LOCAL;
        }
        return LldpUtils.LldpChassisIdSubType.get((Integer)subTypeInt);
    }

    public static String decodeLldpChassisId(LldpUtils.LldpChassisIdSubType lldpChassisIdSubType, SnmpValue snmpValue) {
        switch (lldpChassisIdSubType) {
            case LLDP_CHASSISID_SUBTYPE_MACADDRESS: {
                return LldpSnmpUtils.getMacAddress(snmpValue);
            }
            case LLDP_CHASSISID_SUBTYPE_NETWORKADDRESS: {
                return LldpSnmpUtils.getNetworkAddress(snmpValue);
            }
        }
        if (LldpSnmpUtils.humanReadable(snmpValue.toDisplayString())) {
            return snmpValue.toDisplayString();
        }
        return LldpSnmpUtils.getDisplayable(snmpValue);
    }

    public static String decodeLldpPortId(LldpUtils.LldpPortIdSubType type, SnmpValue snmpValue) {
        switch (type) {
            case LLDP_PORTID_SUBTYPE_LOCAL: {
                if (LldpSnmpUtils.isNumber(snmpValue.toDisplayString())) {
                    return snmpValue.toDisplayString();
                }
                return LldpSnmpUtils.getDisplayable(snmpValue);
            }
            case LLDP_PORTID_SUBTYPE_INTERFACENAME: 
            case LLDP_PORTID_SUBTYPE_INTERFACEALIAS: {
                return LldpSnmpUtils.getInterface(snmpValue);
            }
            case LLDP_PORTID_SUBTYPE_MACADDRESS: {
                return LldpSnmpUtils.getMacAddress(snmpValue);
            }
            case LLDP_PORTID_SUBTYPE_NETWORKADDRESS: {
                return LldpSnmpUtils.getNetworkAddress(snmpValue);
            }
        }
        if (LldpSnmpUtils.humanReadable(LldpSnmpUtils.getDisplayable(snmpValue))) {
            return LldpSnmpUtils.getDisplayable(snmpValue);
        }
        return snmpValue.toDisplayString();
    }

    public static LldpUtils.LldpPortIdSubType decodeLldpPortSubType(Integer lldpPortIdSubType, SnmpValue lldpportid) {
        if (lldpPortIdSubType == null || lldpPortIdSubType == 0 || lldpPortIdSubType > 7) {
            try {
                String macAddress = LldpSnmpUtils.getMacAddress(lldpportid);
                if (InetAddressUtils.isValidBridgeAddress((String)macAddress)) {
                    return LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_MACADDRESS;
                }
            }
            catch (IllegalArgumentException e) {
                LOG.debug("decodeLldpPortSubType: no mac address: {}", (Object)e.getMessage());
            }
            try {
                if (lldpportid.isDisplayable()) {
                    Integer.parseInt(lldpportid.toDisplayString());
                    return LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_LOCAL;
                }
            }
            catch (NumberFormatException e) {
                LOG.debug("decodeLldpPortSubType: no LOCAL PORT: {}", (Object)lldpportid.toDisplayString());
            }
            try {
                if (lldpportid.isDisplayable()) {
                    lldpportid.toInetAddress();
                    return LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_NETWORKADDRESS;
                }
            }
            catch (Exception e) {
                LOG.debug("decodeLldpPortSubType: no NETWORK ADDRESS");
            }
            try {
                if (lldpportid.isDisplayable()) {
                    return LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACENAME;
                }
            }
            catch (Exception e) {
                LOG.debug("no DISPLAY VALUE");
            }
            return LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_PORTCOMPONENT;
        }
        return LldpUtils.LldpPortIdSubType.get((Integer)lldpPortIdSubType);
    }

    public static String decodeTimeTetraLldpPortId(LldpUtils.LldpPortIdSubType portSubType, SnmpValue snmpValue) {
        if (portSubType == LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_LOCAL) {
            return String.valueOf(Integer.parseInt(LldpSnmpUtils.decodeLldpPortId(LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_LOCAL, snmpValue), 16));
        }
        return LldpSnmpUtils.decodeLldpPortId(portSubType, snmpValue);
    }

    public static LldpLink getLldpLink(MtxrLldpRemTableTracker.MtxrLldpRemRow mtxrlldprow, Integer mtxrIndex, Map<Integer, LldpLocalTableTracker.LldpLocalPortRow> mtxrLldpLocalPortMap) {
        LldpLink lldpLink = mtxrlldprow.getLldpLink();
        if (mtxrIndex != null && mtxrLldpLocalPortMap.containsKey(mtxrIndex)) {
            lldpLink.setLldpPortIfindex(mtxrIndex);
            lldpLink.setLldpPortIdSubType(LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACENAME);
            lldpLink.setLldpPortId(mtxrLldpLocalPortMap.get(mtxrIndex).getLldpLocPortDesc());
            lldpLink.setLldpPortDescr(mtxrLldpLocalPortMap.get(mtxrIndex).getLldpLocPortDesc());
            LOG.debug("getLldpLink: interfaceId {} -> portId {}", (Object)mtxrIndex, (Object)lldpLink.getLldpPortId());
        } else {
            lldpLink.setLldpPortIdSubType(LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACEALIAS);
            lldpLink.setLldpPortId("\"Not Found On lldpLocPortTable\"");
            lldpLink.setLldpPortDescr("");
            LOG.debug("getLldpLink: setting default not found Values: portidtype \"InterfaceAlias\", portid=\"Not Found On lldpLocPortTable\"");
        }
        return lldpLink;
    }
}

