/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.asset.layers;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opennms.features.topology.plugins.topo.asset.layers.Key;
import org.opennms.features.topology.plugins.topo.asset.layers.LayerDefinition;
import org.opennms.features.topology.plugins.topo.asset.layers.Layers;
import org.opennms.features.topology.plugins.topo.asset.layers.Restriction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerDefinitionRepository {
    private static Logger LOG = LoggerFactory.getLogger(LayerDefinitionRepository.class);

    public List<LayerDefinition> getDefinitions(Collection<String> layerKeys) {
        ArrayList<LayerDefinition> layerDefinitions = new ArrayList<LayerDefinition>();
        for (String layerKey : layerKeys) {
            LayerDefinition layerDefinition = this.getLayerDefinition(layerKey);
            layerDefinitions.add(layerDefinition);
        }
        return layerDefinitions;
    }

    private LayerDefinition getLayerDefinition(String layerKey) {
        for (Layers layerEnum : Layers.values()) {
            try {
                String enumLayerKey;
                Field enumField = ((Object)((Object)layerEnum)).getClass().getField(layerEnum.name());
                Key key = enumField.getAnnotation(Key.class);
                Restriction restriction = enumField.getAnnotation(Restriction.class);
                String string = enumLayerKey = key != null ? key.value() : layerEnum.getLayer().getId();
                if (!enumLayerKey.equals(layerKey)) continue;
                return new LayerDefinition(layerKey, layerEnum.getLayer(), restriction != null ? restriction.hql() : null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        LOG.warn("No layer definition found for layer key {}. Skipping.", (Object)layerKey);
        return null;
    }
}

