/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.kubernetes;

import io.hawt.util.Strings;
import io.hawt.web.kubernetes.DefaultProxyAddress;
import io.hawt.web.kubernetes.ServiceResolver;
import io.hawt.web.proxy.ProxyAddress;
import io.hawt.web.proxy.ProxyServlet;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodServlet
extends ProxyServlet {
    private static final transient Logger LOG = LoggerFactory.getLogger(PodServlet.class);

    @Override
    protected ProxyAddress parseProxyAddress(HttpServletRequest servletRequest) {
        String reqQueryString = servletRequest.getQueryString();
        String queryPostfix = "";
        if (Strings.isNotBlank((String)reqQueryString)) {
            queryPostfix = "?" + reqQueryString;
        }
        String userName = null;
        String password = null;
        String podName = servletRequest.getPathInfo();
        if (podName == null) {
            podName = "";
        }
        if (podName.startsWith("/")) {
            podName = podName.substring(1);
        }
        int idx = podName.indexOf(47);
        String podPort = "";
        String podPath = "/";
        if (idx > 0) {
            podPath = podName.substring(idx);
            podName = podName.substring(0, idx);
            idx = podPath.indexOf(47, 1);
            if (idx >= 0) {
                podPort = podPath.substring(1, idx);
                podPath = podPath.substring(idx);
            }
        }
        if (podName.isEmpty()) {
            String url = ServiceResolver.getSingleton().getServiceURL("kubernetes");
            if (url == null) {
                return null;
            }
            url = url + "/kubernetes/api/v1beta2/pods" + queryPostfix;
            return new DefaultProxyAddress(url, userName, password);
        }
        String url = ServiceResolver.getSingleton().getPodUrl(podName, podPort);
        if (url == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No pod for: " + podName + " port: " + podPort + " path: " + podPath);
            }
            System.out.println("No pod for: " + podName + " port: " + podPort + " path: " + podPath);
            return null;
        }
        url = url + podPath + queryPostfix;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking: " + url + " from pod: " + podName + " port: " + podPort + " path: " + podPath);
        }
        System.out.println("Invoking: " + url + " from pod: " + podName + " port: " + podPort + " path: " + podPath);
        return new DefaultProxyAddress(url, userName, password);
    }
}

