/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.reporting.rest.internal;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opennms.api.reporting.ReportFormat;
import org.opennms.api.reporting.parameter.ReportDateParm;
import org.opennms.api.reporting.parameter.ReportDoubleParm;
import org.opennms.api.reporting.parameter.ReportFloatParm;
import org.opennms.api.reporting.parameter.ReportIntParm;
import org.opennms.api.reporting.parameter.ReportParameters;
import org.opennms.api.reporting.parameter.ReportStringParm;
import org.opennms.api.reporting.parameter.ReportTimezoneParm;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.reporting.core.DeliveryOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDetails {
    private static final Logger LOG = LoggerFactory.getLogger(ReportDetails.class);
    private String reportId;
    private ReportParameters parameters = new ReportParameters();
    private List<ReportFormat> formats = Lists.newArrayList();
    private List<Category> categories = Lists.newArrayList();
    private List<OnmsCategory> surveillanceCategories = Lists.newArrayList();
    private List<String> timezones = Lists.newArrayList();
    private DeliveryOptions deliveryOptions;
    private String cronExpression;

    public String getReportId() {
        return this.reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = Objects.requireNonNull(reportId);
    }

    public ReportParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(ReportParameters parameters) {
        this.parameters = Objects.requireNonNull(parameters);
    }

    public List<ReportFormat> getFormats() {
        return Collections.unmodifiableList(this.formats);
    }

    public void setFormats(List<ReportFormat> formats) {
        this.formats.clear();
        this.formats.addAll(formats);
    }

    public List<Category> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public void setCategories(List<Category> categories) {
        Objects.requireNonNull(categories);
        this.categories.clear();
        this.categories.addAll(categories);
    }

    public List<OnmsCategory> getSurveillanceCategories() {
        return Collections.unmodifiableList(this.surveillanceCategories);
    }

    public void setSurveillanceCategories(List<OnmsCategory> surveillanceCategories) {
        Objects.requireNonNull(surveillanceCategories);
        this.surveillanceCategories.clear();
        this.surveillanceCategories.addAll(surveillanceCategories);
    }

    public void setDeliveryOptions(DeliveryOptions deliveryOptions) {
        this.deliveryOptions = deliveryOptions;
    }

    public DeliveryOptions getDeliveryOptions() {
        return this.deliveryOptions;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = Objects.requireNonNull(cronExpression);
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public List<String> getTimezones() {
        return this.timezones;
    }

    public void setTimezones(List<String> timezones) {
        this.timezones = Objects.requireNonNull(timezones);
    }

    public JSONObject toJson() {
        JSONArray jsonFormats = new JSONArray();
        for (ReportFormat reportFormat : this.formats) {
            JSONObject jsonFormat = new JSONObject();
            jsonFormat.put("ordinal", reportFormat.ordinal());
            jsonFormat.put("name", (Object)reportFormat.name());
            jsonFormats.put((Object)jsonFormat);
        }
        JSONArray jsonParameters = new JSONArray();
        if (this.parameters.getDateParms() != null) {
            for (ReportDateParm dateParm : this.parameters.getDateParms()) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("type", (Object)"date");
                jSONObject.put("name", (Object)dateParm.getName());
                jSONObject.put("displayName", (Object)dateParm.getDisplayName());
                jSONObject.put("useAbsoluteDate", (Object)dateParm.getUseAbsoluteDate());
                jSONObject.put("count", (Object)dateParm.getCount());
                jSONObject.put("interval", (Object)dateParm.getInterval());
                jSONObject.put("hours", (Object)dateParm.getHours());
                jSONObject.put("minutes", (Object)dateParm.getMinutes());
                if (dateParm.getDate() != null) {
                    ZoneId zoneId = this.getZoneId();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    sdf.setTimeZone(TimeZone.getTimeZone(zoneId));
                    jSONObject.put("date", (Object)sdf.format(dateParm.getDate()));
                }
                jsonParameters.put((Object)jSONObject);
            }
        }
        if (this.parameters.getDoubleParms() != null) {
            for (ReportDoubleParm doubleParm : this.parameters.getDoubleParms()) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("type", (Object)"double");
                jSONObject.put("name", (Object)doubleParm.getName());
                jSONObject.put("displayName", (Object)doubleParm.getDisplayName());
                jSONObject.put("value", (Object)doubleParm.getValue());
                jSONObject.put("inputType", (Object)doubleParm.getInputType());
                jsonParameters.put((Object)jSONObject);
            }
        }
        if (this.parameters.getFloatParms() != null) {
            for (ReportFloatParm floatParm : this.parameters.getFloatParms()) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("type", (Object)"float");
                jSONObject.put("name", (Object)floatParm.getName());
                jSONObject.put("displayName", (Object)floatParm.getDisplayName());
                jSONObject.put("value", (Object)floatParm.getValue());
                jSONObject.put("inputType", (Object)floatParm.getInputType());
                jsonParameters.put((Object)jSONObject);
            }
        }
        if (this.parameters.getIntParms() != null) {
            for (ReportIntParm intParm : this.parameters.getIntParms()) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("type", (Object)"integer");
                jSONObject.put("name", (Object)intParm.getName());
                jSONObject.put("displayName", (Object)intParm.getDisplayName());
                jSONObject.put("value", intParm.getValue());
                jSONObject.put("inputType", (Object)intParm.getInputType());
                jsonParameters.put((Object)jSONObject);
            }
        }
        if (this.parameters.getStringParms() != null) {
            for (ReportStringParm stringParm : this.parameters.getStringParms()) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("type", (Object)"string");
                jSONObject.put("name", (Object)stringParm.getName());
                jSONObject.put("displayName", (Object)stringParm.getDisplayName());
                jSONObject.put("value", (Object)stringParm.getValue());
                jSONObject.put("inputType", (Object)stringParm.getInputType());
                jsonParameters.put((Object)jSONObject);
            }
        }
        if (this.parameters.getTimezoneParms() != null) {
            for (ReportTimezoneParm parm : this.parameters.getTimezoneParms()) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("type", (Object)"timezone");
                jSONObject.put("name", (Object)parm.getName());
                jSONObject.put("displayName", (Object)parm.getDisplayName());
                jSONObject.put("value", (Object)parm.getValue());
                jsonParameters.put((Object)jSONObject);
            }
        }
        JSONArray jSONArray = new JSONArray();
        for (OnmsCategory onmsCategory : this.surveillanceCategories) {
            jSONArray.put((Object)onmsCategory.getName());
        }
        JSONArray jsonSurveillanceCategories = new JSONArray();
        for (Category eachCategory : this.categories) {
            jsonSurveillanceCategories.put((Object)eachCategory.getLabel());
        }
        JSONArray jSONArray2 = new JSONArray(this.timezones);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)this.reportId);
        jsonObject.put("parameters", (Object)jsonParameters);
        jsonObject.put("formats", (Object)jsonFormats);
        jsonObject.put("categories", (Object)jSONArray);
        jsonObject.put("surveillanceCategories", (Object)jsonSurveillanceCategories);
        jsonObject.put("timezones", (Object)jSONArray2);
        if (this.deliveryOptions != null) {
            jsonObject.put("deliveryOptions", (Object)new JSONObject((Object)this.deliveryOptions));
        }
        if (!Strings.isNullOrEmpty((String)this.cronExpression)) {
            jsonObject.put("cronExpression", (Object)this.cronExpression);
        }
        return jsonObject;
    }

    private ZoneId getZoneId() {
        ZoneId zoneId = ZoneId.systemDefault();
        List zones = this.parameters.getTimezoneParms();
        if (zones != null && zones.size() > 0) {
            try {
                zoneId = ZoneId.of(((ReportTimezoneParm)zones.get(0)).getValue());
            }
            catch (Exception e) {
                LOG.warn("Failed to determine timezone from: {}", zones.get(0));
            }
        }
        return zoneId;
    }
}

