/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.updates;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opennms.netmgt.graph.api.ImmutableGraph;
import org.opennms.netmgt.graph.api.ImmutableGraphContainer;
import org.opennms.netmgt.graph.api.updates.ChangeSet;
import org.opennms.netmgt.graph.api.updates.ContainerChangeSet;
import org.opennms.netmgt.graph.api.updates.GraphNotificationService;
import org.opennms.netmgt.graph.api.updates.listener.GraphChangeListener;
import org.opennms.netmgt.graph.api.updates.listener.GraphChangeSetListener;
import org.opennms.netmgt.graph.api.updates.listener.GraphContainerChangeListener;
import org.opennms.netmgt.graph.api.updates.listener.GraphContainerChangeSetListener;

public class DefaultGraphNotificationService
implements GraphNotificationService {
    private List<GraphChangeSetListener> graphChangeSetListeners = new CopyOnWriteArrayList<GraphChangeSetListener>();
    private List<GraphContainerChangeSetListener> graphContainerChangeSetListeners = new CopyOnWriteArrayList<GraphContainerChangeSetListener>();
    private Map<GraphContainerChangeListener, GraphContainerChangeSetListener> graphContainerChangeListenerToChangeSetListener = new ConcurrentHashMap<GraphContainerChangeListener, GraphContainerChangeSetListener>();
    private Map<GraphChangeListener, GraphChangeSetListener> graphChangeListenerToChangeSetListener = new ConcurrentHashMap<GraphChangeListener, GraphChangeSetListener>();

    public void containerChanged(ImmutableGraphContainer oldContainer, ImmutableGraphContainer newContainer) {
        ContainerChangeSet containerChangeSet = ContainerChangeSet.builder((ImmutableGraphContainer)oldContainer, (ImmutableGraphContainer)newContainer).build();
        this.containerChanged(containerChangeSet);
    }

    public void containerChanged(ContainerChangeSet containerChangeSet) {
        Objects.requireNonNull(containerChangeSet);
        if (containerChangeSet.hasChanges()) {
            for (GraphContainerChangeSetListener listener : this.graphContainerChangeSetListeners) {
                listener.graphContainerChanged(containerChangeSet);
                if (containerChangeSet.getGraphsUpdated().isEmpty()) continue;
                containerChangeSet.getGraphsUpdated().forEach(this::graphChanged);
            }
        }
    }

    public void graphChanged(ImmutableGraph oldGraph, ImmutableGraph newGraph) {
        ChangeSet changeSet = ChangeSet.builder((ImmutableGraph)oldGraph, (ImmutableGraph)newGraph).build();
        this.graphChanged(changeSet);
    }

    public void graphChanged(ChangeSet graphChangeSet) {
        Objects.requireNonNull(graphChangeSet);
        if (graphChangeSet.hasChanges()) {
            for (GraphChangeSetListener listener : this.graphChangeSetListeners) {
                listener.graphChanged(graphChangeSet);
            }
        }
    }

    public synchronized void onBind(GraphChangeListener listener, Map<String, String> props) {
        if (listener == null) {
            return;
        }
        GraphChangeSetListener wrappedListener = changeSet -> {
            if (!changeSet.getVerticesAdded().isEmpty()) {
                listener.handleVerticesAdded(changeSet.getVerticesAdded());
            }
            if (!changeSet.getVerticesRemoved().isEmpty()) {
                listener.handleVerticesRemoved(changeSet.getVerticesRemoved());
            }
            if (!changeSet.getVerticesUpdated().isEmpty()) {
                listener.handleVerticesUpdated(changeSet.getVerticesUpdated());
            }
            if (!changeSet.getEdgesAdded().isEmpty()) {
                listener.handleEdgesAdded(changeSet.getEdgesAdded());
            }
            if (!changeSet.getEdgesRemoved().isEmpty()) {
                listener.handleEdgesRemoved(changeSet.getEdgesRemoved());
            }
            if (!changeSet.getEdgesUpdated().isEmpty()) {
                listener.handleEdgesUpdated(changeSet.getEdgesUpdated());
            }
            if (changeSet.getFocus() != null) {
                listener.handleFocusChanged(changeSet.getFocus());
            }
            if (changeSet.getGraphInfo() != null) {
                listener.handleGraphInfoChanged(changeSet.getGraphInfo());
            }
        };
        this.graphChangeListenerToChangeSetListener.put(listener, wrappedListener);
        this.graphChangeSetListeners.add(wrappedListener);
    }

    public synchronized void onBind(GraphChangeSetListener listener, Map<String, String> props) {
        if (listener == null) {
            return;
        }
        this.graphChangeSetListeners.add(listener);
    }

    public synchronized void onBind(GraphContainerChangeListener listener, Map<String, String> props) {
        if (listener == null) {
            return;
        }
        GraphContainerChangeSetListener wrappedListener = changeSet -> {
            if (!changeSet.getGraphsAdded().isEmpty()) {
                changeSet.getGraphsAdded().forEach(arg_0 -> ((GraphContainerChangeListener)listener).handleGraphAdded(arg_0));
            }
            if (!changeSet.getGraphsRemoved().isEmpty()) {
                changeSet.getGraphsRemoved().forEach(arg_0 -> ((GraphContainerChangeListener)listener).handleGraphRemoved(arg_0));
            }
            if (!changeSet.getGraphsUpdated().isEmpty()) {
                changeSet.getGraphsUpdated().forEach(arg_0 -> ((GraphContainerChangeListener)listener).handleGraphUpdated(arg_0));
            }
        };
        this.graphContainerChangeListenerToChangeSetListener.put(listener, wrappedListener);
        this.graphContainerChangeSetListeners.add(wrappedListener);
    }

    public synchronized void onBind(GraphContainerChangeSetListener listener, Map<String, String> props) {
        if (listener == null) {
            return;
        }
        this.graphContainerChangeSetListeners.add(listener);
    }

    public synchronized void onUnbind(GraphChangeListener listener, Map<String, String> props) {
        if (listener == null) {
            return;
        }
        GraphChangeSetListener wrappedListener = this.graphChangeListenerToChangeSetListener.remove(listener);
        if (wrappedListener != null) {
            this.graphChangeSetListeners.remove(wrappedListener);
        }
    }

    public synchronized void onUnbind(GraphChangeSetListener listener, Map<String, String> props) {
        if (listener == null) {
            return;
        }
        this.graphChangeSetListeners.remove(listener);
    }

    public synchronized void onUnbind(GraphContainerChangeListener listener, Map<String, String> props) {
        if (listener == null) {
            return;
        }
        GraphContainerChangeSetListener wrappedListener = this.graphContainerChangeListenerToChangeSetListener.remove(listener);
        if (wrappedListener != null) {
            this.graphContainerChangeSetListeners.remove(wrappedListener);
        }
    }

    public synchronized void onUnbind(GraphContainerChangeSetListener listener, Map<String, String> props) {
        if (listener == null) {
            return;
        }
        this.graphContainerChangeSetListeners.remove(listener);
    }
}

