/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.model.CdpLink;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdpCacheTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(CdpCacheTableTracker.class);
    public static final SnmpObjId CDP_CACHE_ADDRESS_TYPE_OID = SnmpObjId.get((String)".1.3.6.1.4.1.9.9.23.1.2.1.1.3");
    public static final SnmpObjId CDP_CACHE_ADDRESS_OID = SnmpObjId.get((String)".1.3.6.1.4.1.9.9.23.1.2.1.1.4");
    public static final SnmpObjId CDP_CACHE_VERSION_OID = SnmpObjId.get((String)".1.3.6.1.4.1.9.9.23.1.2.1.1.5");
    public static final SnmpObjId CDP_CACHE_DEVICE_ID_OID = SnmpObjId.get((String)".1.3.6.1.4.1.9.9.23.1.2.1.1.6");
    public static final SnmpObjId CDP_CACHE_DEVICE_PORT_OID = SnmpObjId.get((String)".1.3.6.1.4.1.9.9.23.1.2.1.1.7");
    public static final SnmpObjId CDP_CACHE_PLATFORM_OID = SnmpObjId.get((String)".1.3.6.1.4.1.9.9.23.1.2.1.1.8");
    public static final String CDP_CACHE_ADDRESS_TYPE = "cdpCacheAddressType";
    public static final String CDP_CACHE_ADDRESS = "cdpCacheAddress";
    public static final String CDP_CACHE_VERSION = "cdpCacheVersion";
    public static final String CDP_CACHE_DEVICE_ID = "cdpCacheDeviceId";
    public static final String CDP_CACHE_DEVICE_PORT = "cdpCacheDevicePort";
    public static final String CDP_CACHE_PLATFORM = "cdpCachePlatform";
    public static final SnmpObjId[] cdpCache_elemList = new SnmpObjId[]{CDP_CACHE_ADDRESS_TYPE_OID, CDP_CACHE_ADDRESS_OID, CDP_CACHE_VERSION_OID, CDP_CACHE_DEVICE_ID_OID, CDP_CACHE_DEVICE_PORT_OID, CDP_CACHE_PLATFORM_OID};

    public CdpCacheTableTracker() {
        super(cdpCache_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new CdpCacheRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processCdpCacheRow((CdpCacheRow)row);
    }

    public void processCdpCacheRow(CdpCacheRow row) {
        System.out.printf("\t\t%s (%s)= %s (%s)\n", CDP_CACHE_ADDRESS_TYPE_OID + "." + row.getInstance().toString(), CDP_CACHE_ADDRESS_TYPE, row.getCdpCacheAddressType(), CdpLink.CiscoNetworkProtocolType.get((Integer)row.getCdpCacheAddressType()));
        System.out.printf("\t\t%s (%s)= %s \n", CDP_CACHE_ADDRESS_OID + "." + row.getInstance().toString(), CDP_CACHE_ADDRESS, row.getCdpCacheAddressString());
        System.out.printf("\t\t%s (%s)= %s \n", CDP_CACHE_VERSION_OID + "." + row.getInstance().toString(), CDP_CACHE_VERSION, row.getCdpCacheVersion());
        System.out.printf("\t\t%s (%s)= %s \n", CDP_CACHE_DEVICE_ID_OID + "." + row.getInstance().toString(), CDP_CACHE_DEVICE_ID, row.getCdpCacheDeviceId());
        System.out.printf("\t\t%s (%s)= %s \n", CDP_CACHE_DEVICE_PORT_OID + "." + row.getInstance().toString(), CDP_CACHE_DEVICE_PORT, row.getCdpCacheDevicePort());
        System.out.printf("\t\t%s (%s)= %s \n", CDP_CACHE_PLATFORM_OID + "." + row.getInstance().toString(), CDP_CACHE_PLATFORM, row.getCdpCachePlatform());
    }

    public static class CdpCacheRow
    extends SnmpRowResult {
        public CdpCacheRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
            LOG.debug("column count = {}, instance = {}", (Object)columnCount, (Object)instance);
        }

        public Integer getCdpCacheIfIndex() {
            return this.getInstance().getSubIdAt(this.getInstance().length() - 2);
        }

        public Integer getCdpCacheDeviceIndex() {
            return this.getInstance().getLastSubId();
        }

        public Integer getCdpCacheAddressType() {
            return this.getValue(CDP_CACHE_ADDRESS_TYPE_OID).toInt();
        }

        public byte[] getCdpCacheAddress() {
            return this.getValue(CDP_CACHE_ADDRESS_OID).getBytes();
        }

        private InetAddress getCdpCacheInetAddress() {
            return InetAddressUtils.getInetAddress((byte[])this.getCdpCacheAddress());
        }

        private String getDisplayableCdpCacheAddress() {
            SnmpValue cdpCacheAddressValue = this.getValue(CDP_CACHE_ADDRESS_OID);
            try {
                if (cdpCacheAddressValue.isDisplayable()) {
                    return cdpCacheAddressValue.toDisplayString();
                }
            }
            catch (Exception e) {
                return cdpCacheAddressValue.toHexString();
            }
            return "not able to diplay";
        }

        public String getCdpCacheAddressString() {
            CdpLink.CiscoNetworkProtocolType type = CdpLink.CiscoNetworkProtocolType.get((Integer)this.getCdpCacheAddressType());
            return switch (type) {
                case CdpLink.CiscoNetworkProtocolType.ip, CdpLink.CiscoNetworkProtocolType.ipv6 -> {
                    try {
                        yield InetAddressUtils.str((InetAddress)this.getCdpCacheInetAddress());
                    }
                    catch (Exception e) {
                        yield this.getDisplayableCdpCacheAddress();
                    }
                }
                default -> this.getDisplayableCdpCacheAddress();
            };
        }

        public String getCdpCacheVersion() {
            return this.getValue(CDP_CACHE_VERSION_OID).toDisplayString();
        }

        public String getCdpCacheDeviceId() {
            if (this.getValue(CDP_CACHE_DEVICE_ID_OID).isDisplayable()) {
                return this.getValue(CDP_CACHE_DEVICE_ID_OID).toDisplayString();
            }
            return this.getValue(CDP_CACHE_DEVICE_ID_OID).toHexString();
        }

        public String getCdpCacheDevicePort() {
            if (this.getValue(CDP_CACHE_DEVICE_PORT_OID).isDisplayable()) {
                return this.getValue(CDP_CACHE_DEVICE_PORT_OID).toDisplayString();
            }
            return this.getValue(CDP_CACHE_DEVICE_PORT_OID).toHexString();
        }

        public String getCdpCachePlatform() {
            return this.getValue(CDP_CACHE_PLATFORM_OID).toDisplayString();
        }

        public CdpLink getLink() {
            LOG.debug("processCdpCacheRow: row index: cdpCacheIfindex: {} cdpCacheDeviceIndex: {}", (Object)this.getCdpCacheIfIndex(), (Object)this.getCdpCacheDeviceIndex());
            CdpLink link = new CdpLink();
            link.setCdpCacheIfIndex(this.getCdpCacheIfIndex());
            link.setCdpCacheDeviceIndex(this.getCdpCacheDeviceIndex());
            link.setCdpCacheAddressType(CdpLink.CiscoNetworkProtocolType.get((Integer)this.getCdpCacheAddressType()));
            link.setCdpCacheAddress(this.getCdpCacheAddressString());
            link.setCdpCacheVersion(this.getCdpCacheVersion());
            link.setCdpCacheDeviceId(this.getCdpCacheDeviceId());
            link.setCdpCacheDevicePort(this.getCdpCacheDevicePort());
            link.setCdpCacheDevicePlatform(this.getCdpCachePlatform());
            return link;
        }
    }
}

