/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mox;

import com.vmware.vim25.ConcurrentAccess;
import com.vmware.vim25.ConfigTarget;
import com.vmware.vim25.DeviceNotSupported;
import com.vmware.vim25.DistributedVirtualPortgroupInfo;
import com.vmware.vim25.DistributedVirtualPortgroupPortgroupType;
import com.vmware.vim25.DistributedVirtualSwitchPortConnection;
import com.vmware.vim25.DuplicateName;
import com.vmware.vim25.FileFault;
import com.vmware.vim25.GuestOsDescriptor;
import com.vmware.vim25.InsufficientResourcesFault;
import com.vmware.vim25.InvalidDatastore;
import com.vmware.vim25.InvalidName;
import com.vmware.vim25.InvalidPowerState;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.NetworkSummary;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInProgress;
import com.vmware.vim25.VirtualCdrom;
import com.vmware.vim25.VirtualCdromAtapiBackingInfo;
import com.vmware.vim25.VirtualCdromIsoBackingInfo;
import com.vmware.vim25.VirtualCdromRemotePassthroughBackingInfo;
import com.vmware.vim25.VirtualController;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDeviceBackingInfo;
import com.vmware.vim25.VirtualDeviceConfigSpec;
import com.vmware.vim25.VirtualDeviceConfigSpecFileOperation;
import com.vmware.vim25.VirtualDeviceConfigSpecOperation;
import com.vmware.vim25.VirtualDeviceConnectInfo;
import com.vmware.vim25.VirtualDeviceFileBackingInfo;
import com.vmware.vim25.VirtualDisk;
import com.vmware.vim25.VirtualDiskFlatVer2BackingInfo;
import com.vmware.vim25.VirtualDiskMode;
import com.vmware.vim25.VirtualDiskType;
import com.vmware.vim25.VirtualE1000;
import com.vmware.vim25.VirtualEthernetCard;
import com.vmware.vim25.VirtualEthernetCardDistributedVirtualPortBackingInfo;
import com.vmware.vim25.VirtualEthernetCardNetworkBackingInfo;
import com.vmware.vim25.VirtualFloppy;
import com.vmware.vim25.VirtualFloppyDeviceBackingInfo;
import com.vmware.vim25.VirtualFloppyImageBackingInfo;
import com.vmware.vim25.VirtualFloppyRemoteDeviceBackingInfo;
import com.vmware.vim25.VirtualIDEController;
import com.vmware.vim25.VirtualMachineCdromInfo;
import com.vmware.vim25.VirtualMachineConfigOption;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VirtualMachineNetworkInfo;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualPCNet32;
import com.vmware.vim25.VirtualSCSIController;
import com.vmware.vim25.VirtualUSB;
import com.vmware.vim25.VirtualUSBController;
import com.vmware.vim25.VirtualVmxnet;
import com.vmware.vim25.VirtualVmxnet2;
import com.vmware.vim25.VirtualVmxnet3;
import com.vmware.vim25.VmConfigFault;
import com.vmware.vim25.mo.ComputeResource;
import com.vmware.vim25.mo.EnvironmentBrowser;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class VirtualMachineDeviceManager {
    private VirtualMachine vm;
    private static Logger log = Logger.getLogger(VirtualMachineDeviceManager.class);

    public VirtualMachineDeviceManager(VirtualMachine vm) {
        this.vm = vm;
    }

    public VirtualMachine getVM() {
        return this.vm;
    }

    public Task addFloppyDriveFromISO(String floppyImagePath, boolean startConnected) throws InvalidName, VmConfigFault, DuplicateName, TaskInProgress, FileFault, InvalidState, ConcurrentAccess, InvalidDatastore, InsufficientResourcesFault, RuntimeFault, RemoteException {
        return this.addFloppyDrive(floppyImagePath, null, null, startConnected);
    }

    public Task addFloppyDriveFromHost(String hostDevice, boolean startConnected) throws InvalidName, VmConfigFault, DuplicateName, TaskInProgress, FileFault, InvalidState, ConcurrentAccess, InvalidDatastore, InsufficientResourcesFault, RuntimeFault, RemoteException {
        return this.addFloppyDrive(null, null, hostDevice, startConnected);
    }

    public Task createFloppyDrive(String floppyImagePath, boolean startConnected) throws InvalidName, VmConfigFault, DuplicateName, TaskInProgress, FileFault, InvalidState, ConcurrentAccess, InvalidDatastore, InsufficientResourcesFault, RuntimeFault, RemoteException {
        return this.addFloppyDrive(null, floppyImagePath, null, startConnected);
    }

    private Task addFloppyDrive(String floppyImagePath, String newFloppyImagePath, String hostDevice, boolean startConnected) throws InvalidName, VmConfigFault, DuplicateName, TaskInProgress, FileFault, InvalidState, ConcurrentAccess, InvalidDatastore, InsufficientResourcesFault, RuntimeFault, RemoteException {
        VirtualDeviceBackingInfo backing;
        if (this.vm.getRuntime().getPowerState() == VirtualMachinePowerState.poweredOff) {
            throw new RuntimeException("Invalid power state: power off this VM before adding a floppy drive.");
        }
        VirtualFloppy floppy = new VirtualFloppy();
        floppy.connectable = new VirtualDeviceConnectInfo();
        floppy.connectable.startConnected = startConnected;
        if (hostDevice != null) {
            backing = new VirtualFloppyDeviceBackingInfo();
            backing.deviceName = hostDevice;
            floppy.backing = backing;
        } else if (floppyImagePath != null) {
            backing = new VirtualFloppyImageBackingInfo();
            ((VirtualFloppyImageBackingInfo)backing).fileName = floppyImagePath;
            floppy.backing = backing;
        } else if (newFloppyImagePath != null) {
            backing = new VirtualFloppyImageBackingInfo();
            ((VirtualFloppyImageBackingInfo)backing).fileName = newFloppyImagePath;
            floppy.backing = backing;
        } else {
            backing = new VirtualFloppyRemoteDeviceBackingInfo();
            ((VirtualFloppyRemoteDeviceBackingInfo)backing).deviceName = "";
            floppy.backing = backing;
            floppy.connectable.startConnected = false;
            floppy.connectable.connected = false;
        }
        floppy.key = -1;
        VirtualDeviceConfigSpec floppySpec = new VirtualDeviceConfigSpec();
        floppySpec.operation = VirtualDeviceConfigSpecOperation.add;
        if (newFloppyImagePath != null) {
            floppySpec.fileOperation = VirtualDeviceConfigSpecFileOperation.create;
        }
        floppySpec.device = floppy;
        VirtualMachineConfigSpec config = new VirtualMachineConfigSpec();
        config.deviceChange = new VirtualDeviceConfigSpec[]{floppySpec};
        VirtualIDEController controller = this.getFirstAvailableController(VirtualIDEController.class);
        if (controller == null) {
            throw new RuntimeException("No available IDE controller for floppy drive.");
        }
        config.deviceChange[0].device.controllerKey = controller.key;
        return this.vm.reconfigVM_Task(config);
    }

    public String getPassThroughDevice(String type) {
        return "";
    }

    public void addPassthroughDevice() {
    }

    public void removePassthroughDevice() {
    }

    public Task addCdDriveFromIso(String isoPath, boolean startConnected) throws InvalidProperty, RuntimeFault, RemoteException, InterruptedException {
        return this.addCdDrive(isoPath, null, startConnected);
    }

    public Task addCdDriveFromHost(String hostDevice, boolean startConnected) throws InvalidProperty, RuntimeFault, RemoteException, InterruptedException {
        return this.addCdDrive(null, hostDevice, startConnected);
    }

    private Task addCdDrive(String isoPath, String hostDevice, boolean startConnected) throws InvalidProperty, RuntimeFault, RemoteException, InterruptedException {
        VirtualDeviceBackingInfo backing;
        VirtualMachinePowerState powerState = this.vm.getRuntime().getPowerState();
        if (powerState != VirtualMachinePowerState.poweredOff) {
            throw new RuntimeException("VM is not yet powered off for adding a CD drive.");
        }
        VirtualCdrom cdrom = new VirtualCdrom();
        cdrom.connectable = new VirtualDeviceConnectInfo();
        cdrom.connectable.allowGuestControl = true;
        cdrom.connectable.startConnected = startConnected;
        if (hostDevice != null) {
            this.validateCdromHostDevice(hostDevice);
            backing = new VirtualCdromAtapiBackingInfo();
            ((VirtualCdromAtapiBackingInfo)backing).deviceName = hostDevice;
            cdrom.backing = backing;
        } else if (isoPath != null) {
            backing = new VirtualCdromIsoBackingInfo();
            backing.fileName = isoPath;
            cdrom.backing = backing;
        } else {
            backing = new VirtualCdromRemotePassthroughBackingInfo();
            ((VirtualCdromRemotePassthroughBackingInfo)backing).exclusive = true;
            ((VirtualCdromRemotePassthroughBackingInfo)backing).deviceName = "";
            cdrom.backing = backing;
        }
        cdrom.key = -1;
        VirtualDeviceConfigSpec cdSpec = new VirtualDeviceConfigSpec();
        cdSpec.operation = VirtualDeviceConfigSpecOperation.add;
        cdSpec.device = cdrom;
        VirtualMachineConfigSpec config = new VirtualMachineConfigSpec();
        config.deviceChange = new VirtualDeviceConfigSpec[]{cdSpec};
        VirtualIDEController controller = this.getFirstAvailableController(VirtualIDEController.class);
        if (controller == null) {
            throw new RuntimeException("No free IDE controller for addtional CD Drive.");
        }
        config.deviceChange[0].device.controllerKey = controller.key;
        Task task = this.vm.reconfigVM_Task(config);
        return task;
    }

    private void validateCdromHostDevice(String hostDevice) throws InvalidProperty, RuntimeFault, RemoteException {
        List<String> validCdList = this.getValidCdromOnHost();
        if (!validCdList.contains(hostDevice)) {
            throw new RuntimeException("Invalid host device path for CD drives.");
        }
    }

    private List<String> getValidCdromOnHost() throws InvalidProperty, RuntimeFault, RemoteException {
        ConfigTarget configTarget;
        ArrayList<String> result = new ArrayList<String>();
        EnvironmentBrowser envBrower = this.vm.getEnvironmentBrowser();
        try {
            configTarget = envBrower.queryConfigTarget(null);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error in getting Cdrom devices from host.");
        }
        if (configTarget != null && configTarget.cdRom != null) {
            for (VirtualMachineCdromInfo cdromInfo : configTarget.cdRom) {
                result.add(cdromInfo.name);
            }
        }
        return result;
    }

    public void createHardDisk(int diskSizeMB, VirtualDiskType type, VirtualDiskMode mode) throws Exception {
        VirtualMachineConfigSpec vmConfigSpec = new VirtualMachineConfigSpec();
        VirtualDeviceConfigSpec diskSpec = new VirtualDeviceConfigSpec();
        VirtualDiskFlatVer2BackingInfo diskfileBacking = new VirtualDiskFlatVer2BackingInfo();
        diskfileBacking.setFileName("");
        diskfileBacking.setDiskMode(mode.toString());
        diskfileBacking.setThinProvisioned(type == VirtualDiskType.thin);
        VirtualSCSIController scsiController = this.getFirstAvailableController(VirtualSCSIController.class);
        int unitNumber = this.getFirstFreeUnitNumberForController(scsiController);
        VirtualDisk disk = new VirtualDisk();
        disk.setControllerKey(scsiController.key);
        disk.setUnitNumber(unitNumber);
        disk.setBacking(diskfileBacking);
        disk.setCapacityInKB(1024 * diskSizeMB);
        disk.setKey(-1);
        diskSpec.setOperation(VirtualDeviceConfigSpecOperation.add);
        diskSpec.setFileOperation(VirtualDeviceConfigSpecFileOperation.create);
        diskSpec.setDevice(disk);
        VirtualDeviceConfigSpec[] vdiskSpecArray = new VirtualDeviceConfigSpec[]{diskSpec};
        vmConfigSpec.setDeviceChange(vdiskSpecArray);
        Task task = this.vm.reconfigVM_Task(vmConfigSpec);
        task.waitForTask(200, 100);
    }

    public void addHardDisk(String diskFilePath, VirtualDiskMode diskMode) throws Exception {
        VirtualMachineConfigSpec vmConfigSpec = new VirtualMachineConfigSpec();
        VirtualDeviceConfigSpec diskSpec = new VirtualDeviceConfigSpec();
        VirtualDeviceConfigSpec[] vdiskSpecArray = new VirtualDeviceConfigSpec[]{diskSpec};
        vmConfigSpec.setDeviceChange(vdiskSpecArray);
        VirtualDiskFlatVer2BackingInfo diskfileBacking = new VirtualDiskFlatVer2BackingInfo();
        diskfileBacking.setFileName(diskFilePath);
        diskfileBacking.setDiskMode(diskMode.toString());
        VirtualSCSIController scsiController = this.getFirstAvailableController(VirtualSCSIController.class);
        int unitNumber = this.getFirstFreeUnitNumberForController(scsiController);
        VirtualDisk disk = new VirtualDisk();
        disk.setControllerKey(scsiController.key);
        disk.setUnitNumber(unitNumber);
        disk.setBacking(diskfileBacking);
        disk.setKey(-100);
        diskSpec.setOperation(VirtualDeviceConfigSpecOperation.add);
        diskSpec.setDevice(disk);
        Task task = this.vm.reconfigVM_Task(vmConfigSpec);
        task.waitForTask(200, 100);
    }

    public VirtualDisk findHardDisk(String diskName) {
        VirtualDevice[] devices = this.getAllVirtualDevices();
        for (int i = 0; i < devices.length; ++i) {
            VirtualDisk vDisk;
            if (!(devices[i] instanceof VirtualDisk) || !diskName.equalsIgnoreCase((vDisk = (VirtualDisk)devices[i]).getDeviceInfo().getLabel())) continue;
            return vDisk;
        }
        return null;
    }

    private int getFirstFreeUnitNumberForController(VirtualController controller) {
        if (controller.device == null) {
            return 0;
        }
        int maxNodes = VirtualMachineDeviceManager.getMaxNodesPerControllerOfType(controller);
        if (controller.device.length < maxNodes) {
            ArrayList<Integer> usedNodeList = new ArrayList<Integer>();
            VirtualDevice[] devices = this.getAllVirtualDevices();
            if (controller instanceof VirtualSCSIController) {
                usedNodeList.add(((VirtualSCSIController)controller).scsiCtlrUnitNumber);
            }
            for (VirtualDevice device : devices) {
                if (device.controllerKey == null || device.controllerKey != controller.key) continue;
                usedNodeList.add(device.unitNumber);
            }
            for (int i = 0; i < maxNodes; ++i) {
                if (usedNodeList.contains(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public void createNetworkAdapter(VirtualNetworkAdapterType type, String networkName, String macAddress, boolean wakeOnLan, boolean startConnected) throws InvalidProperty, RuntimeFault, RemoteException, InterruptedException {
        VirtualMachinePowerState powerState = this.vm.getRuntime().getPowerState();
        String vmVerStr = this.vm.getConfig().getVersion();
        int vmVer = Integer.parseInt(vmVerStr.substring(vmVerStr.length() - 2));
        if (powerState == VirtualMachinePowerState.suspended) {
            throw new InvalidPowerState();
        }
        HostSystem host = new HostSystem(this.vm.getServerConnection(), this.vm.getRuntime().getHost());
        ComputeResource cr = (ComputeResource)host.getParent();
        EnvironmentBrowser envBrowser = cr.getEnvironmentBrowser();
        ConfigTarget configTarget = envBrowser.queryConfigTarget(host);
        VirtualMachineConfigOption vmCfgOpt = envBrowser.queryConfigOption(null, host);
        type = VirtualMachineDeviceManager.validateNicType(vmCfgOpt.getGuestOSDescriptor(), this.vm.getConfig().getGuestId(), type);
        VirtualDeviceConfigSpec nicSpec = this.createNicSpec(type, networkName, macAddress, wakeOnLan, startConnected, configTarget);
        VirtualMachineConfigSpec vmConfigSpec = new VirtualMachineConfigSpec();
        vmConfigSpec.setDeviceChange(new VirtualDeviceConfigSpec[]{nicSpec});
        Task task = this.vm.reconfigVM_Task(vmConfigSpec);
        task.waitForTask(200, 100);
    }

    private VirtualDeviceConfigSpec createNicSpec(VirtualNetworkAdapterType adapterType, String networkName, String macAddress, boolean wakeOnLan, boolean startConnected, ConfigTarget configTarget) {
        VirtualDeviceConfigSpec result = null;
        DistributedVirtualPortgroupInfo dvPortgroupInfo = null;
        if (configTarget.distributedVirtualPortgroup != null) {
            dvPortgroupInfo = VirtualMachineDeviceManager.findDVPortgroupInfo(configTarget.distributedVirtualPortgroup, networkName);
        }
        if (dvPortgroupInfo != null) {
            this.validateDVPortGroupForVNicConnection(dvPortgroupInfo);
            VirtualEthernetCardDistributedVirtualPortBackingInfo nicBacking = new VirtualEthernetCardDistributedVirtualPortBackingInfo();
            nicBacking.port = new DistributedVirtualSwitchPortConnection();
            nicBacking.port.portgroupKey = dvPortgroupInfo.portgroupKey;
            nicBacking.port.switchUuid = dvPortgroupInfo.switchUuid;
            result = VirtualMachineDeviceManager.createNicSpec(adapterType, macAddress, wakeOnLan, startConnected, nicBacking);
        } else {
            NetworkSummary netSummary = VirtualMachineDeviceManager.getHostNetworkSummaryByName(networkName, configTarget.network);
            VirtualEthernetCardNetworkBackingInfo nicBacking = new VirtualEthernetCardNetworkBackingInfo();
            nicBacking.network = netSummary.network;
            nicBacking.deviceName = netSummary.name;
            result = VirtualMachineDeviceManager.createNicSpec(adapterType, macAddress, wakeOnLan, startConnected, nicBacking);
        }
        return result;
    }

    private void validateDVPortGroupForVNicConnection(DistributedVirtualPortgroupInfo dvPortgroupInfo) {
        if (dvPortgroupInfo.uplinkPortgroup) {
            throw new RuntimeException("The vDS portgroup's uplinkPortgroup should not be null");
        }
        DistributedVirtualPortgroupPortgroupType portgroupType = DistributedVirtualPortgroupPortgroupType.valueOf(dvPortgroupInfo.portgroupType);
        String prodLineId = this.vm.getServerConnection().getServiceInstance().getAboutInfo().getProductLineId();
        if (prodLineId.indexOf("ESX") != -1 && (portgroupType == DistributedVirtualPortgroupPortgroupType.earlyBinding || portgroupType == DistributedVirtualPortgroupPortgroupType.lateBinding)) {
            throw new RuntimeException("ESX does not support early or late binding!");
        }
    }

    private static NetworkSummary getHostNetworkSummaryByName(String networkName, VirtualMachineNetworkInfo[] hostNetworkList) {
        NetworkSummary result = null;
        boolean isNetworkExistingOnHost = false;
        for (VirtualMachineNetworkInfo netInfo : hostNetworkList) {
            if (!networkName.equals(netInfo.name)) continue;
            isNetworkExistingOnHost = true;
            if (netInfo.network.accessible) {
                result = netInfo.network;
                break;
            }
            throw new RuntimeException("Network: " + networkName + " is not accessible.");
        }
        if (!isNetworkExistingOnHost) {
            throw new RuntimeException("Network: " + networkName + " does not exist on host network.");
        }
        return result;
    }

    private static DistributedVirtualPortgroupInfo findDVPortgroupInfo(DistributedVirtualPortgroupInfo[] hostDistributedVirtualPortgroupInfo, String portgroupName) {
        DistributedVirtualPortgroupInfo result = null;
        if (hostDistributedVirtualPortgroupInfo != null) {
            for (DistributedVirtualPortgroupInfo portgroupInfo : hostDistributedVirtualPortgroupInfo) {
                if (!portgroupInfo.portgroupName.equalsIgnoreCase(portgroupName)) continue;
                result = portgroupInfo;
                break;
            }
        }
        return result;
    }

    private static VirtualDeviceConfigSpec createNicSpec(VirtualNetworkAdapterType adapterType, String macAddress, boolean wakeOnLan, boolean startConnected, VirtualDeviceBackingInfo nicBacking) {
        VirtualEthernetCard device;
        VirtualDeviceConfigSpec result = new VirtualDeviceConfigSpec();
        switch (adapterType) {
            case VirtualVmxnet: {
                device = new VirtualVmxnet();
                break;
            }
            case VirtualVmxnet2: {
                device = new VirtualVmxnet2();
                break;
            }
            case VirtualVmxnet3: {
                device = new VirtualVmxnet3();
                break;
            }
            case VirtualPCNet32: {
                device = new VirtualPCNet32();
                break;
            }
            case VirtualE1000: {
                device = new VirtualE1000();
                break;
            }
            default: {
                device = new VirtualVmxnet();
            }
        }
        if (macAddress == null) {
            device.addressType = "generated";
        } else {
            device.addressType = "manual";
            device.macAddress = macAddress;
        }
        device.wakeOnLanEnabled = wakeOnLan;
        device.backing = nicBacking;
        device.connectable = new VirtualDeviceConnectInfo();
        device.connectable.connected = true;
        device.connectable.startConnected = startConnected;
        device.key = -1;
        result.operation = VirtualDeviceConfigSpecOperation.add;
        result.device = device;
        return result;
    }

    private static VirtualNetworkAdapterType validateNicType(GuestOsDescriptor[] guestOsDescriptorList, String guestId, VirtualNetworkAdapterType adapterType) throws DeviceNotSupported {
        VirtualNetworkAdapterType result = adapterType;
        GuestOsDescriptor guestOsInfo = null;
        for (GuestOsDescriptor desc : guestOsDescriptorList) {
            if (!desc.getId().equalsIgnoreCase(guestId)) continue;
            guestOsInfo = desc;
            break;
        }
        if (adapterType == VirtualNetworkAdapterType.Unknown) {
            result = VirtualMachineDeviceManager.TryGetNetworkAdapterType(guestOsInfo);
        } else if (guestOsInfo.getSupportedEthernetCard() != null) {
            boolean supported = false;
            ArrayList<String> supportedTypeList = new ArrayList<String>();
            for (String supportedAdapterName : guestOsInfo.getSupportedEthernetCard()) {
                VirtualNetworkAdapterType supportedAdapterType = VirtualMachineDeviceManager.GetNetworkAdapterTypeByApiType(supportedAdapterName);
                supportedTypeList.add(supportedAdapterType.toString());
                if (supportedAdapterType != adapterType) continue;
                supported = true;
                break;
            }
            if (!supported) {
                DeviceNotSupported dns = new DeviceNotSupported();
                dns.setDevice("Virtual NIC");
                dns.setReason("The requested NIC is not supported in this OS.");
                throw dns;
            }
        }
        return result;
    }

    private static VirtualNetworkAdapterType TryGetNetworkAdapterType(GuestOsDescriptor guestOsInfo) {
        String ethernetCardType = guestOsInfo.getRecommendedEthernetCard();
        if ((ethernetCardType == null || ethernetCardType.isEmpty()) && guestOsInfo.getSupportedEthernetCard() != null && guestOsInfo.getSupportedEthernetCard().length > 0) {
            ethernetCardType = guestOsInfo.getSupportedEthernetCard()[0];
        }
        return VirtualMachineDeviceManager.GetNetworkAdapterTypeByApiType(ethernetCardType);
    }

    private static VirtualNetworkAdapterType GetNetworkAdapterTypeByApiType(String ethernetCardType) {
        return VirtualNetworkAdapterType.valueOf(ethernetCardType);
    }

    public Task removeDevice(VirtualDevice device, boolean destroyDeviceBacking) throws InvalidName, VmConfigFault, DuplicateName, TaskInProgress, FileFault, InvalidState, ConcurrentAccess, InvalidDatastore, InsufficientResourcesFault, RuntimeFault, RemoteException {
        ArrayList<VirtualDevice> deviceList = new ArrayList<VirtualDevice>();
        deviceList.add(device);
        return this.removeDevices(deviceList, destroyDeviceBacking);
    }

    public Task removeDevices(List<VirtualDevice> deviceList, boolean destroyDeviceBacking) throws InvalidName, VmConfigFault, DuplicateName, TaskInProgress, FileFault, InvalidState, ConcurrentAccess, InvalidDatastore, InsufficientResourcesFault, RuntimeFault, RemoteException {
        ArrayList<VirtualDeviceConfigSpec> configSpecList = new ArrayList<VirtualDeviceConfigSpec>();
        boolean allDevicesSupportHotRemoval = this.allSupportHotRemoval(deviceList);
        VirtualMachinePowerState powerState = this.vm.getRuntime().getPowerState();
        if (!allDevicesSupportHotRemoval && powerState != VirtualMachinePowerState.poweredOff) {
            throw new RuntimeException("Invalid power state: power off the VM first.");
        }
        block2: for (VirtualDevice device : deviceList) {
            try {
                VirtualDeviceConfigSpec controllerSpec;
                List<VirtualController> contollerList;
                if (device instanceof VirtualDisk && powerState == VirtualMachinePowerState.poweredOff) {
                    contollerList = this.getVirtualDevicesOfType(VirtualSCSIController.class);
                    for (VirtualSCSIController virtualSCSIController : contollerList) {
                        if (virtualSCSIController.key != device.controllerKey) continue;
                        if (virtualSCSIController.device.length != 1 || virtualSCSIController.device[0] != device.key) break;
                        controllerSpec = new VirtualDeviceConfigSpec();
                        controllerSpec.operation = VirtualDeviceConfigSpecOperation.remove;
                        controllerSpec.device = virtualSCSIController;
                        configSpecList.add(controllerSpec);
                        break;
                    }
                }
                if (device instanceof VirtualUSB) {
                    contollerList = this.getVirtualDevicesOfType(VirtualUSBController.class);
                    for (VirtualUSBController virtualUSBController : contollerList) {
                        if (virtualUSBController.key != device.controllerKey) continue;
                        if (virtualUSBController.device.length != 1 || virtualUSBController.device[0] != device.key) continue block2;
                        controllerSpec = new VirtualDeviceConfigSpec();
                        controllerSpec.operation = VirtualDeviceConfigSpecOperation.remove;
                        controllerSpec.device = virtualUSBController;
                        configSpecList.add(controllerSpec);
                        continue block2;
                    }
                    continue;
                }
                VirtualDeviceConfigSpec deviceSpec = new VirtualDeviceConfigSpec();
                deviceSpec.operation = VirtualDeviceConfigSpecOperation.remove;
                deviceSpec.device = device;
                if (destroyDeviceBacking) {
                    deviceSpec.fileOperation = VirtualDeviceConfigSpecFileOperation.destroy;
                }
                configSpecList.add(deviceSpec);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        if (configSpecList.size() > 0) {
            VirtualMachineConfigSpec config = new VirtualMachineConfigSpec();
            config.deviceChange = new VirtualDeviceConfigSpec[configSpecList.size()];
            for (int i = 0; i < configSpecList.size(); ++i) {
                config.deviceChange[i] = (VirtualDeviceConfigSpec)configSpecList.get(i);
            }
            return this.vm.reconfigVM_Task(config);
        }
        return null;
    }

    public VirtualDevice[] getAllVirtualDevices() {
        VirtualDevice[] devices = (VirtualDevice[])this.vm.getPropertyByPath("config.hardware.device");
        return devices;
    }

    public <T extends VirtualDevice> List<T> getVirtualDevicesOfType(Class<T> clazz) {
        VirtualDevice[] devices;
        ArrayList<VirtualDevice> result = new ArrayList<VirtualDevice>();
        for (VirtualDevice dev : devices = this.getAllVirtualDevices()) {
            if (!clazz.isInstance(dev)) continue;
            result.add(dev);
        }
        return result;
    }

    public VirtualDevice getDeviceByBackingFileName(String name) {
        VirtualDevice[] devices;
        if (name == null) {
            throw new IllegalArgumentException("name must not be null!");
        }
        for (VirtualDevice device : devices = this.getAllVirtualDevices()) {
            String fileName;
            VirtualDeviceBackingInfo bi = device.getBacking();
            if (!(bi instanceof VirtualDeviceFileBackingInfo) || !name.equals(fileName = ((VirtualDeviceFileBackingInfo)bi).getFileName())) continue;
            return device;
        }
        return null;
    }

    private <T extends VirtualController> T getFirstAvailableController(Class<T> clazz) {
        VirtualController vc = this.createControllerInstance(clazz);
        int maxNodes = VirtualMachineDeviceManager.getMaxNodesPerControllerOfType(vc);
        for (VirtualController controller : this.getVirtualDevicesOfType(clazz)) {
            if (controller.device != null && controller.device.length >= maxNodes) continue;
            return (T)controller;
        }
        return null;
    }

    private <T extends VirtualController> VirtualController createControllerInstance(Class<T> clazz) {
        VirtualController vc = null;
        try {
            vc = (VirtualController)clazz.newInstance();
        }
        catch (InstantiationException e) {
            log.error((Object)"Unable to createControllerInstance.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Unable to createControllerInstance.", (Throwable)e);
        }
        return vc;
    }

    private static int getMaxNodesPerControllerOfType(VirtualController controller) {
        int count;
        if (VirtualSCSIController.class.isInstance(controller)) {
            count = 16;
        } else if (VirtualIDEController.class.isInstance(controller)) {
            count = 2;
        } else {
            throw new RuntimeException("Unknown controller type - " + controller.getDeviceInfo().getLabel());
        }
        return count;
    }

    private boolean allSupportHotRemoval(List<VirtualDevice> devices) {
        for (VirtualDevice device : devices) {
            if (!(device instanceof VirtualUSB) && !(device instanceof VirtualDisk)) continue;
            return true;
        }
        return false;
    }

    public static enum VirtualNetworkAdapterType {
        VirtualE1000("VirtualE1000"),
        VirtualE1000E("VirtualE1000e"),
        VirtualPCNet32("VirtualPCNet32"),
        VirtualSriovEthernetCard("VirtualSriovEthernetCard"),
        VirtualVmxnet("VirtualVmxnet"),
        VirtualVmxnet2("VirtualVmxnet2"),
        VirtualVmxnet3("VirtualVmxnet3"),
        Unknown("Unknown");

        private final String val;

        private VirtualNetworkAdapterType(String val) {
            this.val = val;
        }
    }
}

