/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import org.opennms.core.ipc.sink.api.MessageConsumer;
import org.opennms.core.ipc.sink.api.MessageConsumerManager;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.provision.LocationAwareDnsLookupClient;
import org.opennms.netmgt.syslogd.ConvertToEvent;
import org.opennms.netmgt.syslogd.HostNameWithLocationKey;
import org.opennms.netmgt.syslogd.MessageDiscardedException;
import org.opennms.netmgt.syslogd.SyslogSinkModule;
import org.opennms.netmgt.syslogd.api.SyslogConnection;
import org.opennms.netmgt.syslogd.api.SyslogMessageDTO;
import org.opennms.netmgt.syslogd.api.SyslogMessageLogDTO;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class SyslogSinkConsumer
implements MessageConsumer<SyslogConnection, SyslogMessageLogDTO>,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogSinkConsumer.class);
    private static final String defaultCacheConfig = "maximumSize=1000,expireAfterWrite=8h";
    private static final String dnsCacheConfigProperty = "org.opennms.netmgt.syslogd.dnscache.config";
    @Autowired
    private MessageConsumerManager messageConsumerManager;
    @Autowired
    private SyslogdConfig syslogdConfig;
    @Autowired
    private DistPollerDao distPollerDao;
    @Autowired
    private EventForwarder eventForwarder;
    @Autowired
    private LocationAwareDnsLookupClient m_locationAwareDnsLookupClient;
    private Cache<HostNameWithLocationKey, String> dnsCache;
    private final String localAddr;
    private final Timer consumerTimer;
    private final Timer toEventTimer;
    private final Timer broadcastTimer;

    public SyslogSinkConsumer(MetricRegistry registry) {
        this.consumerTimer = registry.timer("consumer");
        this.toEventTimer = registry.timer("consumer.toevent");
        this.broadcastTimer = registry.timer("consumer.broadcast");
        String cacheConfig = System.getProperty(dnsCacheConfigProperty, defaultCacheConfig);
        this.dnsCache = CacheBuilder.from((String)cacheConfig).recordStats().build();
        registry.register("dnsCacheSize", (Metric)((Gauge)() -> this.dnsCache.size()));
        registry.register("dnsCacheHitRate", (Metric)((Gauge)() -> this.dnsCache.stats().hitRate()));
        this.localAddr = InetAddressUtils.getLocalHostName();
    }

    public SyslogSinkModule getModule() {
        return new SyslogSinkModule(this.syslogdConfig, this.distPollerDao);
    }

    public void handleMessage(SyslogMessageLogDTO syslogDTO) {
        try (Timer.Context consumerCtx = this.consumerTimer.time();
             Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"syslogd");){
            Log eventLog;
            try (Timer.Context toEventCtx = this.toEventTimer.time();){
                eventLog = this.toEventLog(syslogDTO);
            }
            try (Timer.Context broadCastCtx = this.broadcastTimer.time();){
                this.broadcast(eventLog);
            }
        }
    }

    public Log toEventLog(SyslogMessageLogDTO messageLog) {
        Log elog = new Log();
        Events events = new Events();
        elog.setEvents(events);
        for (SyslogMessageDTO message : messageLog.getMessages()) {
            try {
                LOG.debug("Converting syslog message into event.");
                ConvertToEvent re = new ConvertToEvent(messageLog.getSystemId(), messageLog.getLocation(), messageLog.getSourceAddress(), messageLog.getSourcePort(), message.getBytes(), message.getTimestamp(), this.syslogdConfig, this.m_locationAwareDnsLookupClient, this.dnsCache);
                events.addEvent(re.getEvent());
            }
            catch (MessageDiscardedException e) {
                LOG.info("Message discarded, returning without enqueueing event.", (Throwable)e);
            }
            catch (Throwable e) {
                LOG.error("Unexpected exception while processing SyslogConnection", e);
            }
        }
        return elog;
    }

    private void broadcast(Log eventLog) {
        if (LOG.isTraceEnabled()) {
            for (Event event : eventLog.getEvents().getEventCollection()) {
                List parms;
                LOG.trace("Processing a syslog to event dispatch", (Object)event.toString());
                String uuid = event.getUuid();
                LOG.trace("Event {");
                LOG.trace("  uuid  = {}", (Object)(uuid != null && uuid.length() > 0 ? uuid : "<not-set>"));
                LOG.trace("  uei   = {}", (Object)event.getUei());
                LOG.trace("  src   = {}", (Object)event.getSource());
                LOG.trace("  iface = {}", (Object)event.getInterface());
                LOG.trace("  time  = {}", (Object)event.getTime());
                LOG.trace("  Msg   = {}", (Object)event.getLogmsg().getContent());
                LOG.trace("  Dst   = {}", (Object)event.getLogmsg().getDest());
                List list = parms = event.getParmCollection() == null ? null : event.getParmCollection();
                if (parms != null) {
                    LOG.trace("  parms {");
                    for (Parm parm : parms) {
                        if (parm.getParmName() == null || parm.getValue().getContent() == null) continue;
                        LOG.trace("    ({}, {})", (Object)parm.getParmName().trim(), (Object)parm.getValue().getContent().trim());
                    }
                    LOG.trace("  }");
                }
                LOG.trace("}");
            }
        }
        this.eventForwarder.sendNowSync(eventLog);
        if (this.syslogdConfig.getNewSuspectOnMessage()) {
            eventLog.getEvents().getEventCollection().stream().filter(e -> !e.hasNodeid()).filter(e -> !Strings.isNullOrEmpty((String)e.getInterface())).forEach(e -> {
                LOG.trace("Syslogd: Found a new suspect {}", (Object)e.getInterface());
                this.sendNewSuspectEvent(this.localAddr, e.getInterface(), e.getDistPoller());
            });
        }
    }

    private void sendNewSuspectEvent(String localAddr, String trapInterface, String distPoller) {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", "syslogd");
        bldr.setInterface(InetAddressUtils.addr((String)trapInterface));
        bldr.setHost(localAddr);
        bldr.setDistPoller(distPoller);
        this.eventForwarder.sendNow(bldr.getEvent());
    }

    public void afterPropertiesSet() throws Exception {
        this.messageConsumerManager.registerConsumer((MessageConsumer)this);
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.eventForwarder = eventForwarder;
    }

    public void setMessageConsumerManager(MessageConsumerManager messageConsumerManager) {
        this.messageConsumerManager = messageConsumerManager;
    }

    public void setSyslogdConfig(SyslogdConfig syslogdConfig) {
        this.syslogdConfig = syslogdConfig;
    }

    public void setDistPollerDao(DistPollerDao distPollerDao) {
        this.distPollerDao = distPollerDao;
    }

    public void setLocationAwareDnsLookupClient(LocationAwareDnsLookupClient locationAwareDnsLookupClient) {
        this.m_locationAwareDnsLookupClient = locationAwareDnsLookupClient;
    }
}

