/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.com.squareup.moshi;

import io.pyroscope.com.squareup.moshi.JsonAdapter;
import io.pyroscope.com.squareup.moshi.JsonReader;
import io.pyroscope.com.squareup.moshi.JsonWriter;
import io.pyroscope.com.squareup.moshi.Moshi;
import io.pyroscope.com.squareup.moshi.RecordJsonAdapter;
import io.pyroscope.com.squareup.moshi.internal.Util;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class RecordJsonAdapter<T>
extends JsonAdapter<T> {
    static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

        @Override
        @Nullable
        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            return null;
        }
    };
    private final String targetClass;
    private final MethodHandle constructor;
    private final ComponentBinding<Object>[] componentBindingsArray;
    private final JsonReader.Options options;

    public RecordJsonAdapter(MethodHandle constructor, String targetClass, Map<String, ComponentBinding<?>> componentBindings) {
        this.constructor = constructor;
        this.targetClass = targetClass;
        this.componentBindingsArray = componentBindings.values().toArray(new ComponentBinding[componentBindings.size()]);
        this.options = JsonReader.Options.of(componentBindings.keySet().toArray(new String[componentBindings.size()]));
    }

    @Override
    public T fromJson(JsonReader reader) throws IOException {
        Object[] resultsArray = new Object[this.componentBindingsArray.length];
        reader.beginObject();
        while (reader.hasNext()) {
            int index = reader.selectName(this.options);
            if (index == -1) {
                reader.skipName();
                reader.skipValue();
                continue;
            }
            resultsArray[index] = this.componentBindingsArray[index].adapter.fromJson(reader);
        }
        reader.endObject();
        try {
            return (T)this.constructor.invokeWithArguments(resultsArray);
        }
        catch (InvocationTargetException e) {
            throw Util.rethrowCause(e);
        }
        catch (Throwable e) {
            int limit = this.componentBindingsArray.length;
            for (int i = 0; i < limit; ++i) {
                if (resultsArray[i] != null || !((Class)this.componentBindingsArray[i].accessor.type().returnType()).isPrimitive()) continue;
                throw Util.missingProperty(this.componentBindingsArray[i].componentName, this.componentBindingsArray[i].jsonName, reader);
            }
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void toJson(JsonWriter writer, T value) throws IOException {
        writer.beginObject();
        for (ComponentBinding binding : this.componentBindingsArray) {
            Object componentValue;
            writer.name(binding.jsonName);
            try {
                componentValue = binding.accessor.invoke(value);
            }
            catch (InvocationTargetException e) {
                throw Util.rethrowCause(e);
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
            binding.adapter.toJson(writer, componentValue);
        }
        writer.endObject();
    }

    public String toString() {
        return "JsonAdapter(" + this.targetClass + ")";
    }
}

