/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core.registry;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventProcessor;
import io.github.resilience4j.core.Registry;
import io.github.resilience4j.core.registry.EntryAddedEvent;
import io.github.resilience4j.core.registry.EntryRemovedEvent;
import io.github.resilience4j.core.registry.EntryReplacedEvent;
import io.github.resilience4j.core.registry.RegistryEvent;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public class AbstractRegistry<E, C>
implements Registry<E, C> {
    protected static final String DEFAULT_CONFIG = "default";
    private static final String NAME_MUST_NOT_BE_NULL = "Name must not be null";
    protected static final String CONFIG_MUST_NOT_BE_NULL = "Config must not be null";
    protected static final String SUPPLIER_MUST_NOT_BE_NULL = "Supplier must not be null";
    protected final ConcurrentMap<String, E> entryMap;
    protected final ConcurrentMap<String, C> configurations = new ConcurrentHashMap<String, C>();
    private final RegistryEventProcessor eventProcessor;

    public AbstractRegistry(C defaultConfig) {
        this.entryMap = new ConcurrentHashMap<String, E>();
        this.eventProcessor = new RegistryEventProcessor();
        this.configurations.put(DEFAULT_CONFIG, Objects.requireNonNull(defaultConfig, CONFIG_MUST_NOT_BE_NULL));
    }

    protected E computeIfAbsent(String name, Supplier<E> supplier) {
        return (E)this.entryMap.computeIfAbsent(Objects.requireNonNull(name, NAME_MUST_NOT_BE_NULL), (? super K k) -> {
            Object entry = supplier.get();
            this.eventProcessor.processEvent(new EntryAddedEvent(entry));
            return entry;
        });
    }

    @Override
    public Optional<E> find(String name) {
        return Optional.ofNullable(this.entryMap.get(name));
    }

    @Override
    public Optional<E> remove(String name) {
        Optional removedEntry = Optional.ofNullable(this.entryMap.remove(name));
        removedEntry.ifPresent(entry -> this.eventProcessor.processEvent(new EntryRemovedEvent<Object>(entry)));
        return removedEntry;
    }

    @Override
    public Optional<E> replace(String name, E newEntry) {
        Optional<E> replacedEntry = Optional.ofNullable(this.entryMap.replace(name, newEntry));
        replacedEntry.ifPresent(oldEntry -> this.eventProcessor.processEvent(new EntryReplacedEvent<Object>(oldEntry, newEntry)));
        return replacedEntry;
    }

    @Override
    public void addConfiguration(String configName, C configuration) {
        if (configName.equals(DEFAULT_CONFIG)) {
            throw new IllegalArgumentException("You cannot use 'default' as a configuration name as it is preserved for default configuration");
        }
        this.configurations.put(configName, configuration);
    }

    @Override
    public Optional<C> getConfiguration(String configName) {
        return Optional.ofNullable(this.configurations.get(configName));
    }

    @Override
    public C getDefaultConfig() {
        return (C)this.configurations.get(DEFAULT_CONFIG);
    }

    @Override
    public Registry.EventPublisher<E> getEventPublisher() {
        return this.eventProcessor;
    }

    private class RegistryEventProcessor
    extends EventProcessor<RegistryEvent>
    implements EventConsumer<RegistryEvent>,
    Registry.EventPublisher<E> {
        private RegistryEventProcessor() {
        }

        @Override
        public Registry.EventPublisher<E> onEntryAdded(EventConsumer<EntryAddedEvent<E>> onSuccessEventConsumer) {
            this.registerConsumer(EntryAddedEvent.class.getSimpleName(), onSuccessEventConsumer);
            return this;
        }

        @Override
        public Registry.EventPublisher<E> onEntryRemoved(EventConsumer<EntryRemovedEvent<E>> onErrorEventConsumer) {
            this.registerConsumer(EntryRemovedEvent.class.getSimpleName(), onErrorEventConsumer);
            return this;
        }

        @Override
        public Registry.EventPublisher<E> onEntryReplaced(EventConsumer<EntryReplacedEvent<E>> onStateTransitionEventConsumer) {
            this.registerConsumer(EntryReplacedEvent.class.getSimpleName(), onStateTransitionEventConsumer);
            return this;
        }

        @Override
        public void consumeEvent(RegistryEvent event) {
            super.processEvent(event);
        }
    }
}

