/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.drools;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import java.io.File;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.hibernate.Hibernate;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.SessionFactory;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.alarmd.api.AlarmCallbackStateTracker;
import org.opennms.netmgt.alarmd.api.AlarmLifecycleListener;
import org.opennms.netmgt.alarmd.drools.AlarmAcknowledgementAndFact;
import org.opennms.netmgt.alarmd.drools.AlarmAndFact;
import org.opennms.netmgt.alarmd.drools.AlarmAssociationAndFact;
import org.opennms.netmgt.alarmd.drools.AlarmService;
import org.opennms.netmgt.alarmd.drools.AlarmTicketerService;
import org.opennms.netmgt.alarmd.drools.ManagedDroolsContext;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.AlarmAssociation;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public class DroolsAlarmContext
extends ManagedDroolsContext
implements AlarmLifecycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(DroolsAlarmContext.class);
    private static final RateLimitedLog RATE_LIMITED_LOGGER = RateLimitedLog.withRateLimit((Logger)LOG).maxRate(5).every(Duration.ofSeconds(30L)).build();
    private static final long MAX_NUM_ACTIONS_IN_FLIGHT = SystemProperties.getLong((String)"org.opennms.netmgt.alarmd.drools.max_num_actions_in_flight", (int)5000);
    @Autowired
    private AlarmService alarmService;
    @Autowired
    private AcknowledgmentDao acknowledgmentDao;
    @Autowired
    private AlarmTicketerService alarmTicketerService;
    @Autowired
    private TransactionTemplate template;
    @Autowired
    private AlarmDao alarmDao;
    @Autowired
    private SessionFactory sessionFactory;
    private final AlarmCallbackStateTracker stateTracker = new AlarmCallbackStateTracker();
    private final Map<Integer, AlarmAndFact> alarmsById = new HashMap<Integer, AlarmAndFact>();
    private final Map<Integer, AlarmAcknowledgementAndFact> acknowledgementsByAlarmId = new HashMap<Integer, AlarmAcknowledgementAndFact>();
    private final Map<Integer, Map<Integer, AlarmAssociationAndFact>> alarmAssociationById = new HashMap<Integer, Map<Integer, AlarmAssociationAndFact>>();
    private final CountDownLatch seedSubmittedLatch = new CountDownLatch(1);
    private final AtomicLong atomicActionsInFlight = new AtomicLong(-1L);
    private final AtomicLong numAlarmsFromLastSnapshot = new AtomicLong(-1L);
    private final AtomicLong numSituationsFromLastSnapshot = new AtomicLong(-1L);
    private final Meter atomicActionsDropped = new Meter();
    private final Meter atomicActionsQueued = new Meter();

    public DroolsAlarmContext() {
        this(DroolsAlarmContext.getDefaultRulesFolder());
    }

    public DroolsAlarmContext(File rulesFolder) {
        super(rulesFolder, "alarmd", "DroolsAlarmContext");
        this.setOnNewKiewSessionCallback(kieSession -> {
            kieSession.setGlobal("alarmService", (Object)this.alarmService);
            kieSession.insert((Object)this.alarmTicketerService);
            this.alarmsById.clear();
            this.acknowledgementsByAlarmId.clear();
            this.alarmAssociationById.clear();
            for (FactHandle fact : kieSession.getFactHandles()) {
                Object objForFact = kieSession.getObject(fact);
                if (objForFact instanceof OnmsAlarm) {
                    OnmsAlarm alarmInSession = (OnmsAlarm)objForFact;
                    this.alarmsById.put(alarmInSession.getId(), new AlarmAndFact(alarmInSession, fact));
                    continue;
                }
                if (objForFact instanceof OnmsAcknowledgment) {
                    OnmsAcknowledgment ackInSession = (OnmsAcknowledgment)objForFact;
                    this.acknowledgementsByAlarmId.put(ackInSession.getRefId(), new AlarmAcknowledgementAndFact(ackInSession, fact));
                    continue;
                }
                if (!(objForFact instanceof AlarmAssociation)) continue;
                AlarmAssociation associationInSession = (AlarmAssociation)objForFact;
                Integer situationId = associationInSession.getSituationAlarm().getId();
                Integer alarmId = associationInSession.getRelatedAlarm().getId();
                Map associationFacts = this.alarmAssociationById.computeIfAbsent(situationId, sid -> new HashMap());
                associationFacts.put(alarmId, new AlarmAssociationAndFact(associationInSession, fact));
            }
            this.atomicActionsInFlight.set(0L);
            this.numAlarmsFromLastSnapshot.set(-1L);
            this.numSituationsFromLastSnapshot.set(-1L);
        });
        this.getMetrics().register("atomicActionsInFlight", (Metric)((Gauge)this.atomicActionsInFlight::get));
        this.getMetrics().register("numAlarmsFromLastSnapshot", (Metric)((Gauge)this.numAlarmsFromLastSnapshot::get));
        this.getMetrics().register("numSituationsFromLastSnapshot", (Metric)((Gauge)this.numSituationsFromLastSnapshot::get));
        this.getMetrics().register("atomicActionsDropped", (Metric)this.atomicActionsDropped);
        this.getMetrics().register("atomicActionsQueued", (Metric)this.atomicActionsQueued);
    }

    public static File getDefaultRulesFolder() {
        return Paths.get(ConfigFileConstants.getHome(), "etc", "alarmd", "drools-rules.d").toFile();
    }

    @Override
    public void onStart() {
        Thread seedThread = new Thread(() -> {
            try {
                this.preHandleAlarmSnapshot();
                this.template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        LOG.info("Loading all alarms to seed Drools context.");
                        List allAlarms = DroolsAlarmContext.this.alarmDao.findAll();
                        LOG.info("Done loading {} alarms.", (Object)allAlarms.size());
                        DroolsAlarmContext.this.handleAlarmSnapshot(allAlarms);
                        DroolsAlarmContext.this.seedSubmittedLatch.countDown();
                    }
                });
            }
            finally {
                this.postHandleAlarmSnapshot();
            }
        });
        seedThread.setName("DroolAlarmContext-InitialSeed");
        seedThread.start();
    }

    public void preHandleAlarmSnapshot() {
        this.stateTracker.startTrackingAlarms();
    }

    private void executeAtomicallyWhenTransactionComplete(final KieSession.AtomicAction atomicAction) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCompletion(int status) {
                    if (status != 0) {
                        RATE_LIMITED_LOGGER.warn("A database transaction did not complete successfully. The alarms facts in the session may be out of sync until the next snapshot.");
                        return;
                    }
                    DroolsAlarmContext.this.submitOrRun(atomicAction);
                }
            });
        } else {
            this.submitOrRun(atomicAction);
        }
    }

    private void submitOrRun(KieSession.AtomicAction atomicAction) {
        if (this.fireThreadId.get() == Thread.currentThread().getId()) {
            atomicAction.execute(this.getKieSession());
        } else {
            long numActionsInFlight = this.atomicActionsInFlight.incrementAndGet();
            if (numActionsInFlight > MAX_NUM_ACTIONS_IN_FLIGHT) {
                RATE_LIMITED_LOGGER.error("Dropping action - number of actions in flight exceed {}! Alarms in Drools context will not match those in the database until the next successful sync.", (Object)MAX_NUM_ACTIONS_IN_FLIGHT);
                this.atomicActionsDropped.mark();
                this.atomicActionsInFlight.decrementAndGet();
                return;
            }
            this.getKieSession().submit(kieSession -> {
                atomicAction.execute(kieSession);
                this.atomicActionsInFlight.decrementAndGet();
            });
            this.atomicActionsQueued.mark();
        }
    }

    public void handleAlarmSnapshot(List<OnmsAlarm> alarms) {
        if (!this.isStarted()) {
            LOG.debug("Ignoring alarm snapshot. Drools session is stopped.");
            return;
        }
        LOG.debug("Handling snapshot for {} alarms.", (Object)alarms.size());
        Map<Integer, OnmsAlarm> alarmsInDbById = alarms.stream().filter(a -> a.getId() != null).collect(Collectors.toMap(OnmsAlarm::getId, a -> a));
        for (OnmsAlarm alarm : alarms) {
            this.eagerlyInitializeAlarm(alarm);
        }
        Map<Integer, OnmsAcknowledgment> acksByRefId = this.fetchAcks(alarms);
        long numSituations = alarms.stream().filter(OnmsAlarm::isSituation).count();
        this.numAlarmsFromLastSnapshot.set((long)alarms.size() - numSituations);
        this.numSituationsFromLastSnapshot.set(numSituations);
        this.submitOrRun(kieSession -> {
            Set alarmIdsInDb = alarmsInDbById.keySet();
            Set<Integer> alarmIdsInWorkingMem = this.alarmsById.keySet();
            Set alarmIdsToAdd = Sets.difference(alarmIdsInDb, alarmIdsInWorkingMem).stream().filter(alarmId -> !this.stateTracker.wasAlarmWithIdDeleted(alarmId.intValue())).collect(Collectors.toSet());
            Set alarmIdsToRemove = Sets.difference(alarmIdsInWorkingMem, alarmIdsInDb).stream().filter(alarmId -> !this.stateTracker.wasAlarmWithIdUpdated(alarmId.intValue())).collect(Collectors.toSet());
            Set alarmIdsToUpdate = Sets.intersection(alarmIdsInWorkingMem, alarmIdsInDb).stream().filter(alarmId -> {
                AlarmAndFact alarmAndFact = this.alarmsById.get(alarmId);
                if (this.stateTracker.wasAlarmWithIdUpdated(alarmId.intValue())) {
                    return false;
                }
                OnmsAlarm alarmInMem = alarmAndFact.getAlarm();
                OnmsAlarm alarmInDb = (OnmsAlarm)alarmsInDbById.get(alarmId);
                return DroolsAlarmContext.shouldUpdateAlarmForSnapshot(alarmInMem, alarmInDb);
            }).collect(Collectors.toSet());
            if (LOG.isDebugEnabled()) {
                if (!(alarmIdsToAdd.isEmpty() && alarmIdsToRemove.isEmpty() && alarmIdsToUpdate.isEmpty())) {
                    LOG.debug("Adding {} alarms, removing {} alarms and updating {} alarms for snapshot.", new Object[]{alarmIdsToAdd.size(), alarmIdsToRemove.size(), alarmIdsToUpdate.size()});
                } else {
                    LOG.debug("No actions to perform for alarm snapshot.");
                }
                if (LOG.isTraceEnabled()) {
                    for (Integer alarmIdToUpdate : alarmIdsToUpdate) {
                        LOG.trace("Updating alarm with id={}. Alarm from DB: {} vs Alarm from memory: {}", new Object[]{alarmIdToUpdate, alarmsInDbById.get(alarmIdToUpdate), this.alarmsById.get(alarmIdToUpdate)});
                    }
                }
            }
            for (Integer alarmIdToRemove : alarmIdsToRemove) {
                this.handleDeletedAlarmForAtomic(kieSession, alarmIdToRemove, this.alarmsById.get(alarmIdToRemove).getAlarm().getReductionKey());
            }
            Set alarmsToUpdate = Sets.union(alarmIdsToAdd, alarmIdsToUpdate).stream().map(alarmsInDbById::get).collect(Collectors.toSet());
            for (OnmsAlarm alarm : alarmsToUpdate) {
                this.handleNewOrUpdatedAlarmForAtomic(kieSession, alarm, (OnmsAcknowledgment)acksByRefId.get(alarm.getId()));
            }
            this.stateTracker.resetStateAndStopTrackingAlarms();
            LOG.debug("Done handling snapshot.");
        });
    }

    public void postHandleAlarmSnapshot() {
    }

    protected static boolean shouldUpdateAlarmForSnapshot(OnmsAlarm alarmInMem, OnmsAlarm alarmInDb) {
        return !Objects.equals(alarmInMem.getLastEventTime(), alarmInDb.getLastEventTime()) || !Objects.equals(alarmInMem.getAckTime(), alarmInDb.getAckTime());
    }

    public void handleNewOrUpdatedAlarm(OnmsAlarm alarm) {
        if (!this.isStarted()) {
            LOG.debug("Ignoring new/updated alarm. Drools session is stopped.");
            return;
        }
        this.eagerlyInitializeAlarm(alarm);
        Map<Integer, OnmsAcknowledgment> acksByRefId = this.fetchAcks(Collections.singletonList(alarm));
        this.executeAtomicallyWhenTransactionComplete(kieSession -> {
            this.handleNewOrUpdatedAlarmForAtomic(kieSession, alarm, (OnmsAcknowledgment)acksByRefId.get(alarm.getId()));
            this.stateTracker.trackNewOrUpdatedAlarm(alarm.getId().intValue(), alarm.getReductionKey());
        });
    }

    private Map<Integer, OnmsAcknowledgment> fetchAcks(Collection<OnmsAlarm> alarms) {
        if (alarms.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet acks = new HashSet();
        if (alarms.size() == 1) {
            this.acknowledgmentDao.findLatestAckForRefId(alarms.iterator().next().getId()).ifPresent(acks::add);
        } else {
            Date earliestAlarm = alarms.stream().map(OnmsAlarm::getFirstEventTime).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElseGet(() -> {
                LocalDateTime oneMonthAgoLdt = LocalDateTime.now().minusMonths(1L);
                Date oneMonthAgo = Date.from(oneMonthAgoLdt.atZone(ZoneId.systemDefault()).toInstant());
                LOG.error("Could not find minimum alarm creation time for alarms: {}. Using: {}", (Object)alarms, (Object)oneMonthAgo);
                return oneMonthAgo;
            });
            acks.addAll(this.acknowledgmentDao.findLatestAcks(earliestAlarm));
        }
        Map<Integer, OnmsAcknowledgment> acksById = acks.stream().collect(Collectors.toMap(OnmsAcknowledgment::getRefId, ack -> ack));
        acksById.putAll(alarms.stream().filter(alarm -> !acksById.containsKey(alarm.getId())).collect(Collectors.toMap(OnmsAlarm::getId, alarm -> {
            OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)alarm, "admin", alarm.getFirstEventTime());
            ack.setAckAction(AckAction.UNACKNOWLEDGE);
            ack.setId(Integer.valueOf(0));
            return ack;
        })));
        return acksById;
    }

    private void eagerlyInitializeAlarm(OnmsAlarm alarm) {
        Hibernate.initialize((Object)alarm.getAssociatedAlarms());
        if (alarm.getLastEvent() != null) {
            try {
                Hibernate.initialize((Object)alarm.getLastEvent().getEventParameters());
            }
            catch (ObjectNotFoundException ex) {
                alarm.setLastEvent(null);
            }
        }
        if (alarm.getNode() != null) {
            Hibernate.initialize((Object)alarm.getNode().getCategories());
            Hibernate.initialize((Object)alarm.getNode().getMetaData());
            this.sessionFactory.getCurrentSession().setReadOnly((Object)alarm.getNode(), true);
        }
    }

    private void handleNewOrUpdatedAlarmForAtomic(KieSession kieSession, OnmsAlarm alarm, OnmsAcknowledgment ack) {
        AlarmAndFact alarmAndFact = this.alarmsById.get(alarm.getId());
        if (alarmAndFact == null) {
            LOG.debug("Inserting alarm into session: {}", (Object)alarm);
            fact = kieSession.insert((Object)alarm);
            this.alarmsById.put(alarm.getId(), new AlarmAndFact(alarm, fact));
        } else {
            LOG.trace("Deleting alarm from session (for re-insertion): {}", (Object)alarm);
            kieSession.delete(alarmAndFact.getFact());
            LOG.trace("Re-inserting alarm into session: {}", (Object)alarm);
            fact = kieSession.insert((Object)alarm);
            this.alarmsById.put(alarm.getId(), new AlarmAndFact(alarm, fact));
        }
        AlarmAcknowledgementAndFact acknowledgmentFact = this.acknowledgementsByAlarmId.get(alarm.getId());
        if (acknowledgmentFact == null) {
            LOG.debug("Inserting first alarm acknowledgement into session: {}", (Object)ack);
            fact = kieSession.insert((Object)ack);
            this.acknowledgementsByAlarmId.put(alarm.getId(), new AlarmAcknowledgementAndFact(ack, fact));
        } else {
            fact = acknowledgmentFact.getFact();
            LOG.trace("Updating acknowledgment in session: {}", (Object)ack);
            kieSession.update(fact, (Object)ack);
            this.acknowledgementsByAlarmId.put(alarm.getId(), new AlarmAcknowledgementAndFact(ack, fact));
        }
        if (alarm.isSituation()) {
            OnmsAlarm situation = alarm;
            Map associationFacts = this.alarmAssociationById.computeIfAbsent(situation.getId(), sid -> new HashMap());
            for (AlarmAssociation association : situation.getAssociatedAlarms()) {
                FactHandle fact2;
                Integer alarmId2 = association.getRelatedAlarm().getId();
                AlarmAssociationAndFact associationFact = (AlarmAssociationAndFact)associationFacts.get(alarmId2);
                if (associationFact == null) {
                    LOG.debug("Inserting alarm association into session: {}", (Object)association);
                    fact2 = kieSession.insert((Object)association);
                    associationFacts.put(alarmId2, new AlarmAssociationAndFact(association, fact2));
                    continue;
                }
                fact2 = associationFact.getFact();
                LOG.trace("Updating alarm association in session: {}", (Object)associationFact);
                kieSession.update(fact2, (Object)association);
                associationFacts.put(alarmId2, new AlarmAssociationAndFact(association, fact2));
            }
            Set<Integer> deletedAlarmIds = associationFacts.values().stream().map(fact -> fact.getAlarmAssociation().getRelatedAlarm().getId()).filter(alarmId -> !situation.getRelatedAlarmIds().contains(alarmId)).collect(Collectors.toSet());
            deletedAlarmIds.forEach(alarmId -> {
                AlarmAssociationAndFact associationAndFact = (AlarmAssociationAndFact)associationFacts.remove(alarmId);
                if (associationAndFact != null) {
                    LOG.debug("Deleting AlarmAssociationAndFact from session: {}", (Object)associationAndFact.getAlarmAssociation());
                    kieSession.delete(associationAndFact.getFact());
                }
            });
        }
    }

    public void handleDeletedAlarm(int alarmId, String reductionKey) {
        if (!this.isStarted()) {
            LOG.debug("Ignoring deleted alarm. Drools session is stopped.");
            return;
        }
        this.executeAtomicallyWhenTransactionComplete(kieSession -> {
            this.handleDeletedAlarmForAtomic(kieSession, alarmId, reductionKey);
            this.stateTracker.trackDeletedAlarm(alarmId, reductionKey);
        });
    }

    private void handleDeletedAlarmForAtomic(KieSession kieSession, int alarmId, String reductionKey) {
        Map<Integer, AlarmAssociationAndFact> associationFacts;
        AlarmAcknowledgementAndFact acknowledgmentFact;
        AlarmAndFact alarmAndFact = this.alarmsById.remove(alarmId);
        if (alarmAndFact != null) {
            LOG.debug("Deleting alarm from session: {}", (Object)alarmAndFact.getAlarm());
            kieSession.delete(alarmAndFact.getFact());
        }
        if ((acknowledgmentFact = this.acknowledgementsByAlarmId.remove(alarmId)) != null) {
            LOG.debug("Deleting ack from session: {}", (Object)acknowledgmentFact.getAcknowledgement());
            kieSession.delete(acknowledgmentFact.getFact());
        }
        if ((associationFacts = this.alarmAssociationById.remove(alarmId)) == null) {
            return;
        }
        for (Integer association : associationFacts.keySet()) {
            AlarmAssociationAndFact associationFact = associationFacts.get(association);
            if (associationFact == null) continue;
            LOG.debug("Deleting association from session: {}", (Object)associationFact.getAlarmAssociation());
            kieSession.delete(associationFact.getFact());
        }
    }

    public void setAlarmService(AlarmService alarmService) {
        this.alarmService = alarmService;
    }

    public void setAcknowledgmentDao(AcknowledgmentDao acknowledgmentDao) {
        this.acknowledgmentDao = acknowledgmentDao;
    }

    public void setAlarmTicketerService(AlarmTicketerService alarmTicketerService) {
        this.alarmTicketerService = alarmTicketerService;
    }

    @VisibleForTesting
    OnmsAcknowledgment getAckByAlarmId(Integer id) {
        return this.acknowledgementsByAlarmId.get(id).getAcknowledgement();
    }

    @VisibleForTesting
    public void waitForInitialSeedToBeSubmitted() throws InterruptedException {
        this.seedSubmittedLatch.await();
    }

    public void setTransactionTemplate(TransactionTemplate template) {
        this.template = template;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.alarmDao = alarmDao;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

