/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter.spog;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.opennms.core.utils.SystemInfoUtils;
import org.opennms.features.grpc.exporter.NamedThreadFactory;
import org.opennms.features.grpc.exporter.mapper.NmsInventoryMapper;
import org.opennms.features.grpc.exporter.spog.SpogGrpcClient;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.plugin.grpc.proto.spog.HeartBeat;
import org.opennms.plugin.grpc.proto.spog.MonitoringInstance;
import org.opennms.plugin.grpc.proto.spog.NmsInventoryUpdateList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpogInventoryService {
    private static final Logger LOG = LoggerFactory.getLogger(SpogInventoryService.class);
    private final NodeDao nodeDao;
    private final RuntimeInfo runtimeInfo;
    private final SpogGrpcClient client;
    private final Duration snapshotInterval;
    private final ScheduledExecutorService scheduler;
    private final SessionUtils sessionUtils;
    private final boolean inventoryExportEnabled;
    private final ScheduledExecutorService heartBeatScheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("spog-heartbeat-update"));

    public SpogInventoryService(NodeDao nodeDao, RuntimeInfo runtimeInfo, SpogGrpcClient client, SessionUtils sessionUtils, long snapshotInterval, boolean inventoryExportEnabled) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.runtimeInfo = Objects.requireNonNull(runtimeInfo);
        this.client = Objects.requireNonNull(client);
        this.snapshotInterval = Duration.ofSeconds(snapshotInterval);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
        this.inventoryExportEnabled = inventoryExportEnabled;
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("nms-inventory-service-snapshot-sender"));
    }

    public void start() {
        this.scheduler.scheduleAtFixedRate(this::sendSnapshot, this.snapshotInterval.getSeconds(), this.snapshotInterval.getSeconds(), TimeUnit.SECONDS);
        this.heartBeatScheduler.scheduleAtFixedRate(this::sendHeartBeatUpdate, 60L, 60L, TimeUnit.SECONDS);
        this.client.setInventoryCallback(this::sendSnapshot);
    }

    public void stop() {
        this.scheduler.shutdown();
    }

    public void sendAddNmsInventory(Long nodeId) {
        if (!this.client.isEnabled()) {
            LOG.info("SPOG service disabled, not sending inventory updates");
            return;
        }
        if (!this.inventoryExportEnabled) {
            LOG.info("SPOG Inventory Export disabled, not sending inventory updates");
            return;
        }
        Long nodeIdToSend = nodeId;
        this.sessionUtils.withReadOnlyTransaction(() -> {
            OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(nodeIdToSend.intValue()));
            NmsInventoryUpdateList inventory = NmsInventoryMapper.INSTANCE.toInventoryUpdatesList(List.of(node), this.runtimeInfo, SystemInfoUtils.getInstanceId(), false);
            this.client.sendNmsInventoryUpdate(inventory);
        });
    }

    public void sendSnapshot() {
        if (!this.client.isEnabled()) {
            LOG.info("SPOG service disabled, not sending inventory snapshot");
            return;
        }
        if (!this.inventoryExportEnabled) {
            LOG.info("SPOG : Inventory Export disabled, not sending inventory snapshot");
            return;
        }
        this.sessionUtils.withReadOnlyTransaction(() -> {
            List nodes = this.nodeDao.findAll();
            NmsInventoryUpdateList inventory = NmsInventoryMapper.INSTANCE.toInventoryUpdates(nodes, this.runtimeInfo, SystemInfoUtils.getInstanceId(), true);
            this.client.sendNmsInventoryUpdate(inventory);
        });
    }

    public void sendHeartBeatUpdate() {
        if (!this.client.isEnabled()) {
            LOG.info("SPOG service disabled, not sending heartbeat updates");
            return;
        }
        this.client.sendHeartBeatUpdate(HeartBeat.newBuilder().setMonitoringInstance(MonitoringInstance.newBuilder().setInstanceId(this.runtimeInfo.getSystemId()).setInstanceName(SystemInfoUtils.getInstanceId()).setInstanceType("OpenNMS").build()).setTimestamp(Instant.now().toEpochMilli()).setMessage("HeartBeat Update from OpenNMS").build());
    }
}

