/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter.bsm;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opennms.core.utils.SystemInfoUtils;
import org.opennms.features.grpc.exporter.NamedThreadFactory;
import org.opennms.features.grpc.exporter.bsm.BsmGrpcClient;
import org.opennms.features.grpc.exporter.mapper.MonitoredServiceMapper;
import org.opennms.features.grpc.exporter.mapper.MonitoredServiceWithMetadata;
import org.opennms.integration.api.v1.dao.NodeDao;
import org.opennms.integration.api.v1.model.IpInterface;
import org.opennms.integration.api.v1.model.MonitoredService;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.opennms.plugin.grpc.proto.services.HeartBeat;
import org.opennms.plugin.grpc.proto.services.InventoryUpdateList;
import org.opennms.plugin.grpc.proto.services.MonitoringInstance;
import org.opennms.plugin.grpc.proto.services.StateUpdateList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BsmInventoryService {
    private static final Logger LOG = LoggerFactory.getLogger(BsmInventoryService.class);
    private final NodeDao nodeDao;
    private final RuntimeInfo runtimeInfo;
    private final BsmGrpcClient client;
    private final Duration snapshotInterval;
    private final ScheduledExecutorService scheduler;
    private final ScheduledExecutorService heartBeatScheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("bsm-heartbeat-update"));

    public BsmInventoryService(NodeDao nodeDao, RuntimeInfo runtimeInfo, BsmGrpcClient client, Duration snapshotInterval) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.runtimeInfo = Objects.requireNonNull(runtimeInfo);
        this.client = Objects.requireNonNull(client);
        this.snapshotInterval = Objects.requireNonNull(snapshotInterval);
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("inventory-service-snapshot-sender"));
    }

    public BsmInventoryService(NodeDao nodeDao, RuntimeInfo runtimeInfo, BsmGrpcClient client, long snapshotInterval) {
        this(nodeDao, runtimeInfo, client, Duration.ofSeconds(snapshotInterval));
    }

    public void start() {
        this.scheduler.scheduleAtFixedRate(this::sendSnapshot, this.snapshotInterval.getSeconds(), this.snapshotInterval.getSeconds(), TimeUnit.SECONDS);
        this.heartBeatScheduler.scheduleAtFixedRate(this::sendHeartBeatUpdate, 60L, 60L, TimeUnit.SECONDS);
        this.client.setInventoryCallback(this::sendSnapshot);
    }

    public void stop() {
        this.scheduler.shutdown();
    }

    public void sendAddService(MonitoredServiceWithMetadata service) {
        if (!this.client.isEnabled()) {
            LOG.debug("BSM service disabled, not sending updates");
            return;
        }
        InventoryUpdateList inventory = MonitoredServiceMapper.INSTANCE.toInventoryUpdates(List.of(service), this.runtimeInfo, false);
        this.client.sendMonitoredServicesInventoryUpdate(inventory);
    }

    public void sendSnapshot() {
        if (!this.client.isEnabled()) {
            LOG.debug("BSM service disabled, not sending snapshot");
            return;
        }
        List<MonitoredServiceWithMetadata> services = this.nodeDao.getNodes().stream().flatMap(node -> node.getIpInterfaces().stream().flatMap(iface -> iface.getMonitoredServices().stream().map(service -> new MonitoredServiceWithMetadata((Node)node, (IpInterface)iface, (MonitoredService)service)))).collect(Collectors.toList());
        LOG.debug("Send BSM snapshot: services={}", (Object)services.size());
        InventoryUpdateList inventory = MonitoredServiceMapper.INSTANCE.toInventoryUpdates(services, this.runtimeInfo, true);
        this.client.sendMonitoredServicesInventoryUpdate(inventory);
    }

    public void sendHeartBeatUpdate() {
        if (!this.client.isEnabled()) {
            LOG.debug("BSM service disabled, not sending heartbeat");
            return;
        }
        this.client.sendHeartBeatUpdate(HeartBeat.newBuilder().setMonitoringInstance(MonitoringInstance.newBuilder().setInstanceId(this.runtimeInfo.getSystemId()).setInstanceName(SystemInfoUtils.getInstanceId()).setInstanceType("OpenNMS").build()).setTimestamp(Instant.now().toEpochMilli()).setMessage("HeartBeat Update from OpenNMS").build());
    }

    public void sendState(List<MonitoredServiceWithMetadata> services) {
        if (!this.client.isEnabled()) {
            LOG.debug("BSM service disabled, not sending state updates");
            return;
        }
        StateUpdateList updates = MonitoredServiceMapper.INSTANCE.toStateUpdates(services, this.runtimeInfo);
        this.client.sendMonitoredServicesStatusUpdate(updates);
    }

    public void sendAllState() {
        if (!this.client.isEnabled()) {
            LOG.debug("BSM service disabled, not sending all state");
            return;
        }
        List<MonitoredServiceWithMetadata> services = this.nodeDao.getNodes().stream().flatMap(node -> node.getIpInterfaces().stream().flatMap(iface -> iface.getMonitoredServices().stream().map(service -> new MonitoredServiceWithMetadata((Node)node, (IpInterface)iface, (MonitoredService)service)))).collect(Collectors.toList());
        this.sendState(services);
    }
}

