/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.poller.ServiceMonitorRegistry;

public class DefaultServiceMonitorLocator
implements ServiceMonitorLocator,
Serializable {
    String m_serviceName;
    String m_serviceClass;

    public DefaultServiceMonitorLocator(String serviceName, String serviceClass) {
        this.m_serviceName = serviceName;
        this.m_serviceClass = serviceClass;
    }

    public ServiceMonitor getServiceMonitor(ServiceMonitorRegistry registry) {
        return registry.getMonitorByClassName(this.m_serviceClass);
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public String getServiceLocatorKey() {
        return this.m_serviceClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultServiceMonitorLocator)) {
            return false;
        }
        DefaultServiceMonitorLocator that = (DefaultServiceMonitorLocator)o;
        return Objects.equals(this.m_serviceName, that.m_serviceName) && Objects.equals(this.m_serviceClass, that.m_serviceClass);
    }

    public int hashCode() {
        return Objects.hash(this.m_serviceName, this.m_serviceClass);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serviceName", (Object)this.m_serviceName).add("serviceClass", (Object)this.m_serviceClass).toString();
    }
}

