<%--

    Licensed to The OpenNMS Group, Inc (TOG) under one or more
    contributor license agreements.  See the LICENSE.md file
    distributed with this work for additional information
    regarding copyright ownership.

    TOG licenses this file to You under the GNU Affero General
    Public License Version 3 (the "License") or (at your option)
    any later version.  You may not use this file except in
    compliance with the License.  You may obtain a copy of the
    License at:

         https://www.gnu.org/licenses/agpl-3.0.txt

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
    either express or implied.  See the License for the specific
    language governing permissions and limitations under the
    License.

--%>
<%@page language="java"
	contentType="text/html"
	session="true"
%>

<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>


<%@ page import="org.opennms.web.utils.Bootstrap" %>
<% Bootstrap.with(pageContext)
          .headTitle("${role.name}")
          .headTitle("Roles")
          .breadcrumb("Role List", "roles")
          .breadcrumb("${role.name}")
          .build(request);
%>
<jsp:directive.include file="/includes/bootstrap.jsp" />


<script type="text/javascript" >

	function changeDisplay() {
		document.displayForm.submit();
	}
	
	function prevMonth() {
		document.prevMonthForm.submit();
	}
	
	function nextMonth() {
		document.nextMonthForm.submit();
	}
	
	function addEntry(date) {
		document.addEntryForm.date.value = date;
		document.addEntryForm.submit();
		
	}
	
	function editEntry(schedIndex, timeIndex) {
		document.editEntryForm.schedIndex.value = schedIndex;
		document.editEntryForm.timeIndex.value = timeIndex;
		document.editEntryForm.submit();
	}

</script>

<div class="card">
	<div class="card-header">
		<span>
			<c:out value="${role.name}" />
		</span>
	</div>

	<table class="table table-sm severity">
		<tr class="d-flex">
			<th class="col-md-2">Name</th>
			<td class="col-md-4"><c:out value="${role.name}" /></td>
			<th class="col-md-2">Currently&nbsp;On&nbsp;Call</th>
			<td class="col-md-4">
			<c:forEach var="scheduledUser" items="${role.currentUsers}">
				<c:out value="${scheduledUser}" />
			</c:forEach></td>
		</tr>
		<tr class="d-flex">
			<th class="col-md-2">Supervisor</th>
			<td class="col-md-4"><c:out value="${role.defaultUser}" /></td>
			<th class="col-md-2">Membership&nbsp;Group</th>
			<td class="col-md-4"><c:out value="${role.membershipGroup}" /></td>
		</tr>
		<tr class="d-flex">
			<th class="col-md-2">Description</th>
			<td class="col-md-10" colspan="3"><c:out value="${role.description}" /></td>
		</tr>
	</table>
</div>

<form action="<c:url value='${reqUrl}'/>" method="post" name="prevMonthForm">
	<input type="hidden" name="operation" value="view"/>
	<input type="hidden" name="role" value="<c:out value='${role.name}'/>"/>
	<input type="hidden" name="month" value="<fmt:formatDate value='${calendar.previousMonth}' type='date' pattern='MM-yyyy'/>"/>
</form>
<form action="<c:url value='${reqUrl}'/>" method="post" name="nextMonthForm">
	<input type="hidden" name="operation" value="view"/>
	<input type="hidden" name="role" value="<c:out value='${role.name}'/>"/>
	<input type="hidden" name="month" value="<fmt:formatDate value='${calendar.nextMonth}' type='date' pattern='MM-yyyy'/>"/>
</form>

<div class="card">
	<div class="card-header">
		<span>Role Schedule</span>
	</div>

	<table class="table table-sm table-bordered severity">
			<caption class="text-center">
				<button class="btn btn-secondary" onclick="prevMonth()">&laquo;</button>
				&nbsp;
				<strong><c:out value="${calendar.monthAndYear}"/></strong>
				&nbsp;
				<button class="btn btn-secondary" onclick="nextMonth()">&raquo;</button>
			</caption>
				<tr>
				<c:forEach var="day" items="${calendar.weeks[0].days}">
				<th>
					<b><c:out value="${day.dayOfWeek}"/></b>
				</th>
				</c:forEach>
				</tr>
				<c:forEach var="week" items="${calendar.weeks}">
				<tr>
					<c:forEach var="day" items="${week.days}">
					<td>
					<c:if test="${calendar.month == day.month}">
						<p><strong><c:out value="${day.dayOfMonth}"/></strong></p>
						<c:forEach var="entry" items="${day.entries}">
							<fmt:formatDate value="${entry.startTime}" type="time" pattern="hh:mm'&nbsp;'a"/>:
							<c:forEach var="owner" items="${entry.labels}">&nbsp;
								<c:choose>
									<c:when test="${owner.supervisor}">
										<div class="label label-default">Unscheduled</div><br/>
									</c:when>
									<c:otherwise>
										<div class="label label-primary"><c:out value="${owner.user}"/></div><br/>
									</c:otherwise>
								</c:choose>
							</c:forEach>
						</c:forEach>
					</c:if>
					</td>
					</c:forEach>
				</tr>
				</c:forEach>
	</table>
</div>

<form class="form-inline" action="<c:url value='${reqUrl}'/>" method="post" name="doneForm">
	<input class="form-control" type="submit" value="Done" />
</form>

<jsp:include page="/includes/bootstrap-footer.jsp" flush="false" />
