/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.memoryusage.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.AttachmentProvider;
import org.apache.felix.webconsole.ConfigurationPrinter;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.plugins.memoryusage.internal.MemoryUsageSupport;

class MemoryUsagePanel
extends AbstractWebConsolePlugin
implements ConfigurationPrinter,
AttachmentProvider {
    private final MemoryUsageSupport support;

    MemoryUsagePanel(MemoryUsageSupport support) {
        this.support = support;
        this.activate(support.getBundleContext());
    }

    public String getLabel() {
        return "memoryusage";
    }

    public String getTitle() {
        return "%dump.title";
    }

    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws IOException {
        PrintWriter pw = res.getWriter();
        StringBuilder statusBuf = new StringBuilder(1024);
        statusBuf.append('{');
        StringBuilder filesBuf = new StringBuilder(1024);
        filesBuf.append('[');
        File[] files = this.support.getDumpFiles();
        if (files != null) {
            long totalSize = 0L;
            for (File file : files) {
                filesBuf.append('{');
                filesBuf.append("'name':'").append(file.getName());
                filesBuf.append("',").append("'date':").append(file.lastModified());
                this.support.formatNumber(filesBuf, "size", file.length());
                filesBuf.append("},");
                totalSize += file.length();
            }
            statusBuf.append("'files':").append(files.length);
            this.support.formatNumber(statusBuf, "total", totalSize);
        } else {
            statusBuf.append("'files':0,'total':0");
        }
        filesBuf.append(']');
        statusBuf.append('}');
        JsonPrintHelper jph = new JsonPrintHelper();
        this.support.printOverallMemory(jph);
        DefaultVariableResolver resolver = (DefaultVariableResolver)WebConsoleUtil.getVariableResolver((ServletRequest)req);
        resolver.put((Object)"__files__", (Object)filesBuf.toString());
        resolver.put((Object)"__status__", (Object)statusBuf.toString());
        resolver.put((Object)"__threshold__", (Object)String.valueOf(this.support.getThreshold()));
        resolver.put((Object)"__interval__", (Object)String.valueOf(this.support.getInterval()));
        resolver.put((Object)"__overall__", (Object)jph.getString());
        resolver.put((Object)"__pools__", (Object)this.support.getMemoryPoolsJson());
        String template = this.readTemplateFile("/templates/memoryusage.html");
        pw.println(template);
    }

    public void printConfiguration(PrintWriter pw) {
        this.support.printMemory(new PrintWriterPrintHelper(pw));
    }

    public URL[] getAttachments(String mode) {
        File[] dumpFiles;
        if ("zip".equals(mode) && (dumpFiles = this.support.getDumpFiles()) != null && dumpFiles.length > 0) {
            URL[] attachs = new URL[dumpFiles.length];
            for (int i = 0; i < dumpFiles.length; ++i) {
                try {
                    attachs[i] = dumpFiles[i].toURI().toURL();
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return attachs;
        }
        return null;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DumpFile dumpFile = this.getDumpFile(request);
        if (dumpFile != null) {
            this.spool(dumpFile.dumpFile, response, dumpFile.compress);
        }
        super.doGet(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if ("DELETE".equals(req.getParameter("X-Request-Method"))) {
            this.doDelete(req, resp);
        } else {
            String command = WebConsoleUtil.getParameter((HttpServletRequest)req, (String)"command");
            if ("dump".equals(command)) {
                resp.setContentType("text/plain; charset=UTF-8");
                try {
                    File file = this.support.dumpHeap(null, false);
                    resp.getWriter().print("Dumped heap to " + file.getName());
                }
                catch (NoSuchElementException e) {
                    resp.getWriter().print("Failed dumping the heap, JVM does not provide known mechanism to create a Heap Dump");
                    this.support.log(1, "Heap Dump creation failed: JVM has no known Heap Dump API", new Object[0]);
                }
            } else if ("gc".equals(command)) {
                System.gc();
            } else if ("threshold".equals(command)) {
                try {
                    int threshold = Integer.parseInt(req.getParameter("threshold"));
                    this.support.setThreshold(threshold);
                }
                catch (Exception threshold) {
                    // empty catch block
                }
                resp.sendRedirect(req.getRequestURI());
            } else if ("interval".equals(command)) {
                try {
                    int interval = Integer.parseInt(req.getParameter("interval"));
                    this.support.setInterval(interval);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                resp.sendRedirect(req.getRequestURI());
            } else {
                super.doPost(req, resp);
            }
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        DumpFile dumpFile = this.getDumpFile(request);
        if (dumpFile != null) {
            dumpFile.dumpFile.delete();
            response.setStatus(200);
        } else {
            response.sendError(403);
        }
    }

    private DumpFile getDumpFile(HttpServletRequest request) {
        int lastSlash;
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && !pathInfo.endsWith(this.getLabel()) && (lastSlash = pathInfo.lastIndexOf(47)) > 0) {
            File dumpFile;
            String label = pathInfo.substring(lastSlash + 1);
            boolean isZip = false;
            if (label.endsWith(".zip")) {
                label = label.substring(0, label.length() - 4);
                isZip = true;
            }
            if ((dumpFile = this.support.getDumpFile(label)) != null) {
                return new DumpFile(dumpFile, isZip);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spool(File dumpFile, HttpServletResponse response, boolean compress) throws IOException {
        FileInputStream ins = null;
        try {
            ins = new FileInputStream(dumpFile);
            response.setDateHeader("Last-Modified", dumpFile.lastModified());
            WebConsoleUtil.setNoCache((HttpServletResponse)response);
            Object out = response.getOutputStream();
            if (compress) {
                ZipOutputStream zip = new ZipOutputStream((OutputStream)out);
                zip.setLevel(1);
                ZipEntry entry = new ZipEntry(dumpFile.getName());
                entry.setTime(dumpFile.lastModified());
                entry.setMethod(8);
                zip.putNextEntry(entry);
                out = zip;
                response.setContentType("application/zip");
            } else {
                String type = this.getServletContext().getMimeType(dumpFile.getName());
                if (type == null) {
                    type = "application/octet-stream";
                }
                response.setContentType(type);
                response.setHeader("Content-Length", String.valueOf(dumpFile.length()));
            }
            byte[] buf = new byte[32768];
            int rd = 0;
            while ((rd = ((InputStream)ins).read(buf)) >= 0) {
                ((OutputStream)out).write(buf, 0, rd);
            }
            if (compress) {
                ((OutputStream)out).flush();
                ((ZipOutputStream)out).closeEntry();
                ((ZipOutputStream)out).finish();
            }
        }
        finally {
            if (ins != null) {
                try {
                    ((InputStream)ins).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class JsonPrintHelper
    implements MemoryUsageSupport.PrintHelper {
        private final StringBuilder buf = new StringBuilder();

        JsonPrintHelper() {
            this.buf.append('{');
        }

        String getString() {
            String result = this.buf.append('}').toString();
            this.buf.delete(1, this.buf.length());
            return result;
        }

        public void title(String title, int level) {
        }

        public void keyVal(String key, Object value) {
            if (value == null) {
                this.val(key);
            } else {
                this.buf.append('\'');
                this.buf.append(key);
                this.buf.append("':'");
                this.buf.append(value);
                this.buf.append("',");
            }
        }

        public void val(String value) {
            this.buf.append("'");
            this.buf.append(value);
            this.buf.append("':'',");
        }
    }

    private static class PrintWriterPrintHelper
    implements MemoryUsageSupport.PrintHelper {
        private static final String INDENTS = "          ";
        private final PrintWriter pw;
        private String indent;

        PrintWriterPrintHelper(PrintWriter pw) {
            this.pw = pw;
            this.indent = "";
        }

        public void title(String title, int level) {
            this.pw.printf("%n%s%s%n", PrintWriterPrintHelper.getIndent(level), title);
            this.indent = PrintWriterPrintHelper.getIndent(level + 1);
        }

        public void val(String value) {
            this.pw.printf("%s%s%n", this.indent, value);
        }

        public void keyVal(String key, Object value) {
            if (value == null) {
                this.val(key);
            } else {
                this.pw.printf("%s%s: %s%n", this.indent, key, value);
            }
        }

        private static String getIndent(int level) {
            int indent = 2 * level;
            if (indent > INDENTS.length()) {
                return INDENTS;
            }
            return INDENTS.substring(0, indent);
        }
    }

    private static class DumpFile {
        final File dumpFile;
        final boolean compress;

        DumpFile(File dumpFile, boolean compress) {
            this.dumpFile = dumpFile;
            this.compress = compress;
        }
    }
}

