/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext2.cm.change;

import io.swagger.v3.oas.models.OpenAPI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import liquibase.ext2.cm.change.ConfigFileUtil;
import liquibase.ext2.cm.change.RegisterSchema;
import liquibase.ext2.cm.change.converter.PropertiesToJson;
import liquibase.ext2.cm.change.converter.XmlToJson;
import liquibase.util.file.FilenameUtils;
import org.opennms.features.config.dao.api.ConfigDefinition;
import org.opennms.features.config.dao.api.ConfigItem;
import org.opennms.features.config.dao.impl.util.OpenAPIBuilder;
import org.opennms.features.config.exception.ConfigConversionException;
import org.opennms.features.config.exception.ConfigRuntimeException;
import org.opennms.features.config.service.api.ConfigUpdateInfo;
import org.opennms.features.config.service.api.ConfigurationManagerService;
import org.opennms.features.config.service.api.JsonAsString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ImportConfigurationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterSchema.class);

    public static void importConfig(ConfigurationManagerService configurationManagerService, Resource configResource, ConfigUpdateInfo configurationIdentifier, Path archivePath) {
        Objects.requireNonNull(configurationManagerService);
        Objects.requireNonNull(configResource);
        Objects.requireNonNull(configurationIdentifier);
        Objects.requireNonNull(archivePath);
        LOG.info("Importing configuration from {} for {}", (Object)configResource.getFilename(), (Object)configurationIdentifier);
        try {
            JsonAsString configObject;
            ConfigDefinition configDefinition = (ConfigDefinition)configurationManagerService.getRegisteredConfigDefinition(configurationIdentifier.getConfigName()).orElseThrow(() -> new ConfigRuntimeException("Cannot find configDefinition for " + configurationIdentifier.getConfigName()));
            if (!configDefinition.getAllowMultiple() && !"default".equals(configurationIdentifier.getConfigId())) {
                throw new IllegalArgumentException(String.format("For the '%s' only one configuration can be provided (configId='%s')", configurationIdentifier.getConfigName(), "default"));
            }
            String fileType = FilenameUtils.getExtension((String)configResource.getFilename());
            if ("xml".equalsIgnoreCase(fileType)) {
                configObject = new XmlToJson(ConfigFileUtil.asString(configResource), configDefinition).getJson();
            } else if ("cfg".equalsIgnoreCase(fileType)) {
                ConfigItem schema = OpenAPIBuilder.createBuilder((String)configurationIdentifier.getConfigName(), (String)configurationIdentifier.getConfigName(), (String)"", (OpenAPI)configDefinition.getSchema()).getRootConfig();
                configObject = new PropertiesToJson(configResource.getInputStream(), schema).getJson();
            } else {
                throw new ConfigConversionException(String.format("Unknown file type: '%s'", fileType));
            }
            configurationManagerService.registerConfiguration(configurationIdentifier, configObject);
            LOG.info("Configuration {} imported.", (Object)configurationIdentifier);
            if (configResource.getURL().getFile().endsWith("/etc/" + configResource.getFilename())) {
                Path etcFile = configResource.getFile().getAbsoluteFile().toPath();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                Path archiveFile = Path.of(archivePath.toString(), etcFile.getFileName() + "." + formatter.format(LocalDateTime.now()));
                Files.move(etcFile, archiveFile, new CopyOption[0]);
                LOG.info("Configuration file {} moved to {}", (Object)etcFile, (Object)archivePath);
            }
        }
        catch (Exception e) {
            throw new ConfigRuntimeException("Error while importing config.", (Throwable)e);
        }
    }
}

