/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.util.HashSet;
import java.util.Set;
import org.opennms.netmgt.enlinkd.service.api.BridgeForwardingTable;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.BridgePortWithMacs;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyException;
import org.opennms.netmgt.enlinkd.service.api.Topology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgeSimpleConnection
implements Topology {
    static final Logger LOG = LoggerFactory.getLogger(BridgeSimpleConnection.class);
    private final BridgeForwardingTable m_xBridge;
    private final BridgeForwardingTable m_yBridge;
    private BridgePort m_xyPort;
    private BridgePort m_yxPort;

    public BridgePort getFirstPort() {
        return this.m_xyPort;
    }

    public BridgePort getSecondPort() {
        return this.m_yxPort;
    }

    public Integer getFirstBridgePort() {
        return this.m_xyPort.getBridgePort();
    }

    public Integer getSecondBridgePort() {
        return this.m_yxPort.getBridgePort();
    }

    private BridgeSimpleConnection(BridgeForwardingTable xBridge, BridgeForwardingTable yBridge) {
        this.m_xBridge = xBridge;
        this.m_yBridge = yBridge;
    }

    public void findSimpleConnection() throws BridgeTopologyException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("findSimpleConnection: \n first bridge -> \n{}\n second bridge -> \n{}", (Object)this.m_xBridge.printTopology(), (Object)this.m_yBridge.printTopology());
        }
        if (this.m_xBridge.getPorttomac().size() == 1) {
            this.m_xyPort = this.m_xBridge.getPorttomac().iterator().next().getPort();
            if (LOG.isDebugEnabled()) {
                LOG.debug("findSimpleConnectionForSizeOne: only one port found: bridge:[{}] <- {} ", (Object)this.m_yBridge.getNodeId(), (Object)this.m_xyPort.printTopology());
            }
        }
        if (this.m_yBridge.getPorttomac().size() == 1) {
            this.m_yxPort = this.m_yBridge.getPorttomac().iterator().next().getPort();
            if (LOG.isDebugEnabled()) {
                LOG.debug("findSimpleConnectionForSizeOne: only one port found: bridge:[{}] <- {} ", (Object)this.m_xBridge.getNodeId(), (Object)this.m_yxPort.printTopology());
            }
        }
        if (this.m_xyPort == null) {
            this.m_xyPort = BridgeSimpleConnection.findPortUsingBridgeIdentifiers(this.m_xBridge, this.m_yBridge.getIdentifiers());
        }
        if (this.m_yxPort == null) {
            this.m_yxPort = BridgeSimpleConnection.findPortUsingBridgeIdentifiers(this.m_yBridge, this.m_xBridge.getIdentifiers());
        }
        if (this.m_xyPort != null && this.m_yxPort != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("findSimpleConnection: success on condition 1 {} -> {}", (Object)this.m_xyPort.printTopology(), (Object)this.m_yxPort.printTopology());
            }
            return;
        }
        if (this.m_xyPort == null && this.m_yxPort != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("findSimpleConnection: try condition 2 YThenX {} -> {}", (Object)this.m_yxPort.printTopology(), (Object)this.m_xBridge.getNodeId());
            }
            this.m_xyPort = BridgeSimpleConnection.findPortUsingSimpleConnectionAlgorithm(this.m_xBridge, this.m_yBridge, this.m_yxPort);
            if (this.m_xyPort != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("findSimpleConnection: success on condition 2 YThenX {} -> {}", (Object)this.m_xyPort.printTopology(), (Object)this.m_yxPort.printTopology());
                }
                return;
            }
        }
        if (this.m_yxPort == null && this.m_xyPort != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("findSimpleConnection: try condition 2 XThenY {} -> {}", (Object)this.m_xyPort.printTopology(), (Object)this.m_yBridge.getNodeId());
            }
            this.m_yxPort = BridgeSimpleConnection.findPortUsingSimpleConnectionAlgorithm(this.m_yBridge, this.m_xBridge, this.m_xyPort);
            if (this.m_yxPort != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("findSimpleConnection: success on condition 2 XThenY {} -> {}", (Object)this.m_xyPort.printTopology(), (Object)this.m_yxPort.printTopology());
                }
                return;
            }
        }
        this.m_xyPort = BridgeSimpleConnection.findPortUsingSimpleConnectionAlgorithm(this.m_xBridge, this.m_yBridge);
        if (this.m_xyPort != null) {
            this.m_yxPort = BridgeSimpleConnection.findPortUsingSimpleConnectionAlgorithm(this.m_yBridge, this.m_xBridge, this.m_xyPort);
            if (this.m_yxPort != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("findSimpleConnection: success on condition 3 XThenY {} -> {}", (Object)this.m_xyPort.printTopology(), (Object)this.m_yxPort.printTopology());
                }
                return;
            }
        }
        this.m_yxPort = BridgeSimpleConnection.findPortUsingSimpleConnectionAlgorithm(this.m_yBridge, this.m_xBridge);
        if (this.m_yxPort != null) {
            this.m_xyPort = BridgeSimpleConnection.findPortUsingSimpleConnectionAlgorithm(this.m_xBridge, this.m_yBridge, this.m_yxPort);
            if (this.m_xyPort != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("findSimpleConnection: success on condition 3 YThenX {} -> {}", (Object)this.m_xyPort.printTopology(), (Object)this.m_yxPort.printTopology());
                }
                return;
            }
        }
        if (this.m_xBridge.getPorttomac().size() == 2 && this.m_yBridge.getPorttomac().size() == 2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("findSimpleConnectionForSizeTwo: bridge [{}] {} ports -> bridge [{}] {} ports", new Object[]{this.m_xBridge.getNodeId(), this.m_xBridge.getPorttomac().size(), this.m_yBridge.getNodeId(), this.m_yBridge.getPorttomac().size()});
            }
            BridgePort bridgeXElectedPort = this.m_xBridge.getPorttomac().iterator().next().getPort();
            Set<String> commonSegmentMacAddress = this.m_xBridge.getBridgePortWithMacs(bridgeXElectedPort).getMacs();
            block0: for (BridgePortWithMacs yBridgeBridgePortWithMac : this.m_yBridge.getPorttomac()) {
                for (String mac : yBridgeBridgePortWithMac.getMacs()) {
                    if (!commonSegmentMacAddress.contains(mac)) continue;
                    continue block0;
                }
                this.m_xyPort = bridgeXElectedPort;
                this.m_yxPort = yBridgeBridgePortWithMac.getPort();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("findSimpleConnectionForSizeTwo: simple connection ports found [{}] -> [{}]", (Object)this.m_xyPort.printTopology(), (Object)this.m_yxPort.printTopology());
                }
                return;
            }
            LOG.warn("findSimpleConnectionForSizeTwo: no simple connection ports found [{}] -> [{}]", (Object)this.m_xBridge.getNodeId(), (Object)this.m_yBridge.getNodeId());
        }
        if (this.m_xyPort == null || this.m_yxPort == null) {
            throw new BridgeTopologyException("findSimpleConnection: no simple connection found", this.m_xBridge);
        }
    }

    private static BridgePort findPortUsingSimpleConnectionAlgorithm(BridgeForwardingTable bftA, BridgeForwardingTable bftB, BridgePort pba) {
        for (String mac : bftA.getBftMacs()) {
            if (!bftB.getBftMacs().contains(mac) || pba.equals(bftB.getMactoport().get(mac))) continue;
            return bftA.getMactoport().get(mac);
        }
        return null;
    }

    private static BridgePort findPortUsingSimpleConnectionAlgorithm(BridgeForwardingTable bftA, BridgeForwardingTable bftB) {
        HashSet<String> commonLearnedMacs = new HashSet<String>(bftA.getBftMacs());
        commonLearnedMacs.retainAll(new HashSet<String>(bftB.getBftMacs()));
        String[] array = commonLearnedMacs.toArray(new String[0]);
        for (int i = 0; i < array.length; ++i) {
            BridgePort pab = bftA.getMactoport().get(array[i]);
            BridgePort pb1 = bftB.getMactoport().get(array[i]);
            for (int j = i + 1; j < array.length; ++j) {
                if (bftB.getMactoport().get(array[j]).getBridgePort().intValue() == pb1.getBridgePort().intValue() || bftA.getMactoport().get(array[j]).getBridgePort().intValue() != pab.getBridgePort().intValue()) continue;
                return pab;
            }
        }
        return null;
    }

    private static BridgePort findPortUsingBridgeIdentifiers(BridgeForwardingTable bft, Set<String> identifiers) {
        for (String mac : identifiers) {
            if (!bft.getMactoport().containsKey(mac)) continue;
            return bft.getMactoport().get(mac);
        }
        return null;
    }

    public static BridgeSimpleConnection create(BridgeForwardingTable xBridge, BridgeForwardingTable yBridge) {
        return new BridgeSimpleConnection(xBridge, yBridge);
    }

    @Override
    public String printTopology() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("simple connection: [");
        if (this.m_xyPort != null) {
            stringBuilder.append(this.m_xyPort.printTopology());
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append("], <--> [");
        if (this.m_yxPort != null) {
            stringBuilder.append(this.m_yxPort.printTopology());
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

