/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.netmgt.dao.api.AlarmAssociationDao;
import org.opennms.netmgt.dao.mock.AbstractMockDao;
import org.opennms.netmgt.model.AlarmAssociation;
import org.opennms.netmgt.model.OnmsAlarm;

public class MockAlarmAssociationDao
extends AbstractMockDao<AlarmAssociation, Integer>
implements AlarmAssociationDao {
    private AtomicInteger m_id = new AtomicInteger(0);

    @Override
    public Integer save(AlarmAssociation ass) {
        Integer retval = (Integer)super.save(ass);
        this.updateSubObjects(ass);
        return retval;
    }

    @Override
    public void update(AlarmAssociation ass) {
        super.update(ass);
        this.updateSubObjects(ass);
    }

    private void updateSubObjects(AlarmAssociation ass) {
        if (ass.getRelatedAlarm().getId() == null) {
            this.getAlarmDao().save((Object)ass.getRelatedAlarm());
        }
        if (ass.getSituationAlarm().getId() == null) {
            this.getAlarmDao().save((Object)ass.getSituationAlarm());
        }
    }

    @Override
    protected void generateId(AlarmAssociation ass) {
        ass.setId(Integer.valueOf(this.m_id.incrementAndGet()));
    }

    @Override
    protected Integer getId(AlarmAssociation ass) {
        return ass.getId();
    }

    public List<AlarmAssociation> getAssociationsForSituation(int situationId) {
        OnmsAlarm alarm = (OnmsAlarm)this.getAlarmDao().get((Serializable)Integer.valueOf(situationId));
        if (alarm == null) {
            return Collections.emptyList();
        }
        return new ArrayList<AlarmAssociation>(alarm.getAssociatedAlarms());
    }
}

