/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.syslog;

import org.graylog2.syslog4j.Syslog;
import org.graylog2.syslog4j.SyslogConfigIF;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.net.tcp.TCPNetSyslogConfig;
import org.graylog2.syslog4j.impl.net.udp.UDPNetSyslogConfig;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogDestination;
import org.opennms.netmgt.model.OnmsSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SyslogUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogUtils.class);

    public static void createNorthboundInstance(SyslogDestination destination) throws SyslogRuntimeException {
        LOG.info("Creating Syslog Northbound Instance {}", (Object)destination.getName());
        int facility = SyslogUtils.convertFacility(destination.getFacility());
        SyslogDestination.SyslogProtocol protocol = destination.getProtocol();
        SyslogConfigIF instanceConfiguration = SyslogUtils.createConfig(destination, protocol, facility);
        instanceConfiguration.setIdent("OpenNMS");
        instanceConfiguration.setCharSet(destination.getCharSet());
        instanceConfiguration.setMaxMessageLength(destination.getMaxMessageLength().intValue());
        instanceConfiguration.setSendLocalName(destination.isSendLocalName().booleanValue());
        instanceConfiguration.setSendLocalTimestamp(destination.isSendLocalTime().booleanValue());
        instanceConfiguration.setTruncateMessage(destination.isTruncateMessage().booleanValue());
        try {
            Syslog.createInstance((String)destination.getName(), (SyslogConfigIF)instanceConfiguration);
        }
        catch (SyslogRuntimeException e) {
            LOG.error("Could not create northbound instance, '{}': {}", (Object)destination.getName(), (Object)e);
            throw e;
        }
    }

    public static SyslogConfigIF createConfig(SyslogDestination dest, SyslogDestination.SyslogProtocol protocol, int fac) {
        UDPNetSyslogConfig config;
        switch (protocol) {
            case UDP: {
                config = new UDPNetSyslogConfig(fac, dest.getHost(), dest.getPort().intValue());
                break;
            }
            case TCP: {
                config = new TCPNetSyslogConfig(fac, dest.getHost(), dest.getPort().intValue());
                break;
            }
            default: {
                config = new UDPNetSyslogConfig(fac, "localhost", 514);
            }
        }
        return config;
    }

    public static int convertFacility(SyslogDestination.SyslogFacility facility) {
        int fac;
        switch (facility) {
            case KERN: {
                fac = 0;
                break;
            }
            case USER: {
                fac = 8;
                break;
            }
            case MAIL: {
                fac = 16;
                break;
            }
            case DAEMON: {
                fac = 24;
                break;
            }
            case AUTH: {
                fac = 32;
                break;
            }
            case SYSLOG: {
                fac = 40;
                break;
            }
            case LPR: {
                fac = 48;
                break;
            }
            case NEWS: {
                fac = 56;
                break;
            }
            case UUCP: {
                fac = 64;
                break;
            }
            case CRON: {
                fac = 72;
                break;
            }
            case AUTHPRIV: {
                fac = 80;
                break;
            }
            case FTP: {
                fac = 88;
                break;
            }
            case LOCAL0: {
                fac = 128;
                break;
            }
            case LOCAL1: {
                fac = 136;
                break;
            }
            case LOCAL2: {
                fac = 144;
                break;
            }
            case LOCAL3: {
                fac = 152;
                break;
            }
            case LOCAL4: {
                fac = 160;
                break;
            }
            case LOCAL5: {
                fac = 168;
                break;
            }
            case LOCAL6: {
                fac = 176;
                break;
            }
            case LOCAL7: {
                fac = 184;
                break;
            }
            default: {
                fac = 8;
            }
        }
        return fac;
    }

    public static int determineLogLevel(OnmsSeverity severity) {
        int level;
        switch (severity) {
            case CRITICAL: {
                level = 2;
                break;
            }
            case MAJOR: {
                level = 3;
                break;
            }
            case MINOR: {
                level = 3;
                break;
            }
            case WARNING: {
                level = 4;
                break;
            }
            case NORMAL: {
                level = 5;
                break;
            }
            case CLEARED: {
                level = 6;
                break;
            }
            case INDETERMINATE: {
                level = 7;
                break;
            }
            default: {
                level = 4;
            }
        }
        return level;
    }
}

