/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.syslog;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.opennms.netmgt.alarmd.api.Destination;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogFilter;

@XmlRootElement(name="syslog-destination")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SyslogDestination
implements Destination {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="destination-name", required=true)
    private String m_destinationName;
    @XmlElement(name="host", defaultValue="localhost", required=false)
    private String m_host;
    @XmlElement(name="port", defaultValue="514", required=false)
    private Integer m_port;
    @XmlElement(name="ip-protocol", defaultValue="udp", required=false)
    private SyslogProtocol m_protocol;
    @XmlElement(name="facility", defaultValue="USER", required=false)
    private SyslogFacility m_facility;
    @XmlElement(name="char-set", defaultValue="UTF-8", required=false)
    private String m_charSet;
    @XmlElement(name="max-message-length", defaultValue="1024", required=false)
    private Integer m_maxMessageLength = 1024;
    @XmlElement(name="send-local-name", defaultValue="true", required=false)
    private Boolean m_sendLocalName;
    @XmlElement(name="send-local-time", defaultValue="true", required=false)
    private Boolean m_sendLocalTime;
    @XmlElement(name="truncate-message", defaultValue="false", required=false)
    private Boolean m_truncateMessage;
    @XmlElement(name="first-occurrence-only", defaultValue="false", required=false)
    private Boolean m_firstOccurrenceOnly;
    @XmlElement(name="filter", required=false)
    private List<SyslogFilter> m_filters = new ArrayList<SyslogFilter>();

    public SyslogDestination() {
    }

    public SyslogDestination(String name, SyslogProtocol protocol, SyslogFacility facility) {
        this.m_destinationName = name;
        this.m_protocol = protocol;
        this.m_facility = facility;
    }

    public String getName() {
        return this.m_destinationName;
    }

    public void setName(String name) {
        this.m_destinationName = name;
    }

    public String getHost() {
        return this.m_host == null ? "localhost" : this.m_host;
    }

    public void setHost(String m_host) {
        this.m_host = m_host;
    }

    public Integer getPort() {
        return this.m_port == null ? 514 : this.m_port;
    }

    public void setPort(Integer m_port) {
        this.m_port = m_port;
    }

    public SyslogProtocol getProtocol() {
        return this.m_protocol == null ? SyslogProtocol.UDP : this.m_protocol;
    }

    public void setProtocol(SyslogProtocol m_protocol) {
        this.m_protocol = m_protocol;
    }

    public SyslogFacility getFacility() {
        return this.m_facility == null ? SyslogFacility.USER : this.m_facility;
    }

    public String getCharSet() {
        return this.m_charSet == null ? StandardCharsets.UTF_8.name() : this.m_charSet;
    }

    public void setCharSet(String charSet) {
        this.m_charSet = charSet;
    }

    public Integer getMaxMessageLength() {
        return this.m_maxMessageLength == null ? 1024 : this.m_maxMessageLength;
    }

    public void setMaxMessageLength(Integer maxMessageLength) {
        this.m_maxMessageLength = maxMessageLength;
    }

    public Boolean isSendLocalName() {
        return this.m_sendLocalName == null ? Boolean.TRUE : this.m_sendLocalName;
    }

    public void setSendLocalName(Boolean sendLocalName) {
        this.m_sendLocalName = sendLocalName;
    }

    public Boolean isSendLocalTime() {
        return this.m_sendLocalTime == null ? Boolean.TRUE : this.m_sendLocalTime;
    }

    public void setSendLocalTime(Boolean sendLocalTime) {
        this.m_sendLocalTime = sendLocalTime;
    }

    public Boolean isTruncateMessage() {
        return this.m_truncateMessage == null ? Boolean.FALSE : this.m_truncateMessage;
    }

    public void setTruncateMessage(Boolean truncateMessage) {
        this.m_truncateMessage = truncateMessage;
    }

    public boolean isFirstOccurrenceOnly() {
        return this.m_firstOccurrenceOnly == null ? Boolean.FALSE : this.m_firstOccurrenceOnly;
    }

    public void setFirstOccurrenceOnly(Boolean firstOccurrenceOnly) {
        this.m_firstOccurrenceOnly = firstOccurrenceOnly;
    }

    public List<SyslogFilter> getFilters() {
        return this.m_filters;
    }

    public void setFilters(List<SyslogFilter> filters) {
        this.m_filters = filters;
    }

    public boolean passFilter(NorthboundAlarm alarm) {
        if (this.m_filters != null && !this.m_filters.isEmpty()) {
            for (SyslogFilter filter : this.m_filters) {
                if (!filter.passFilter(alarm)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public String getCustomMessageFormat(NorthboundAlarm alarm) {
        if (this.m_filters != null) {
            for (SyslogFilter filter : this.m_filters) {
                if (filter.getMessageFormat() == null || !filter.passFilter(alarm)) continue;
                return filter.getMessageFormat();
            }
        }
        return null;
    }

    @XmlType
    @XmlEnum(value=String.class)
    public static enum SyslogFacility {
        KERN("KERN"),
        USER("USER"),
        MAIL("MAIL"),
        DAEMON("DAEMON"),
        AUTH("AUTH"),
        SYSLOG("SYSLOG"),
        LPR("LPR"),
        NEWS("NEWS"),
        UUCP("UUCP"),
        CRON("CRON"),
        AUTHPRIV("AUTHPRIV"),
        FTP("FTP"),
        LOCAL0("LOCAL0"),
        LOCAL1("LOCAL1"),
        LOCAL2("LOCAL2"),
        LOCAL3("LOCAL3"),
        LOCAL4("LOCAL4"),
        LOCAL5("LOCAL5"),
        LOCAL6("LOCAL6"),
        LOCAL7("LOCAL7");

        private String m_id;

        private SyslogFacility(String facility) {
            this.m_id = facility;
        }

        public String getId() {
            return this.m_id;
        }
    }

    @XmlType
    @XmlEnum(value=String.class)
    public static enum SyslogProtocol {
        UDP("udp"),
        TCP("tcp");

        private String m_id;

        private SyslogProtocol(String id) {
            this.m_id = id;
        }

        public String getId() {
            return this.m_id;
        }
    }
}

