/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.NodeCollectionGroupLldp;
import org.opennms.netmgt.enlinkd.common.NodeCollector;
import org.opennms.netmgt.enlinkd.service.api.LldpTopologyService;
import org.opennms.netmgt.enlinkd.service.api.Node;
import org.opennms.netmgt.enlinkd.snmp.LldpLocPortGetter;
import org.opennms.netmgt.enlinkd.snmp.LldpLocalGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.LldpLocalTableTracker;
import org.opennms.netmgt.enlinkd.snmp.LldpRemTableTracker;
import org.opennms.netmgt.enlinkd.snmp.MtxrLldpRemTableTracker;
import org.opennms.netmgt.enlinkd.snmp.MtxrNeighborTableTracker;
import org.opennms.netmgt.enlinkd.snmp.TimeTetraLldpLocPortGetter;
import org.opennms.netmgt.enlinkd.snmp.TimeTetraLldpRemTableTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryLldp
extends NodeCollector {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryLldp.class);
    private static final String DW_SYSOID = ".1.3.6.1.4.1.7262.2.4";
    private static final String DW_NULL_CHASSIS_ID = "cf";
    private static final String DW_NULL_SYSOID_ID = "NuDesign";
    private static final String TIMETETRA_SYSOID = ".1.3.6.1.4.1.6527";
    private static final String MTXR_SYSOID = ".1.3.6.1.4.1.14988";
    private final LldpTopologyService m_lldpTopologyService;

    public NodeDiscoveryLldp(NodeCollectionGroupLldp group, Node node, int priority) {
        super(group.getLocationAwareSnmpClient(), node, priority);
        this.m_lldpTopologyService = group.getLldpTopologyService();
    }

    public void collect() {
        Date now = new Date();
        LldpLocalGroupTracker lldpLocalGroup = new LldpLocalGroupTracker();
        SnmpAgentConfig peer = this.getSnmpAgentConfig();
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)lldpLocalGroup).withDescription("lldpLocalGroup").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: LLDP_MIB not supported {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: LLDP_MIB not supported {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        if (lldpLocalGroup.getLldpLocChassisid() == null) {
            if (this.walkMtrx(peer, lldpLocalGroup.getLldpLocSysname())) {
                this.m_lldpTopologyService.reconcile(this.getNodeId(), now);
                return;
            }
            LOG.info("run: node[{}]: LLDP_MIB not supported", (Object)this.getNodeId());
            return;
        }
        LOG.debug("run: node[{}]: lldp identifier : {}", (Object)this.getNodeId(), (Object)lldpLocalGroup.getLldpElement().getLldpChassisId());
        this.m_lldpTopologyService.store(this.getNodeId(), lldpLocalGroup.getLldpElement());
        if (this.isInactiveDragonWave(lldpLocalGroup)) {
            this.m_lldpTopologyService.reconcile(this.getNodeId(), now);
            return;
        }
        if (!this.walkLldpRemTable(peer) && this.getSysoid() != null && this.getSysoid().startsWith(TIMETETRA_SYSOID)) {
            this.walkTimeTetra(peer);
        }
        this.m_lldpTopologyService.reconcile(this.getNodeId(), now);
    }

    private boolean isInactiveDragonWave(LldpLocalGroupTracker lldpLocalGroup) {
        if (this.getSysoid() == null || this.getSysoid().equals(DW_SYSOID)) {
            if (lldpLocalGroup.getLldpLocChassisid().toHexString().equals(DW_NULL_CHASSIS_ID) && lldpLocalGroup.getLldpLocChassisidSubType().intValue() == LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_CHASSISCOMPONENT.getValue().intValue()) {
                LOG.info("run: node[{}]: address {}. lldp identifier : {}. lldp not active for Dragon Wave Device.", new Object[]{this.getNodeId(), this.getPrimaryIpAddressString(), lldpLocalGroup.getLldpElement()});
                return true;
            }
            if (lldpLocalGroup.getLldpLocSysname().equals(DW_NULL_SYSOID_ID)) {
                LOG.info("run: node[{}]: lldp identifier : {}. lldp not active for Dragon Wave Device.", (Object)this.getNodeId(), (Object)lldpLocalGroup.getLldpElement());
                return true;
            }
        }
        return false;
    }

    private boolean walkLldpRemTable(SnmpAgentConfig peer) {
        final ArrayList<LldpRemTableTracker.LldpRemRow> links = new ArrayList<LldpRemTableTracker.LldpRemRow>();
        LldpRemTableTracker lldpRemTable = new LldpRemTableTracker(){

            @Override
            public void processLldpRemRow(LldpRemTableTracker.LldpRemRow row) {
                links.add(row);
            }
        };
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)lldpRemTable).withDescription("lldpRemTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.debug("run: node [{}]: ExecutionException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return false;
        }
        catch (InterruptedException e) {
            LOG.debug("run: node [{}]: InterruptedException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return false;
        }
        if (links.isEmpty()) {
            LOG.info("run: no remote table entry found walking LLDP-MIB");
            return false;
        }
        LOG.info("run: {} remote table entry found walking LLDP-MIB", (Object)links.size());
        this.storeLldpLinks(links, new LldpLocPortGetter(peer, this.getLocationAwareSnmpClient(), this.getLocation()));
        return true;
    }

    private boolean walkMtrx(SnmpAgentConfig peer, String sysname) {
        if (this.getSysoid() == null || !this.getSysoid().startsWith(MTXR_SYSOID)) {
            return false;
        }
        final HashMap<Integer, LldpLocalTableTracker.LldpLocalPortRow> mtxrLldpLocalPortMap = new HashMap<Integer, LldpLocalTableTracker.LldpLocalPortRow>();
        LldpLocalTableTracker mtxrLldpLocalTable = new LldpLocalTableTracker(){

            @Override
            public void processLldpLocPortRow(LldpLocalTableTracker.LldpLocalPortRow row) {
                LOG.debug("processLldpLocPortRow: mtxrIndex {} -> {} {} {}", new Object[]{row.getMtxrIndex(), row.getLldpLocalPortIdSubtype(), row.getLldpLocPortId(), row.getLldpLocPortDesc()});
                mtxrLldpLocalPortMap.put(row.getMtxrIndex(), row);
            }
        };
        final HashMap mtxrNeighborMap = new HashMap();
        MtxrNeighborTableTracker mtxrNeighborTable = new MtxrNeighborTableTracker(){

            @Override
            public void processMtxrIndexPortRow(MtxrNeighborTableTracker.MtxrNeighborRow row) {
                mtxrNeighborMap.put(row.getMtxrNeighborIndex(), row.getMtxrNeighborInterfaceId());
            }
        };
        final ArrayList mtxrlldprowss = new ArrayList();
        MtxrLldpRemTableTracker mtxrLldpRemTable = new MtxrLldpRemTableTracker(){

            @Override
            public void processMtxrLldpRemRow(MtxrLldpRemTableTracker.MtxrLldpRemRow row) {
                mtxrlldprowss.add(row);
            }
        };
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)mtxrLldpRemTable).withDescription("mtxrLldpRemTable").withLocation(this.getLocation()).execute().get();
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)mtxrLldpLocalTable).withDescription("mtxrLldpLocalTable").withLocation(this.getLocation()).execute().get();
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)mtxrNeighborTable).withDescription("mtxrNeighborTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.debug("run: node [{}]: ExecutionException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return false;
        }
        catch (InterruptedException e) {
            LOG.debug("run: node [{}]: InterruptedException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return false;
        }
        this.m_lldpTopologyService.store(this.getNodeId(), LldpLocalTableTracker.getLldpElement(sysname, mtxrLldpLocalPortMap.values()));
        for (MtxrLldpRemTableTracker.MtxrLldpRemRow mtxrLldpRemRow : mtxrlldprowss) {
            this.m_lldpTopologyService.store(this.getNodeId(), LldpLocalTableTracker.getLldpLink(mtxrLldpRemRow, (Integer)mtxrNeighborMap.get(mtxrLldpRemRow.getMtxrNeighborIndex()), mtxrLldpLocalPortMap));
        }
        return true;
    }

    private void walkTimeTetra(SnmpAgentConfig peer) {
        LOG.info("run: no remote table entry found. Try to walk TimeTetra-LLDP-MIB");
        final ArrayList<TimeTetraLldpRemTableTracker.TimeTetraLldpRemRow> ttlinks = new ArrayList<TimeTetraLldpRemTableTracker.TimeTetraLldpRemRow>();
        TimeTetraLldpRemTableTracker timeTetraLldpRemTableTracker = new TimeTetraLldpRemTableTracker(){

            @Override
            public void processLldpRemRow(TimeTetraLldpRemTableTracker.TimeTetraLldpRemRow row) {
                ttlinks.add(row);
            }
        };
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)timeTetraLldpRemTableTracker).withDescription("timeTetraLldpRemTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.debug("run: node [{}]: ExecutionException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.debug("run: node [{}]: InterruptedException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        LOG.info("run: {} remote table entry found walking TIMETETRA-LLDP-MIB", (Object)ttlinks.size());
        this.storeTimeTetraLldpLinks(ttlinks, new TimeTetraLldpLocPortGetter(peer, this.getLocationAwareSnmpClient(), this.getLocation()));
    }

    private void storeTimeTetraLldpLinks(List<TimeTetraLldpRemTableTracker.TimeTetraLldpRemRow> rows, TimeTetraLldpLocPortGetter timeTetraLldpLocPortGetter) {
        for (TimeTetraLldpRemTableTracker.TimeTetraLldpRemRow row : rows) {
            this.m_lldpTopologyService.store(this.getNodeId(), timeTetraLldpLocPortGetter.getLldpLink(row));
        }
    }

    private void storeLldpLinks(List<LldpRemTableTracker.LldpRemRow> links, LldpLocPortGetter lldpLocPortGetter) {
        for (LldpRemTableTracker.LldpRemRow row : links) {
            this.m_lldpTopologyService.store(this.getNodeId(), lldpLocPortGetter.getLldpLink(row));
        }
    }

    public String getName() {
        return "NodeDiscoveryLldp";
    }
}

