/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.timeseries.plugin.shell;

import java.util.Collection;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.timeseries.plugin.InMemoryStorage;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.TimeSeriesStorage;

@Command(scope="opennms", name="get-tss-plugin-metrics", description="Print all collected metrics")
@Service
public class GetMetricsCommand
implements Action {
    @Reference
    private TimeSeriesStorage storage;

    public Object execute() {
        ((InMemoryStorage)this.storage).getAllMetrics().entrySet().forEach(entry -> {
            System.out.println(String.format("Metric <%s> has %d data points", ((Metric)entry.getKey()).getKey(), ((Collection)entry.getValue()).size()));
            ((Collection)entry.getValue()).stream().forEach(dataPoint -> System.out.printf("\t%d:%f\n", dataPoint.getTime().toEpochMilli(), dataPoint.getValue()));
        });
        return null;
    }
}

